/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.glassfish.admingui.common.servlet.DownloadServlet;
import org.glassfish.admingui.common.util.RestUtil;

public class LogFilesContentSource
implements DownloadServlet.ContentSource {
    @Override
    public String getId() {
        return "LogFiles";
    }

    @Override
    public InputStream getInputStream(DownloadServlet.Context ctx) {
        ctx.setAttribute("extension", "CLIENT-STUBS");
        HttpServletRequest request = (HttpServletRequest)ctx.getServletRequest();
        String target = request.getParameter("target");
        String restUrl = request.getParameter("restUrl");
        FileInputStream tmpFile = null;
        try {
            String endpoint = restUrl + "/collect-log-files";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = "log-files-" + target + "-" + dateFormat.format(date) + ".zip";
            File file = new File(tempDir, fileName);
            attrsMap.put("id", file.getAbsolutePath());
            attrsMap.put("retrieve", "true");
            attrsMap.put("target", target);
            RestUtil.postRestRequestFromServlet(request, endpoint, attrsMap, true, true);
            tmpFile = new FileInputStream(file);
            file.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ctx.setAttribute("tmpFile", tmpFile);
        return tmpFile;
    }

    @Override
    public void cleanUp(DownloadServlet.Context ctx) {
        InputStream tmpFile = (InputStream)ctx.getAttribute("tmpFile");
        if (tmpFile != null) {
            try {
                tmpFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.removeAttribute("tmpFile");
    }

    @Override
    public long getLastModified(DownloadServlet.Context context) {
        return -1L;
    }
}

