/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.xml.ws.api.client.ServiceInterceptor;
import com.sun.xml.ws.developer.WSBindingProvider;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.soap.SOAPBinding;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.LogUtils;

public class PortCreationCallbackImpl
extends ServiceInterceptor {
    private ServiceReferenceDescriptor ref;
    private static Logger logger = LogUtils.getLogger();

    public PortCreationCallbackImpl(ServiceReferenceDescriptor svcRef) {
        this.ref = svcRef;
    }

    public void postCreateProxy(WSBindingProvider bp, Class<?> serviceEndpointInterface) {
        ServiceRefPortInfo portInfo = this.ref.getPortInfoBySEI(serviceEndpointInterface.getName());
        if (portInfo != null) {
            boolean mtomEnabled = false;
            if (portInfo.getMtomEnabled() != null && Boolean.valueOf(portInfo.getMtomEnabled()).booleanValue()) {
                mtomEnabled = true;
            }
            if (mtomEnabled) {
                Binding bType = bp.getBinding();
                if (SOAPBinding.class.isAssignableFrom(bType.getClass())) {
                    ((SOAPBinding)bType).setMTOMEnabled(true);
                } else {
                    logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00021", portInfo.getName());
                }
            }
            Set properties = portInfo.getStubProperties();
            for (NameValuePairDescriptor next : properties) {
                bp.getRequestContext().put(next.getName(), next.getValue());
            }
        }
    }

    public void postCreateDispatch(WSBindingProvider bp) {
    }
}

