/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Properties;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.persistence.common.Java2DBProcessorHelper;

public class CMPProcessor {
    private static Logger logger = LogHelperEJBCompiler.getLogger();
    private Java2DBProcessorHelper helper;
    private final DeploymentContext ctx;

    public CMPProcessor(DeploymentContext ctx) {
        this.ctx = ctx;
    }

    public void process() {
        EjbBundleDescriptorImpl bundle = (EjbBundleDescriptorImpl)this.ctx.getModuleMetaData(EjbBundleDescriptorImpl.class);
        ResourceReferenceDescriptor cmpResource = bundle.getCMPResourceReference();
        if (!DeploymentHelper.isJavaToDatabase((Properties)cmpResource.getSchemaGeneratorProperties())) {
            return;
        }
        this.helper = new Java2DBProcessorHelper(this.ctx);
        this.helper.init();
        SimpleJndiName resourceName = cmpResource.getJndiName();
        this.helper.setProcessorType("CMP", bundle.getName());
        this.helper.setJndiName(resourceName, bundle.getName());
        boolean userCreateTables = cmpResource.isCreateTablesAtDeploy();
        boolean createTables = this.helper.getCreateTables(userCreateTables);
        boolean userDropTables = cmpResource.isDropTablesAtUndeploy();
        logger.fine("ejb.CMPProcessor.createanddroptables", new Object[]{createTables, userDropTables});
        if (!createTables && !userDropTables) {
            return;
        }
        this.helper.setCreateTablesValue(userCreateTables, bundle.getName());
        this.helper.setDropTablesValue(userDropTables, bundle.getName());
        this.constructJdbcFileNames(bundle);
        if (logger.isLoggable(500)) {
            logger.fine("ejb.CMPProcessor.createanddropfilenames", (Object)this.helper.getCreateJdbcFileName(bundle.getName()), (Object)this.helper.getDropJdbcFileName(bundle.getName()));
        }
        if (createTables) {
            this.helper.createOrDropTablesInDB(true, "CMP");
        }
    }

    public void clean() {
        this.helper = new Java2DBProcessorHelper(this.ctx);
        this.helper.init();
        this.helper.createOrDropTablesInDB(false, "CMP");
    }

    private void constructJdbcFileNames(EjbBundleDescriptorImpl ejbBundle) {
        String filePrefix = DeploymentHelper.getDDLNamePrefix((Object)ejbBundle);
        this.helper.setCreateJdbcFileName(filePrefix + "_createDDL.jdbc", ejbBundle.getName());
        this.helper.setDropJdbcFileName(filePrefix + "_dropDDL.jdbc", ejbBundle.getName());
    }
}

