/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.appserv.connectors.internal.spi.BadConnectionEventListener;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.LocalTransactionImpl;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionMetaDataImpl;
import com.sun.gjc.spi.ResourceAdapterImpl;
import com.sun.gjc.spi.XAResourceImpl;
import com.sun.gjc.spi.base.CacheObjectKey;
import com.sun.gjc.spi.base.CallableStatementWrapper;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.ConnectionWrapper;
import com.sun.gjc.spi.base.PreparedStatementWrapper;
import com.sun.gjc.spi.base.datastructure.Cache;
import com.sun.gjc.spi.base.datastructure.CacheFactory;
import com.sun.gjc.util.SQLTraceDelegator;
import com.sun.gjc.util.StatementLeakDetector;
import com.sun.logging.LogDomains;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.LazyEnlistableManagedConnection;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ManagedConnectionImpl
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    private static final Logger LOG = LogDomains.getLogger(ManagedConnectionImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final StringManager I18N = StringManager.getManager(DataSourceObjectBuilder.class);
    public static final int ISNOTAPOOLEDCONNECTION = 0;
    public static final int ISPOOLEDCONNECTION = 1;
    public static final int ISXACONNECTION = 2;
    protected boolean isDestroyed;
    protected boolean isUsable = true;
    protected boolean initSqlExecuted;
    protected int connectionCount;
    protected int connectionType = 0;
    protected PooledConnection pooledConnection;
    protected Connection actualConnection;
    protected Hashtable connectionHandles;
    protected PrintWriter logWriter;
    protected PasswordCredential passwdCredential;
    private ManagedConnectionFactory managedConnectionFactory;
    protected XAResource xaResource;
    protected ConnectionHolder myLogicalConnection;
    protected int lastTransactionIsolationLevel;
    protected boolean isClean = true;
    protected boolean transactionInProgress;
    protected ConnectionEventListener listener;
    protected ConnectionEvent connectionEvent;
    private boolean defaultAutoCommitValue;
    private boolean lastAutoCommitValue = this.defaultAutoCommitValue = true;
    private boolean markedForRemoval;
    private int statementTimeout;
    private Cache statementCache;
    private int cacheSize;
    private String cacheType;
    private boolean statementCaching;
    private long stmtLeakTimeout;
    private boolean stmtLeakReclaim;
    private boolean statementLeakTracing;
    protected StatementLeakDetector leakDetector;
    private SQLTraceDelegator sqlTraceDelegator;
    private boolean aborted;
    private DatabaseMetaData cachedDatabaseMetaData;
    private Boolean isClientInfoSupported;

    public ManagedConnectionImpl(PooledConnection pooledConn, Connection sqlConn, PasswordCredential passwdCred, ManagedConnectionFactory mcf, PoolInfo poolInfo, int statementCacheSize, String statementCacheType, SQLTraceDelegator delegator, long statementLeakTimeout, boolean statementLeakReclaim) throws ResourceException {
        if (pooledConn == null && sqlConn == null) {
            String i18nMsg = I18N.getString("jdbc.conn_obj_null");
            throw new ResourceException(i18nMsg);
        }
        if (this.connectionType == 0) {
            this.actualConnection = sqlConn;
        }
        this.pooledConnection = pooledConn;
        this.connectionHandles = new Hashtable();
        this.passwdCredential = passwdCred;
        this.sqlTraceDelegator = delegator;
        this.managedConnectionFactory = mcf;
        if (this.passwdCredential != null && !this.managedConnectionFactory.equals((Object)this.passwdCredential.getManagedConnectionFactory())) {
            String i18nMsg = I18N.getString("jdbc.mc_construct_err");
            throw new ResourceException(i18nMsg);
        }
        this.logWriter = mcf.getLogWriter();
        this.connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        this.tuneStatementCaching(poolInfo, statementCacheSize, statementCacheType);
        this.tuneStatementLeakTracing(poolInfo, statementLeakTimeout, statementLeakReclaim);
    }

    public StatementLeakDetector getLeakDetector() {
        return this.leakDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitSql(String initSql) {
        LOG.log(Level.FINE, "jdbc.execute_init_sql_start");
        PreparedStatement statement = null;
        if (initSql != null && !initSql.equalsIgnoreCase("null") && !initSql.equals("")) {
            try {
                statement = this.actualConnection.prepareStatement(initSql);
                LOG.log(Level.FINE, "jdbc.executing_init_sql", initSql);
                statement.execute();
            }
            catch (SQLException sqle) {
                LOG.log(Level.WARNING, "jdbc.exc_init_sql_error", initSql);
                this.initSqlExecuted = false;
            }
            finally {
                block14: {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block14;
                        LOG.log(Level.FINE, "jdbc.exc_init_sql_error_stmt_close", e.getMessage());
                    }
                }
            }
            this.initSqlExecuted = true;
        }
        LOG.log(Level.FINE, "jdbc.execute_init_sql_end");
    }

    private void tuneStatementCaching(PoolInfo poolInfo, int statementCacheSize, String statementCacheType) {
        this.cacheSize = statementCacheSize;
        this.cacheType = statementCacheType;
        if (this.cacheSize > 0) {
            try {
                this.statementCache = CacheFactory.getDataStructure(poolInfo, this.cacheType, this.cacheSize);
                this.statementCaching = true;
            }
            catch (ResourceException ex) {
                LOG.severe(ex.getMessage());
            }
        }
    }

    private void tuneStatementLeakTracing(PoolInfo poolInfo, long statementLeakTimeout, boolean statementLeakReclaim) {
        this.stmtLeakTimeout = statementLeakTimeout;
        this.stmtLeakReclaim = statementLeakReclaim;
        if (this.stmtLeakTimeout > 0L) {
            ManagedConnectionFactoryImpl managedConnectionFactoryImpl = (ManagedConnectionFactoryImpl)this.managedConnectionFactory;
            this.statementLeakTracing = true;
            if (this.leakDetector == null) {
                this.leakDetector = new StatementLeakDetector(poolInfo, this.statementLeakTracing, this.stmtLeakTimeout, this.stmtLeakReclaim, ((ResourceAdapterImpl)managedConnectionFactoryImpl.getResourceAdapter()).getTimer());
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listener = listener;
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.logFine("In associateConnection");
        this.checkIfValid();
        if (connection == null) {
            throw new ResourceException(I18N.getString("jdbc.conn_handle_null"));
        }
        ConnectionHolder connectionHolder = (ConnectionHolder)connection;
        ManagedConnectionImpl managedConnectionImpl = connectionHolder.getManagedConnection();
        this.isClean = false;
        connectionHolder.associateConnection(this.actualConnection, this);
        connectionHolder.setActive();
        this.incrementCount();
        this.myLogicalConnection = connectionHolder;
        if (managedConnectionImpl != null) {
            managedConnectionImpl.decrementCount();
        }
    }

    public void cleanup() throws ResourceException {
        this.logFine("In cleanup");
        this.isClean = true;
        this.resetConnectionProperties((ManagedConnectionFactoryImpl)this.managedConnectionFactory);
    }

    protected void invalidateAllConnectionHandles() throws ResourceException {
        Set handles = this.connectionHandles.keySet();
        Iterator iter = handles.iterator();
        try {
            while (iter.hasNext()) {
                ConnectionHolder ch = (ConnectionHolder)iter.next();
                ch.invalidate();
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ResourceException("Could not find the connection handle: " + nsee.getMessage(), (Throwable)nsee);
        }
        this.connectionHandles.clear();
    }

    private void clearStatementCache() {
        if (this.statementCache != null) {
            LOG.fine("Closing statements in statement cache");
            this.statementCache.flushCache();
            this.statementCache.clearCache();
        }
    }

    public void destroy() throws ResourceException {
        this.logFine("In destroy");
        if (this.isDestroyed) {
            return;
        }
        this.clearStatementCache();
        if (this.leakDetector != null) {
            this.leakDetector.clearAllStatementLeakTasks();
        }
        try {
            if (this.connectionType == 2 || this.connectionType == 1) {
                this.pooledConnection.close();
                this.pooledConnection = null;
                this.actualConnection = null;
            } else {
                this.actualConnection.close();
                this.actualConnection = null;
            }
        }
        catch (SQLException sqle) {
            this.isDestroyed = true;
            this.passwdCredential = null;
            this.connectionHandles = null;
            throw new ResourceException(I18N.getString("jdbc.error_in_destroy") + sqle.getMessage(), (Throwable)sqle);
        }
        this.isDestroyed = true;
        this.passwdCredential = null;
        this.connectionHandles = null;
    }

    public Object getConnection(Subject sub, ConnectionRequestInfo cxReqInfo) throws ResourceException {
        int timeoutValue;
        this.logFine("In getConnection");
        this.checkIfValid();
        this.getActualConnection();
        ManagedConnectionFactoryImpl managedConnectionFactoryImpl = (ManagedConnectionFactoryImpl)this.managedConnectionFactory;
        String statementTimeoutString = managedConnectionFactoryImpl.getStatementTimeout();
        if (statementTimeoutString != null && (timeoutValue = Integer.parseInt(statementTimeoutString)) >= 0) {
            this.statementTimeout = timeoutValue;
        }
        this.myLogicalConnection = managedConnectionFactoryImpl.getJdbcObjectsFactory().getConnection(this.actualConnection, this, cxReqInfo, managedConnectionFactoryImpl.isStatementWrappingEnabled(), this.sqlTraceDelegator);
        if (!this.initSqlExecuted) {
            String initSql = managedConnectionFactoryImpl.getInitSql();
            this.executeInitSql(initSql);
        }
        this.incrementCount();
        this.isClean = false;
        this.myLogicalConnection.setActive();
        return this.myLogicalConnection;
    }

    private void resetConnectionProperties(ManagedConnectionFactoryImpl managedConnectionFactoryImpl) throws ResourceException {
        if (this.isClean) {
            managedConnectionFactoryImpl.resetIsolation(this, this.lastTransactionIsolationLevel);
            this.resetAutoCommit();
        }
    }

    private void resetAutoCommit() throws ResourceException {
        if (this.defaultAutoCommitValue != this.getLastAutoCommitValue() && !this.isTransactionInProgress()) {
            try {
                this.actualConnection.setAutoCommit(this.defaultAutoCommitValue);
            }
            catch (SQLException sqle) {
                throw new ResourceException(I18N.getString("jdbc.error_during_setAutoCommit") + sqle.getMessage(), (Throwable)sqle);
            }
            this.setLastAutoCommitValue(this.defaultAutoCommitValue);
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.logFine("In getLocalTransaction");
        this.checkIfValid();
        return new LocalTransactionImpl(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.logFine("In getLogWriter");
        this.checkIfValid();
        return this.logWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.logFine("In getMetaData");
        this.checkIfValid();
        return new ManagedConnectionMetaDataImpl(this);
    }

    public XAResource getXAResource() throws ResourceException {
        this.logFine("In getXAResource");
        this.checkIfValid();
        if (this.connectionType == 2) {
            try {
                if (this.xaResource == null) {
                    this.xaResource = new XAResourceImpl(((XAConnection)this.pooledConnection).getXAResource(), this);
                }
                return this.xaResource;
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        throw new NotSupportedException("Cannot get an XAResource from a non XA connection");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    void transactionStarted() {
        this.transactionInProgress = true;
    }

    void transactionCompleted() {
        try {
            this.transactionInProgress = false;
            if ((this.connectionType == 1 || this.connectionType == 2) && this.connectionCount <= 0) {
                try {
                    this.actualConnection.close();
                    this.actualConnection = null;
                }
                catch (SQLException sqle) {
                    this.actualConnection = null;
                }
            }
        }
        catch (NullPointerException e) {
            LOG.log(Level.FINE, "jdbc.duplicateTxCompleted");
        }
        if (this.markedForRemoval) {
            if (this.aborted) {
                BadConnectionEventListener badConnectionEventListener = (BadConnectionEventListener)this.listener;
                badConnectionEventListener.connectionAbortOccurred(this.connectionEvent);
                LOG.log(Level.INFO, "jdbc.markedForRemoval_conAborted");
                this.markedForRemoval = false;
                this.myLogicalConnection.setClosed(true);
            } else {
                this.connectionErrorOccurred(null, null);
                LOG.log(Level.INFO, "jdbc.markedForRemoval_txCompleted");
                this.markedForRemoval = false;
            }
        }
        this.isClean = true;
    }

    public boolean isTransactionInProgress() {
        return this.transactionInProgress;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.checkIfValid();
        this.logWriter = out;
    }

    protected int getConnectionType(PooledConnection pooledConn) {
        if (pooledConn == null) {
            return 0;
        }
        if (pooledConn instanceof XAConnection) {
            return 2;
        }
        return 1;
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return (ManagedConnectionFactoryImpl)this.managedConnectionFactory;
    }

    Connection getActualConnection() throws ResourceException {
        if (this.connectionType == 2 || this.connectionType == 1) {
            try {
                if (this.actualConnection == null && this.pooledConnection != null) {
                    this.actualConnection = this.pooledConnection.getConnection();
                    this.setLastAutoCommitValue(this.defaultAutoCommitValue);
                }
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        return this.actualConnection;
    }

    PasswordCredential getPasswordCredential() {
        return this.passwdCredential;
    }

    void checkIfValid() throws ResourceException {
        if (this.isDestroyed || !this.isUsable) {
            throw new ResourceException(I18N.getString("jdbc.mc_not_usable"));
        }
    }

    public void connectionClosed(Exception e, ConnectionHolder connectionHolder) throws SQLException {
        connectionHolder.invalidate();
        this.decrementCount();
        this.connectionEvent.setConnectionHandle((Object)connectionHolder);
        if (this.markedForRemoval && !this.transactionInProgress) {
            BadConnectionEventListener badConnectionEventListener = (BadConnectionEventListener)this.listener;
            badConnectionEventListener.badConnectionClosed(this.connectionEvent);
            LOG.log(Level.INFO, "jdbc.markedForRemoval_conClosed");
            this.markedForRemoval = false;
        } else if (this.listener != null) {
            this.listener.connectionClosed(this.connectionEvent);
        }
    }

    void connectionErrorOccurred(Exception e, ConnectionHolder connectionHolder) {
        ConnectionEvent connectionEvent;
        ConnectionEventListener connectionEventListener = this.listener;
        ConnectionEvent connectionEvent2 = connectionEvent = e == null ? new ConnectionEvent((ManagedConnection)this, 5) : new ConnectionEvent((ManagedConnection)this, 5, e);
        if (connectionHolder != null) {
            connectionEvent.setConnectionHandle((Object)connectionHolder);
        }
        connectionEventListener.connectionErrorOccurred(connectionEvent);
        this.isUsable = false;
    }

    void XAStartOccurred() {
        try {
            this.actualConnection.setAutoCommit(false);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "XA Start [ setAutoCommit ] failure ", e);
            this.connectionErrorOccurred(e, null);
        }
    }

    void XAEndOccurred() {
        try {
            this.actualConnection.setAutoCommit(true);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "XA End [ setAutoCommit ] failure ", e);
            this.connectionErrorOccurred(e, null);
        }
    }

    public void checkIfActive(ConnectionHolder connectionHolder) throws SQLException {
        if (this.isDestroyed || !this.isUsable) {
            throw new SQLException(I18N.getString("jdbc.conn_not_usable"));
        }
    }

    public void initializeConnectionType(int _connectionType) {
        this.connectionType = _connectionType;
    }

    public void incrementCount() {
        ++this.connectionCount;
    }

    public void decrementCount() {
        --this.connectionCount;
    }

    public void dissociateConnections() {
        if (this.myLogicalConnection != null) {
            this.myLogicalConnection.dissociateConnection();
            this.myLogicalConnection = null;
        }
    }

    public boolean getLastAutoCommitValue() {
        return this.lastAutoCommitValue;
    }

    public void setLastAutoCommitValue(boolean lastAutoCommitValue) {
        this.lastAutoCommitValue = lastAutoCommitValue;
    }

    public void markForRemoval(boolean flag) {
        this.markedForRemoval = flag;
    }

    public ManagedConnectionFactory getMcf() {
        return this.managedConnectionFactory;
    }

    public int getStatementTimeout() {
        return this.statementTimeout;
    }

    public void setLastTransactionIsolationLevel(int isolationLevel) {
        this.lastTransactionIsolationLevel = isolationLevel;
    }

    public DatabaseMetaData getCachedDatabaseMetaData() throws ResourceException {
        if (this.cachedDatabaseMetaData == null) {
            try {
                this.cachedDatabaseMetaData = this.getActualConnection().getMetaData();
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        return this.cachedDatabaseMetaData;
    }

    public Boolean isClientInfoSupported() {
        return this.isClientInfoSupported;
    }

    public void setClientInfoSupported(Boolean isClientInfoSupported) {
        this.isClientInfoSupported = isClientInfoSupported;
    }

    private void logFine(String logMessage) {
        LOG.log(Level.FINE, logMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.statementCaching) return connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", resultSetType, resultSetConcurrency);
        PreparedStatementWrapper preparedStatement = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (preparedStatement != null) {
            if (!this.isFree(preparedStatement)) return connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            if (!preparedStatement.isValid()) {
                this.statementCache.purge(preparedStatement);
                preparedStatement = connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, true);
                preparedStatement.setBusy(true);
                this.statementCache.addToCache(key, preparedStatement, false);
                return preparedStatement;
            } else {
                preparedStatement.setBusy(true);
            }
            return preparedStatement;
        } else {
            preparedStatement = connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            preparedStatement.setBusy(true);
            this.statementCache.addToCache(key, preparedStatement, false);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.statementCaching) return connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatementWrapper preparedStatement = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (preparedStatement != null) {
            if (!this.isFree(preparedStatement)) return connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            if (!preparedStatement.isValid()) {
                this.statementCache.purge(preparedStatement);
                preparedStatement = connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
                preparedStatement.setBusy(true);
                this.statementCache.addToCache(key, preparedStatement, false);
                return preparedStatement;
            } else {
                preparedStatement.setBusy(true);
            }
            return preparedStatement;
        } else {
            preparedStatement = connection.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, preparedStatement, false);
            preparedStatement.setBusy(true);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper connection, String sql, String[] columnNames) throws SQLException {
        if (!this.statementCaching) return connection.prepareCachedStatement(sql, columnNames, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", columnNames);
        PreparedStatementWrapper preparedStatement = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (preparedStatement != null) {
            if (!this.isFree(preparedStatement)) return connection.prepareCachedStatement(sql, columnNames, false);
            if (!preparedStatement.isValid()) {
                this.statementCache.purge(preparedStatement);
                preparedStatement = connection.prepareCachedStatement(sql, columnNames, true);
                preparedStatement.setBusy(true);
                this.statementCache.addToCache(key, preparedStatement, false);
                return preparedStatement;
            } else {
                preparedStatement.setBusy(true);
            }
            return preparedStatement;
        } else {
            preparedStatement = connection.prepareCachedStatement(sql, columnNames, true);
            this.statementCache.addToCache(key, preparedStatement, false);
            preparedStatement.setBusy(true);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper connection, String sql, int[] columnIndexes) throws SQLException {
        if (!this.statementCaching) return connection.prepareCachedStatement(sql, columnIndexes, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", columnIndexes);
        PreparedStatementWrapper preparedStatement = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (preparedStatement != null) {
            if (!this.isFree(preparedStatement)) return connection.prepareCachedStatement(sql, columnIndexes, false);
            if (!preparedStatement.isValid()) {
                this.statementCache.purge(preparedStatement);
                preparedStatement = connection.prepareCachedStatement(sql, columnIndexes, true);
                preparedStatement.setBusy(true);
                this.statementCache.addToCache(key, preparedStatement, false);
                return preparedStatement;
            } else {
                preparedStatement.setBusy(true);
            }
            return preparedStatement;
        } else {
            preparedStatement = connection.prepareCachedStatement(sql, columnIndexes, true);
            this.statementCache.addToCache(key, preparedStatement, false);
            preparedStatement.setBusy(true);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper connection, String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.statementCaching) return connection.prepareCachedStatement(sql, autoGeneratedKeys, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", autoGeneratedKeys);
        PreparedStatementWrapper preparedStatement = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (preparedStatement != null) {
            if (!this.isFree(preparedStatement)) return connection.prepareCachedStatement(sql, autoGeneratedKeys, false);
            if (!preparedStatement.isValid()) {
                this.statementCache.purge(preparedStatement);
                preparedStatement = connection.prepareCachedStatement(sql, autoGeneratedKeys, true);
                preparedStatement.setBusy(true);
                this.statementCache.addToCache(key, preparedStatement, false);
                return preparedStatement;
            } else {
                preparedStatement.setBusy(true);
            }
            return preparedStatement;
        } else {
            preparedStatement = connection.prepareCachedStatement(sql, autoGeneratedKeys, true);
            this.statementCache.addToCache(key, preparedStatement, false);
            preparedStatement.setBusy(true);
        }
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(ConnectionWrapper connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.statementCaching) return connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, "CS", resultSetType, resultSetConcurrency);
        CallableStatementWrapper callableStatement = (CallableStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (callableStatement != null) {
            if (!this.isFree(callableStatement)) return connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            if (!callableStatement.isValid()) {
                this.statementCache.purge(callableStatement);
                callableStatement = connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, true);
                callableStatement.setBusy(true);
                this.statementCache.addToCache(key, callableStatement, false);
                return callableStatement;
            } else {
                callableStatement.setBusy(true);
            }
            return callableStatement;
        } else {
            callableStatement = connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            this.statementCache.addToCache(key, callableStatement, false);
            callableStatement.setBusy(true);
        }
        return callableStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(ConnectionWrapper connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.statementCaching) return connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, "CS", resultSetType, resultSetConcurrency, resultSetHoldability);
        CallableStatementWrapper callableStatement = (CallableStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (callableStatement != null) {
            if (!this.isFree(callableStatement)) return connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            if (!callableStatement.isValid()) {
                this.statementCache.purge(callableStatement);
                callableStatement = connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
                callableStatement.setBusy(true);
                this.statementCache.addToCache(key, callableStatement, false);
                return callableStatement;
            } else {
                callableStatement.setBusy(true);
            }
            return callableStatement;
        } else {
            callableStatement = connection.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, callableStatement, false);
            callableStatement.setBusy(true);
        }
        return callableStatement;
    }

    boolean isFree(PreparedStatementWrapper cachedps) {
        return !cachedps.isBusy();
    }

    public void setAborted(boolean flag) {
        this.aborted = flag;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void purgeStatementFromCache(PreparedStatement preparedStatement) {
        this.statementCache.purge(preparedStatement);
    }
}

