/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeFlowInSplitExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JDBCPersistenceManagerSQLConstants;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.jbatch.spi.services.IBatchConfig;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCPersistenceManagerImpl
implements IPersistenceManagerService,
JDBCPersistenceManagerSQLConstants {
    private static final String CLASSNAME = JDBCPersistenceManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String driver = "";
    protected String schema = "";
    protected String url = "";
    protected String userId = "";
    protected String pwd = "";

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        if (!batchConfig.isJ2seMode()) {
            this.dataSource = batchConfig.getDatabaseConfigurationBean().getDataSource();
            if (this.dataSource != null) {
                logger.config("DataSource obtained from DB config bean = " + this.dataSource);
            } else {
                this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
                logger.config("JNDI name = " + this.jndiName);
                if (this.jndiName == null || this.jndiName.equals("")) {
                    throw new BatchContainerServiceException("JNDI name is not defined, which was the last way to initialize a DataSource.");
                }
                try {
                    InitialContext ctx = new InitialContext();
                    this.dataSource = (DataSource)ctx.lookup(this.jndiName);
                }
                catch (NamingException e) {
                    logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
                    throw new BatchContainerServiceException(e);
                }
            }
        } else {
            this.driver = batchConfig.getDatabaseConfigurationBean().getJdbcDriver();
            this.url = batchConfig.getDatabaseConfigurationBean().getJdbcUrl();
            this.userId = batchConfig.getDatabaseConfigurationBean().getDbUser();
            this.pwd = batchConfig.getDatabaseConfigurationBean().getDbPassword();
            logger.config("driver: " + this.driver + ", url: " + this.url);
        }
        try {
            if (this.isDerby()) {
                if (!this.isSchemaValid()) {
                    this.createSchema();
                }
                this.checkAllTables();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    private boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isSchemaValid");
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSchemas();
        while (rs.next()) {
            if (!this.schema.equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
            this.cleanupConnection(conn, rs, null);
            logger.exiting(CLASSNAME, "isSchemaValid", true);
            return true;
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isSchemaValid", false);
        return false;
    }

    private boolean isDerby() throws SQLException {
        logger.entering(CLASSNAME, "isDerby");
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        boolean derby = dbmd.getDatabaseProductName().toLowerCase().indexOf("derby") > 0;
        logger.exiting(CLASSNAME, "isDerby", derby);
        return derby;
    }

    private void createSchema() throws SQLException {
        logger.entering(CLASSNAME, "createSchema");
        Connection conn = this.getConnectionToDefaultSchema();
        logger.log(Level.INFO, this.schema + " schema does not exists. Trying to create it.");
        PreparedStatement ps = null;
        ps = conn.prepareStatement("CREATE SCHEMA " + this.schema);
        ps.execute();
        this.cleanupConnection(conn, null, ps);
        logger.exiting(CLASSNAME, "createSchema");
    }

    private void checkAllTables() throws SQLException {
        logger.entering(CLASSNAME, "checkAllTables");
        this.createIfNotExists("CHECKPOINTDATA", "CREATE TABLE CHECKPOINTDATA(id VARCHAR(512),obj BLOB)");
        this.executeStatement("create index chk_index on checkpointdata(id)");
        this.createIfNotExists("JOBINSTANCEDATA", "CREATE TABLE JOBINSTANCEDATA(jobinstanceid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBINSTANCE_PK PRIMARY KEY,name VARCHAR(512),apptag VARCHAR(512))");
        this.createIfNotExists("EXECUTIONINSTANCEDATA", "CREATE TABLE EXECUTIONINSTANCEDATA(jobexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBEXECUTION_PK PRIMARY KEY,jobinstanceid BIGINT,createtime TIMESTAMP,starttime TIMESTAMP,endtime TIMESTAMP,updatetime TIMESTAMP,parameters BLOB,batchstatus VARCHAR(512),exitstatus VARCHAR(512),CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES JOBINSTANCEDATA (jobinstanceid) ON DELETE CASCADE)");
        this.createIfNotExists("STEPEXECUTIONINSTANCEDATA", "CREATE TABLE STEPEXECUTIONINSTANCEDATA(stepexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT STEPEXECUTION_PK PRIMARY KEY,jobexecid BIGINT,batchstatus VARCHAR(512),exitstatus VARCHAR(512),stepname VARCHAR(512),readcount INTEGER,writecount INTEGER,commitcount INTEGER,rollbackcount INTEGER,readskipcount INTEGER,processskipcount INTEGER,filtercount INTEGER,writeskipcount INTEGER,startTime TIMESTAMP,endTime TIMESTAMP,persistentData BLOB,CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES EXECUTIONINSTANCEDATA (jobexecid) ON DELETE CASCADE)");
        this.createIfNotExists("JOBSTATUS", "CREATE TABLE JOBSTATUS(id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES JOBINSTANCEDATA (jobinstanceid) ON DELETE CASCADE)");
        this.createIfNotExists("STEPSTATUS", "CREATE TABLE STEPSTATUS(id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES STEPEXECUTIONINSTANCEDATA (stepexecid) ON DELETE CASCADE)");
        logger.exiting(CLASSNAME, "checkAllTables");
    }

    private void createIfNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createIfNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = this.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, this.schema, tableName, null);
        PreparedStatement ps = null;
        if (!rs.next()) {
            logger.log(Level.INFO, tableName + " table does not exist. Trying to create it.");
            ps = conn.prepareStatement(createTableStatement);
            ps.executeUpdate();
        }
        this.cleanupConnection(conn, rs, ps);
        logger.exiting(CLASSNAME, "createIfNotExists");
    }

    private void executeStatement(String statement) throws SQLException {
        logger.entering(CLASSNAME, "executeStatement", statement);
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ps = conn.prepareStatement(statement);
        ps.executeUpdate();
        this.cleanupConnection(conn, ps);
        logger.exiting(CLASSNAME, "executeStatement");
    }

    @Override
    public void createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "createCheckpointData", new Object[]{key, value});
        this.insertCheckpointData(key.getCommaSeparatedKey(), value);
        logger.exiting(CLASSNAME, "createCheckpointData");
    }

    @Override
    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "getCheckpointData", key == null ? "<null>" : key);
        CheckpointData checkpointData = this.queryCheckpointData(key.getCommaSeparatedKey());
        logger.exiting(CLASSNAME, "getCheckpointData", checkpointData == null ? "<null>" : checkpointData);
        return checkpointData;
    }

    @Override
    public void updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        CheckpointData data = this.queryCheckpointData(key.getCommaSeparatedKey());
        if (data != null) {
            this.updateCheckpointData(key.getCommaSeparatedKey(), value);
        } else {
            this.createCheckpointData(key, value);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    protected Connection getConnection() throws SQLException {
        logger.finest("Entering: " + CLASSNAME + ".getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.finest("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            logger.finest("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            logger.finest("JSE mode, getting connection from " + this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            logger.finest("autocommit=" + connection.getAutoCommit());
        }
        this.setSchemaOnConnection(connection);
        logger.finest("Exiting: " + CLASSNAME + ".getConnection() with conn =" + connection);
        return connection;
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        logger.finest("Entering getConnectionToDefaultSchema");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.finest("J2EE mode, getting connection from data source");
            try {
                connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                this.logException("FAILED GETTING DATABASE CONNECTION", e);
                throw new PersistenceException(e);
            }
            logger.finest("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                this.logException("ClassNotFoundException: Cannot load driver class: " + this.driver, e);
                throw new PersistenceException(e);
            }
            logger.finest("JSE mode, getting connection from " + this.url);
            try {
                connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            }
            catch (SQLException e) {
                this.logException("FAILED GETTING DATABASE CONNECTION.  FOR EMBEDDED DERBY CHECK FOR OTHER USER LOCKING THE CURRENT DATABASE (Try using a different database instance).", e);
                throw new PersistenceException(e);
            }
            logger.finest("autocommit=" + connection.getAutoCommit());
        }
        logger.finest("Exiting from getConnectionToDefaultSchema, conn= " + connection);
        return connection;
    }

    private void logException(String msg, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        logger.log(Level.SEVERE, msg + "; Exception stack trace: " + sw);
    }

    private void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.finest("Entering " + CLASSNAME + ".setSchemaOnConnection()");
        String dbProductName = connection.getMetaData().getDatabaseProductName();
        if (!"Oracle".equals(dbProductName) && !"Microsoft SQL Server".equals(dbProductName)) {
            PreparedStatement ps = null;
            if ("MySQL".equals(dbProductName)) {
                ps = connection.prepareStatement("USE " + this.schema);
            } else {
                ps = connection.prepareStatement("SET SCHEMA ?");
                ps.setString(1, this.schema);
            }
            ps.executeUpdate();
            ps.close();
        }
        logger.finest("Exiting " + CLASSNAME + ".setSchemaOnConnection()");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CheckpointData queryCheckpointData(Object key) {
        CheckpointData data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            logger.entering(CLASSNAME, "queryCheckpointData", new Object[]{key, "select id, obj from checkpointdata where id = ?"});
            conn = null;
            statement = null;
            rs = null;
            ObjectInputStream objectIn = null;
            data = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select id, obj from checkpointdata where id = ?");
                statement.setObject(1, key);
                rs = statement.executeQuery();
                if (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    data = (CheckpointData)this.deserializeObject(buf);
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "queryCheckpointData");
        return data;
    }

    private <T> void insertCheckpointData(Object key, T value) {
        logger.entering(CLASSNAME, "insertCheckpointData", new Object[]{key, value});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("insert into checkpointdata values(?, ?)");
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setBytes(2, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "insertCheckpointData");
    }

    private void updateCheckpointData(Object key, CheckpointData value) {
        logger.entering(CLASSNAME, "updateCheckpointData", new Object[]{key, value});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update checkpointdata set obj = ? where id = ?");
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateCheckpointData");
    }

    private void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, rs == null ? "<null>" : rs, statement == null ? "<null>" : statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    private void cleanupConnection(Connection conn, PreparedStatement statement) {
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Entering", new Object[]{conn, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.logp(Level.FINEST, CLASSNAME, "cleanupConnection", "Exiting");
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName, String appTag) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select count(jobinstanceid) as jobinstancecount from jobinstancedata where name = ? and apptag = ?");
            statement.setString(1, jobName);
            statement.setString(2, appTag);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select count(jobinstanceid) as jobinstancecount from jobinstancedata where name = ?");
            statement.setString(1, jobName);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, String appTag, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from jobinstancedata where name = ? and apptag = ? order by jobinstanceid desc");
            statement.setObject(1, jobName);
            statement.setObject(2, appTag);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from jobinstancedata where name = ? order by jobinstanceid desc");
            statement.setObject(1, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    @Override
    public Map<Long, String> jobOperatorGetExternalJobInstanceData() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashMap<Long, String> data = new HashMap<Long, String>();
        try {
            conn = this.getConnection();
            String filter = "not like ':%'";
            statement = conn.prepareStatement("select distinct jobinstanceid, name from jobinstancedata where name not like ':%'");
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                String name = rs.getString("name");
                data.put(id, name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, IPersistenceManagerService.TimestampType timestampType) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp createTimestamp = null;
        Timestamp endTimestamp = null;
        Timestamp updateTimestamp = null;
        Timestamp startTimestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select createtime, endtime, updatetime, starttime from executioninstancedata where jobexecid = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                createTimestamp = rs.getTimestamp(1);
                endTimestamp = rs.getTimestamp(2);
                updateTimestamp = rs.getTimestamp(3);
                startTimestamp = rs.getTimestamp(4);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.CREATE)) {
            return createTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.END)) {
            return endTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.LAST_UPDATED)) {
            return updateTimestamp;
        }
        if (timestampType.equals((Object)IPersistenceManagerService.TimestampType.STARTED)) {
            return startTimestamp;
        }
        throw new IllegalArgumentException("Unexpected enum value.");
    }

    @Override
    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select batchstatus from executioninstancedata where jobexecid = ?");
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select exitstatus from executioninstancedata where jobexecid = ?");
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) throws NoSuchJobExecutionException {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobexecid = ?");
            statement.setLong(1, executionID);
            rs = statement.executeQuery();
            if (!rs.next()) {
                String msg = "Did not find job instance associated with executionID =" + executionID;
                logger.fine(msg);
                throw new NoSuchJobExecutionException(msg);
            }
            jobinstanceID = rs.getLong("jobinstanceid");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobinstanceID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        Properties props;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            props = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select parameters from executioninstancedata where jobexecid = ?");
                statement.setLong(1, executionId);
                rs = statement.executeQuery();
                if (!rs.next()) {
                    String msg = "Did not find table entry for executionID =" + executionId;
                    logger.fine(msg);
                    throw new NoSuchJobExecutionException(msg);
                }
                byte[] buf = rs.getBytes("parameters");
                props = (Properties)this.deserializeObject(buf);
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return props;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, StepExecution> getMostRecentStepExecutionsForJobInstance(long instanceId) {
        HashMap<String, StepExecution> data = new HashMap<String, StepExecution>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select A.* from stepexecutioninstancedata A inner join executioninstancedata B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                stepname = rs.getString("stepname");
                if (data.containsKey(stepname)) continue;
                jobexecid = rs.getLong("jobexecid");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                data.put(stepname, stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        ArrayList<StepExecution> data = new ArrayList<StepExecution>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select * from stepexecutioninstancedata where jobexecid = ?");
            statement.setLong(1, execid);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                jobexecid = rs.getLong("jobexecid");
                stepexecid = rs.getLong("stepexecid");
                stepname = rs.getString("stepname");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                logger.fine("BatchStatus: " + batchstatus + " | StepName: " + stepname + " | JobExecID: " + jobexecid + " | StepExecID: " + stepexecid);
                data.add(stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select * from stepexecutioninstancedata where stepexecid = ?");
            statement.setLong(1, stepExecId);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return stepEx;
                }
                jobexecid = rs.getLong("jobexecid");
                stepexecid = rs.getLong("stepexecid");
                stepname = rs.getString("stepname");
                batchstatus = rs.getString("batchstatus");
                exitstatus = rs.getString("exitstatus");
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                logger.fine("stepExecution BatchStatus: " + batchstatus + " StepName: " + stepname);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateBatchStatusOnly(long key, BatchStatus batchStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set batchstatus = ?, updatetime = ? where jobexecid = ?");
            statement.setString(1, batchStatus.name());
            statement.setTimestamp(2, updatets);
            statement.setLong(3, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    @Override
    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set batchstatus = ?, exitstatus = ?, endtime = ?, updatetime = ? where jobexecid = ?");
            statement.setString(1, batchStatus.name());
            statement.setString(2, exitStatus);
            statement.setTimestamp(3, updatets);
            statement.setTimestamp(4, updatets);
            statement.setLong(5, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set batchstatus = ?, starttime = ?, updatetime = ? where jobexecid = ?");
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setTimestamp(2, startTS);
            statement.setTimestamp(3, startTS);
            statement.setLong(4, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        IJobExecution jobEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block11: {
            conn = null;
            statement = null;
            rs = null;
            jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from executioninstancedata A inner join jobinstancedata B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
                statement.setLong(1, jobExecutionId);
                rs = statement.executeQuery();
                IJobExecution iJobExecution = jobEx = rs.next() ? this.readJobExecutionRecord(rs) : null;
                if (objectIn == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return jobEx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        ArrayList<IJobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<IJobExecution>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from executioninstancedata A inner join jobinstancedata B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
                statement.setLong(1, jobInstanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    data.add(this.readJobExecutionRecord(rs));
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    private IJobExecution readJobExecutionRecord(ResultSet rs) throws SQLException, IOException, ClassNotFoundException {
        if (rs == null) {
            return null;
        }
        JobOperatorJobExecution retMe = new JobOperatorJobExecution(rs.getLong("jobexecid"), rs.getLong("jobinstanceid"));
        retMe.setCreateTime(rs.getTimestamp("createtime"));
        retMe.setStartTime(rs.getTimestamp("starttime"));
        retMe.setEndTime(rs.getTimestamp("endtime"));
        retMe.setLastUpdateTime(rs.getTimestamp("updatetime"));
        retMe.setJobParameters((Properties)this.deserializeObject(rs.getBytes("parameters")));
        retMe.setBatchStatus(rs.getString("batchstatus"));
        retMe.setExitStatus(rs.getString("exitstatus"));
        retMe.setJobName(rs.getString("name"));
        return retMe;
    }

    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<Long> executionIds = new HashSet<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("SELECT A.jobexecid FROM executioninstancedata A INNER JOIN jobinstancedata B ON A.jobinstanceid = B.jobinstanceid WHERE A.batchstatus IN (?,?,?) AND B.name = ?");
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setString(2, BatchStatus.STARTING.name());
            statement.setString(3, BatchStatus.STOPPING.name());
            statement.setString(4, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                executionIds.add(rs.getLong("jobexecid"));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return executionIds;
    }

    @Override
    public String getJobCurrentTag(long jobInstanceId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String apptag = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select apptag from jobinstancedata where jobinstanceid = ?");
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            while (rs.next()) {
                apptag = rs.getString("apptag");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return apptag;
    }

    @Override
    public void purge(String apptag) {
        logger.entering(CLASSNAME, "purge", apptag);
        String deleteJobs = "DELETE FROM jobinstancedata WHERE apptag = ?";
        String deleteJobExecutions = "DELETE FROM executioninstancedata WHERE jobexecid IN (SELECT B.jobexecid FROM jobinstancedata A INNER JOIN executioninstancedata B ON A.jobinstanceid = B.jobinstanceid WHERE A.apptag = ?)";
        String deleteStepExecutions = "DELETE FROM stepexecutioninstancedata WHERE stepexecid IN (SELECT C.stepexecid FROM jobinstancedata A INNER JOIN executioninstancedata B ON A.jobinstanceid = B.jobinstanceid INNER JOIN stepexecutioninstancedata C ON B.jobexecid = C.jobexecid WHERE A.apptag = ?)";
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(deleteStepExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobs);
            statement.setString(1, apptag);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "purge");
    }

    @Override
    public JobStatus getJobStatusFromExecution(long executionId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobStatus retVal = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select A.obj from jobstatus A inner join executioninstancedata B on A.id = B.jobinstanceid where B.jobexecid = ?");
            statement.setLong(1, executionId);
            rs = statement.executeQuery();
            byte[] buf = null;
            if (rs.next()) {
                buf = rs.getBytes("obj");
            }
            retVal = (JobStatus)this.deserializeObject(buf);
            this.cleanupConnection(conn, rs, statement);
        }
        catch (Exception e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "executeQuery");
        return retVal;
    }

    @Override
    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        long instanceId = 0L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobexecid = ?");
            statement.setObject(1, executionId);
            rs = statement.executeQuery();
            if (!rs.next()) {
                String msg = "Did not find job instance associated with executionID =" + executionId;
                logger.fine(msg);
                throw new NoSuchJobExecutionException(msg);
            }
            instanceId = rs.getLong("jobinstanceid");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return instanceId;
    }

    private byte[] serializeObject(Serializable theObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(theObject);
        byte[] data = baos.toByteArray();
        baos.close();
        oout.close();
        return data;
    }

    private Serializable deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        Serializable theObject = null;
        ObjectInputStream objectIn = null;
        if (buffer != null) {
            objectIn = new ObjectInputStream(new ByteArrayInputStream(buffer));
            theObject = (Serializable)objectIn.readObject();
            objectIn.close();
        }
        return theObject;
    }

    @Override
    public JobInstance createSubJobInstance(String name, String apptag) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO jobinstancedata (name, apptag) VALUES(?, ?)", new String[]{"JOBINSTANCEID"});
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobInstanceID);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    @Override
    public JobInstance createJobInstance(String name, String apptag, String jobXml) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO jobinstancedata (name, apptag) VALUES(?, ?)", new String[]{"JOBINSTANCEID"});
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobInstanceID, jobXml);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    @Override
    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, jobParameters, batchStatus, now);
        RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, newExecutionId);
        jobExecution.setBatchStatus(batchStatus.name());
        jobExecution.setCreateTime(now);
        jobExecution.setLastUpdateTime(now);
        return jobExecution;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp timestamp) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long newJobExecutionId = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO executioninstancedata (jobinstanceid, createtime, updatetime, batchstatus, parameters) VALUES(?, ?, ?, ?, ?)", new String[]{"JOBEXECID"});
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, timestamp);
            statement.setTimestamp(3, timestamp);
            statement.setString(4, batchStatus.name());
            statement.setObject(5, this.serializeObject(jobParameters));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                newJobExecutionId = rs.getLong(1);
            }
            this.cleanupConnection(conn, rs, statement);
            return newJobExecutionId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, null, batchStatus, now);
        RuntimeFlowInSplitExecution flowExecution = new RuntimeFlowInSplitExecution(jobInstance, newExecutionId);
        flowExecution.setBatchStatus(batchStatus.name());
        flowExecution.setCreateTime(now);
        flowExecution.setLastUpdateTime(now);
        return flowExecution;
    }

    @Override
    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        StepExecutionImpl stepExecution = null;
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("batchStatus: " + batchStatus + " | stepName: " + stepName);
        }
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        stepExecution = this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
        return stepExecution;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "createStepExecution", new Object[]{rootJobExecId, batchStatus, exitStatus == null ? "<null>" : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? "<null>" : startTime, endTime == null ? "<null>" : endTime, persistentData == null ? "<null>" : persistentData});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        StepExecutionImpl stepExecution = null;
        String query = "INSERT INTO stepexecutioninstancedata (jobexecid, batchstatus, exitstatus, stepname, readcount,writecount, commitcount, rollbackcount, readskipcount, processskipcount, filtercount, writeskipcount, starttime,endtime, persistentdata) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query, new String[]{"STEPEXECID"});
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, this.serializeObject(persistentData));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long stepExecutionId = rs.getLong(1);
                stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                stepExecution.setStepName(stepName);
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createStepExecution");
        return stepExecution;
    }

    @Override
    public void updateStepExecution(StepContextImpl stepContext) {
        Metric[] metrics = stepContext.getMetrics();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    private String getPartitionLevelJobInstanceWildCard(long rootJobInstanceId, String stepName) {
        StringBuilder sb = new StringBuilder(":");
        sb.append(Long.toString(rootJobInstanceId));
        sb.append(":");
        sb.append(stepName);
        sb.append(":%");
        return sb.toString();
    }

    private long getMostRecentZerothPartitionSubJobInstanceId(long rootJobInstanceId, String stepName) {
        StringBuilder sb = new StringBuilder(":");
        sb.append(Long.toString(rootJobInstanceId));
        sb.append(":");
        sb.append(stepName);
        sb.append(":0");
        String zerothPartitionSubJobName = sb.toString();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long instanceId = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select max(jobinstanceid) as mostrecentid from jobinstancedata where name = ?");
            statement.setObject(1, zerothPartitionSubJobName);
            rs = statement.executeQuery();
            if (!rs.next()) {
                String msg = "Did not find sub job instance named = " + zerothPartitionSubJobName;
                logger.fine(msg);
                throw new NoSuchJobInstanceException(msg);
            }
            instanceId = rs.getLong("mostrecentid");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return instanceId;
    }

    @Override
    public void updateWithFinalPartitionAggregateStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        String stepName = stepContext.getStepName();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select SUM(STEPEX.readcount) readcount, SUM(STEPEX.writecount) writecount, SUM(STEPEX.commitcount) commitcount,  SUM(STEPEX.rollbackcount) rollbackcount, SUM(STEPEX.readskipcount) readskipcount, SUM(STEPEX.processskipcount) processskipcount, SUM(STEPEX.filtercount) filtercount, SUM(STEPEX.writeSkipCount) writeSkipCount from stepexecutioninstancedata STEPEX inner join executioninstancedata JOBEX on STEPEX.jobexecid = JOBEX.jobexecid where JOBEX.jobinstanceid IN (select jobinstanceid from JOBINSTANCEDATA where name like ? and jobinstanceid >= ?)");
            long rootJobInstanceId = this.getJobInstanceIdByExecutionId(rootJobExecutionId);
            statement.setString(1, this.getPartitionLevelJobInstanceWildCard(rootJobInstanceId, stepName));
            statement.setLong(2, this.getMostRecentZerothPartitionSubJobInstanceId(rootJobInstanceId, stepName));
            rs = statement.executeQuery();
            if (rs.next()) {
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        this.updateStepExecutionWithMetrics(stepContext, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount);
    }

    private void updateStepExecutionWithMetrics(StepContextImpl stepContext, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount) {
        long stepExecutionId = stepContext.getInternalStepExecutionId();
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("batchStatus: " + batchStatus + " | stepName: " + stepName + " | stepExecID: " + stepContext.getStepExecutionId());
        }
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Serializable persistentData = stepContext.getPersistentUserData();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "About to update StepExecution with: ", new Object[]{stepExecutionId, batchStatus, exitStatus == null ? "<null>" : exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime == null ? "<null>" : startTime, endTime == null ? "<null>" : endTime, persistentData == null ? "<null>" : persistentData});
        }
        Connection conn = null;
        PreparedStatement statement = null;
        String query = "UPDATE stepexecutioninstancedata SET batchstatus = ?, exitstatus = ?, stepname = ?,  readcount = ?,writecount = ?, commitcount = ?, rollbackcount = ?, readskipcount = ?, processskipcount = ?, filtercount = ?, writeskipcount = ?, starttime = ?, endtime = ?, persistentdata = ? WHERE stepexecid = ?";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setString(1, batchStatus);
            statement.setString(2, exitStatus);
            statement.setString(3, stepName);
            statement.setLong(4, readCount);
            statement.setLong(5, writeCount);
            statement.setLong(6, commitCount);
            statement.setLong(7, rollbackCount);
            statement.setLong(8, readSkipCount);
            statement.setLong(9, processSkipCount);
            statement.setLong(10, filterCount);
            statement.setLong(11, writeSkipCount);
            statement.setTimestamp(12, startTime);
            statement.setTimestamp(13, endTime);
            statement.setObject(14, this.serializeObject(persistentData));
            statement.setLong(15, stepExecutionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        logger.entering(CLASSNAME, "createJobStatus", jobInstanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        JobStatus jobStatus = new JobStatus(jobInstanceId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO jobstatus (id, obj) VALUES(?, ?)");
            statement.setLong(1, jobInstanceId);
            statement.setBytes(2, this.serializeObject(jobStatus));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "createJobStatus");
        return jobStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobStatus getJobStatus(long instanceId) {
        logger.entering(CLASSNAME, "getJobStatus", instanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = "SELECT obj FROM jobstatus WHERE id = ?";
        JobStatus jobStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                jobStatus = (JobStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getJobStatus", jobStatus);
        return jobStatus;
    }

    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        logger.entering(CLASSNAME, "updateJobStatus", new Object[]{instanceId, jobStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating Job Status to: " + jobStatus.getBatchStatus());
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("UPDATE jobstatus SET obj = ? WHERE id = ?");
            statement.setBytes(1, this.serializeObject(jobStatus));
            statement.setLong(2, instanceId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateJobStatus");
    }

    @Override
    public StepStatus createStepStatus(long stepExecId) {
        logger.entering(CLASSNAME, "createStepStatus", stepExecId);
        Connection conn = null;
        PreparedStatement statement = null;
        StepStatus stepStatus = new StepStatus(stepExecId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO stepstatus (id, obj) VALUES(?, ?)");
            statement.setLong(1, stepExecId);
            statement.setBytes(2, this.serializeObject(stepStatus));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "createStepStatus");
        return stepStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        logger.entering(CLASSNAME, "getStepStatus", new Object[]{instanceId, stepName});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = "SELECT obj FROM stepstatus WHERE id IN (SELECT B.stepexecid FROM executioninstancedata A INNER JOIN stepexecutioninstancedata B ON A.jobexecid = B.jobexecid WHERE A.jobinstanceid = ? and B.stepname = ?)";
        StepStatus stepStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            statement.setString(2, stepName);
            rs = statement.executeQuery();
            if (rs.next()) {
                stepStatus = (StepStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getStepStatus", stepStatus == null ? "<null>" : stepStatus);
        return stepStatus;
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        logger.entering(CLASSNAME, "updateStepStatus", new Object[]{stepExecutionId, stepStatus});
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating StepStatus to: " + stepStatus.getBatchStatus());
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("UPDATE stepstatus SET obj = ? WHERE id = ?");
            statement.setBytes(1, this.serializeObject(stepStatus));
            statement.setLong(2, stepExecutionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateStepStatus");
    }

    @Override
    public String getTagName(long jobExecutionId) {
        logger.entering(CLASSNAME, "getTagName", jobExecutionId);
        String apptag = null;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = "SELECT A.apptag FROM jobinstancedata A INNER JOIN executioninstancedata B ON A.jobinstanceid = B.jobinstanceid WHERE B.jobexecid = ?";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobExecutionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                apptag = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getTagName");
        return apptag;
    }

    @Override
    public long getMostRecentExecutionId(long jobInstanceId) {
        logger.entering(CLASSNAME, "getMostRecentExecutionId", jobInstanceId);
        long mostRecentId = -1L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = "SELECT jobexecid FROM executioninstancedata WHERE jobinstanceid = ? ORDER BY createtime DESC";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                mostRecentId = rs.getLong(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getMostRecentExecutionId");
        return mostRecentId;
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

