/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.server.wls.WebLogic_10_Platform;
import org.eclipse.persistence.sessions.DatabaseSession;

public class WebLogic_12_Platform
extends WebLogic_10_Platform {
    private static final ContextHelper ctxHelper = ContextHelper.getContextHelper();

    public WebLogic_12_Platform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    @Override
    public boolean usesPartitions() {
        return ctxHelper != null;
    }

    @Override
    public String getPartitionID() {
        return ctxHelper != null ? ctxHelper.getPartitionID() : super.getPartitionID();
    }

    public String getPartitionName() {
        return ctxHelper != null ? ctxHelper.getPartitionName() : "GLOBAL";
    }

    public boolean isGlobalRuntime() {
        return ctxHelper == null || ctxHelper.isGlobalRuntime();
    }

    private static final class ContextHelper {
        private Object cicManagerInstance;
        private Method getCurrentCicMethod;
        private Method getPartitionIdMethod;
        private Method getPartitionNameMethod;
        private Method isGlobalRuntimeMethod;
        private static final Class<?> cicManagerClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class<Object>)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                return ContextHelper.getCicManagerClass(ContextHelper.CIC_MANAGER_RESOURCE_NAME, ContextHelper.CIC_MANAGER_CLASS_NAME);
            }
        }) : ContextHelper.getCicManagerClass("META-INF/services/weblogic.invocation.ComponentInvocationContextManager", "weblogic.invocation.ComponentInvocationContextManager");
        private static volatile ContextHelper instance;
        private static final String CIC_MANAGER_RESOURCE_NAME = "META-INF/services/weblogic.invocation.ComponentInvocationContextManager";
        private static final String CIC_MANAGER_CLASS_NAME = "weblogic.invocation.ComponentInvocationContextManager";

        private static Class<?> getCicManagerClass(String cicManagerResourceName, String cicManagerClassName) {
            try {
                if (WebLogic_12_Platform.class.getClassLoader().getResource(cicManagerResourceName) != null) {
                    return PrivilegedAccessHelper.getClassForName(cicManagerClassName);
                }
                return null;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }

        private ContextHelper(final Class<?> managerClass, final String contextClassName) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        this.initialize(managerClass, contextClassName);
                        return null;
                    }
                });
            } else {
                this.initialize(managerClass, contextClassName);
            }
        }

        private void initialize(Class<?> managerClass, String contextClassName) {
            try {
                Method getInstance = PrivilegedAccessHelper.getDeclaredMethod(managerClass, "getInstance", new Class[0]);
                this.cicManagerInstance = PrivilegedAccessHelper.invokeMethod(getInstance, managerClass);
                this.getCurrentCicMethod = PrivilegedAccessHelper.getMethod(managerClass, "getCurrentComponentInvocationContext", new Class[0], true);
                Class cicClass = PrivilegedAccessHelper.getClassForName(contextClassName);
                this.getPartitionIdMethod = PrivilegedAccessHelper.getDeclaredMethod(cicClass, "getPartitionId", new Class[0]);
                this.getPartitionNameMethod = PrivilegedAccessHelper.getDeclaredMethod(cicClass, "getPartitionName", new Class[0]);
                this.isGlobalRuntimeMethod = PrivilegedAccessHelper.getDeclaredMethod(cicClass, "isGlobalRuntime", new Class[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                AbstractSessionLog.getLog().logThrowable(6, null, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ContextHelper getContextHelper() {
            if (cicManagerClass == null) {
                return null;
            }
            if (instance != null) return instance;
            Class<ContextHelper> clazz = ContextHelper.class;
            synchronized (ContextHelper.class) {
                if (instance != null) return instance;
                instance = new ContextHelper(cicManagerClass, "weblogic.invocation.ComponentInvocationContext");
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        String getPartitionID() {
            return this.getStringFromMethod(this.getPartitionIdMethod);
        }

        String getPartitionName() {
            return this.getStringFromMethod(this.getPartitionNameMethod);
        }

        private String getStringFromMethod(final Method methodToCall) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                Object cicInstance = PrivilegedAccessHelper.invokeMethod(getCurrentCicMethod, cicManagerInstance);
                                return (String)PrivilegedAccessHelper.invokeMethod(methodToCall, cicInstance);
                            }
                            catch (ReflectiveOperationException ex) {
                                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                                return "UNKNOWN";
                            }
                        }
                    });
                }
                Object cicInstance = PrivilegedAccessHelper.invokeMethod(this.getCurrentCicMethod, this.cicManagerInstance);
                return (String)PrivilegedAccessHelper.invokeMethod(methodToCall, cicInstance);
            }
            catch (ReflectiveOperationException ex) {
                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                return "UNKNOWN";
            }
        }

        boolean isGlobalRuntime() {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Object cicInstance = PrivilegedAccessHelper.invokeMethod(getCurrentCicMethod, cicManagerInstance);
                                return (Boolean)PrivilegedAccessHelper.invokeMethod(isGlobalRuntimeMethod, cicInstance);
                            }
                            catch (ReflectiveOperationException ex) {
                                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                                return true;
                            }
                        }
                    });
                }
                Object cicInstance = PrivilegedAccessHelper.invokeMethod(this.getCurrentCicMethod, this.cicManagerInstance);
                return (Boolean)PrivilegedAccessHelper.invokeMethod(this.isGlobalRuntimeMethod, cicInstance);
            }
            catch (ReflectiveOperationException ex) {
                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                return true;
            }
        }
    }
}

