/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.spi;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;

public final class ResolvedViewable<T>
extends Viewable {
    private final TemplateProcessor<T> viewProcessor;
    private final T templateReference;
    private final MediaType mediaType;
    private final Class<?> resolvingClass;

    public ResolvedViewable(TemplateProcessor<T> viewProcessor, T templateReference, Viewable viewable, MediaType mediaType) {
        this(viewProcessor, templateReference, viewable, null, mediaType);
    }

    public ResolvedViewable(TemplateProcessor<T> viewProcessor, T templateReference, Viewable viewable, Class<?> resolvingClass, MediaType mediaType) {
        super(viewable.getTemplateName(), viewable.getModel());
        this.viewProcessor = viewProcessor;
        this.templateReference = templateReference;
        this.mediaType = mediaType;
        this.resolvingClass = resolvingClass;
    }

    public void writeTo(OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        this.viewProcessor.writeTo(this.templateReference, this, this.mediaType, httpHeaders, out);
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Class<?> getResolvingClass() {
        return this.resolvingClass;
    }
}

