/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.AddRemove;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.OptionTitle;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ValueType;
import com.sun.webui.jsf.util.ValueTypeEvaluator;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.beans.Beans;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListSelector
extends Selector
implements ListManager,
NamingContainer {
    private static final boolean DEBUG = false;
    private ArrayList<Object> listItems = null;
    private static final String READONLY_FACET = "readOnly";
    private static final String LABEL_FACET = "label";
    public static final String VALUE_ID = "_list_value";
    public static final String VALUE_LABEL_ID = "_hiddenlabel";
    public static final String LIST_ID = "_list";
    private int separatorLength = 0;
    private boolean labelOnTop = false;
    private boolean labelOnTopSet = false;
    private int rows = Integer.MIN_VALUE;
    private boolean rowsSet = false;
    private boolean separators = false;
    private boolean separatorsSet = false;
    private boolean visible = false;
    private boolean visibleSet = false;

    public ListSelector() {
        this.setRendererType("com.sun.webui.jsf.ListSelectorRenderer");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.ListSelector";
    }

    public void checkSelectionModel(FacesContext context) {
        if (this.isMultiple() && this.getValueTypeEvaluator().getValueType() != ValueType.ARRAY) {
            Object[] params = new Object[]{this.toString()};
            String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Selector.multipleError", params);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        this.listItems = new ArrayList();
        this.separatorLength = 0;
        this.processOptions(this.getOptions());
        this.processSelections();
        return this.listItems.iterator();
    }

    public Iterator getListItems() {
        if (this.listItems != null) {
            return this.listItems.iterator();
        }
        this.listItems = new ArrayList();
        this.processOptions(this.getOptions());
        return this.listItems.iterator();
    }

    public int getSeparatorLength() {
        return this.separatorLength;
    }

    protected Option[] getOptions() {
        Option[] options;
        Object optionsObject = this.getItems();
        if (optionsObject instanceof Option[]) {
            options = (Option[])optionsObject;
        } else if (optionsObject instanceof Collection) {
            Object[] objects = ((Collection)optionsObject).toArray();
            int numObjects = objects.length;
            options = new Option[numObjects];
            for (int counter = 0; counter < numObjects; ++counter) {
                options[counter] = (Option)((Object)objects[counter]);
            }
        } else if (optionsObject instanceof Map) {
            Collection itemsCollection = ((Map)optionsObject).values();
            options = (Option[])itemsCollection.toArray();
        } else {
            options = new Option[]{};
        }
        return options;
    }

    protected void processOptions(Option[] options) {
        int length = options.length;
        for (int counter = 0; counter < length; ++counter) {
            if (options[counter] instanceof OptionGroup) {
                OptionGroup selectionGroup = (OptionGroup)options[counter];
                String groupLabel = selectionGroup.getLabel();
                if ((double)groupLabel.length() * 1.5 > (double)this.separatorLength) {
                    this.separatorLength = (int)((double)groupLabel.length() * 1.5);
                }
                this.listItems.add(new StartGroup(groupLabel));
                this.processOptions(selectionGroup.getOptions());
                this.listItems.add(new EndGroup());
                continue;
            }
            if (options[counter] instanceof Separator) {
                this.listItems.add((Object)options[counter]);
                continue;
            }
            this.listItems.add(this.createListItem(options[counter]));
        }
    }

    protected void processSelections() {
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                String[] obj = (String[])value;
                ArrayList<String> list = new ArrayList<String>(obj.length);
                for (int counter = 0; counter < obj.length; ++counter) {
                    list.add(obj[counter]);
                }
                this.markSelectedListItems(list, false);
                return;
            }
            throw new IllegalArgumentException("Illegal submitted value");
        }
        ValueTypeEvaluator valueTypeEvaluator = this.getValueTypeEvaluator();
        if (valueTypeEvaluator.getValueType() == ValueType.NONE || valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        value = this.getValue();
        if (value == null) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            int length = Array.getLength(value);
            for (int counter = 0; counter < length; ++counter) {
                list.add(Array.get(value, counter));
            }
            this.markSelectedListItems(list, true);
            return;
        }
        list.add(value);
        this.markSelectedListItems(list, true);
    }

    protected void markSelectedListItems(List list, boolean processed) {
        block0: for (Object nextItem : this.listItems) {
            if (!(nextItem instanceof ListItem)) continue;
            ListItem option = (ListItem)nextItem;
            option.setSelected(false);
            if (list.isEmpty()) continue;
            Iterator selected = list.iterator();
            while (selected.hasNext()) {
                if (processed) {
                    Object o = selected.next();
                    if (!option.getValueObject().equals(o)) continue;
                    option.setSelected(true);
                    list.remove(o);
                    continue block0;
                }
                String s = (String)selected.next();
                if (!s.equals(option.getValue())) continue;
                option.setSelected(true);
                list.remove(s);
                continue block0;
            }
        }
        if (!list.isEmpty() && !Beans.isDesignTime()) {
            String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "List.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
            ListSelector.log(msg);
        }
    }

    protected ListItem createListItem(Option si) {
        String label = si.getLabel();
        String valueString = ConversionUtilities.convertValueToString((UIComponent)this, si.getValue());
        if (label == null) {
            label = valueString;
        }
        if ((double)label.length() * 1.5 > (double)this.separatorLength) {
            this.separatorLength = (int)((double)label.length() * 1.5);
        }
        ListItem listItem = new ListItem(si.getValue(), label, si.getDescription(), si.isDisabled());
        listItem.setValue(valueString);
        if (si instanceof OptionTitle) {
            listItem.setTitle(true);
        }
        return listItem;
    }

    public UIComponent getLabelComponent() {
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent != null) {
            return labelComponent;
        }
        String labelString = this.getLabel();
        if (labelString == null) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, LABEL_FACET, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, LABEL_FACET));
        }
        this.initLabelFacet(label, labelString, this.getClientId(this.getFacesContext()));
        ComponentUtilities.putPrivateFacet((UIComponent)this, LABEL_FACET, (UIComponent)label);
        return label;
    }

    private void initLabelFacet(Label label, String labelText, String forComponentId) {
        if (labelText == null || labelText.length() < 1) {
            label.setText("");
        } else {
            label.setText(labelText);
        }
        label.setLabelLevel(this.getLabelLevel());
        if (!this.isReadOnly()) {
            label.setFor(forComponentId);
        }
    }

    @Override
    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    @Override
    public String[] getValueAsStringArray(FacesContext context) {
        String[] values = null;
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                values = new String[]{(String)value};
                return values;
            }
        }
        if ((value = this.getValue()) == null) {
            return new String[0];
        }
        ValueTypeEvaluator valueTypeEvaluator = this.getValueTypeEvaluator();
        if (valueTypeEvaluator.getValueType() == ValueType.NONE) {
            return new String[0];
        }
        if (valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            return new String[0];
        }
        if (valueTypeEvaluator.getValueType() == ValueType.LIST) {
            List list = (List)value;
            int counter = list.size();
            values = new String[counter];
            Iterator valueIterator = ((List)value).iterator();
            counter = 0;
            while (valueIterator.hasNext()) {
                String valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueIterator.next());
                values[counter++] = valueString;
            }
        } else if (valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            int counter = Array.getLength(value);
            values = new String[counter];
            for (int i = 0; i < counter; ++i) {
                String valueString;
                Object valueObject = Array.get(value, i);
                values[i] = valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueObject);
            }
        } else if (valueTypeEvaluator.getValueType() == ValueType.OBJECT) {
            values = new String[]{ConversionUtilities.convertValueToString((UIComponent)this, value)};
        }
        return values;
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent();
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(LIST_ID);
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getValueAsReadOnly(FacesContext context, String separator) {
        return "FIX ME!";
    }

    @Override
    public boolean mainListSubmits() {
        return true;
    }

    public boolean isLabelOnTop() {
        if (this.labelOnTopSet) {
            return this.labelOnTop;
        }
        ValueExpression vb = this.getValueExpression("labelOnTop");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setLabelOnTop(boolean newLabelOnTop) {
        this.labelOnTop = newLabelOnTop;
        this.labelOnTopSet = true;
    }

    @Override
    public int getRows() {
        if (this.rowsSet) {
            return this.rows;
        }
        ValueExpression vb = this.getValueExpression("rows");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 12;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
        this.rowsSet = true;
    }

    public boolean isSeparators() {
        if (this.separatorsSet) {
            return this.separators;
        }
        ValueExpression vb = this.getValueExpression("separators");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setSeparators(boolean newSeparators) {
        this.separators = newSeparators;
        this.separatorsSet = true;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.labelOnTop = (Boolean)values[1];
        this.labelOnTopSet = (Boolean)values[2];
        this.rows = (Integer)values[3];
        this.rowsSet = (Boolean)values[4];
        this.separators = (Boolean)values[5];
        this.separatorsSet = (Boolean)values[6];
        this.visible = (Boolean)values[7];
        this.visibleSet = (Boolean)values[8];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.labelOnTop ? Boolean.TRUE : Boolean.FALSE, this.labelOnTopSet ? Boolean.TRUE : Boolean.FALSE, this.rows, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.separators ? Boolean.TRUE : Boolean.FALSE, this.separatorsSet ? Boolean.TRUE : Boolean.FALSE, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    private static void log(String msg) {
        LogUtil.finest(AddRemove.class.getName() + "::" + msg);
    }
}

