/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.PlatformServicesInfo;
import com.sun.enterprise.admin.servermgmt.services.Service;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class ServiceAdapter
implements Service {
    private final Map<String, String> tokenMap = new HashMap<String, String>();
    final PlatformServicesInfo info;

    ServiceAdapter(ServerDirs serverDirs, AppserverServiceType type) {
        this.info = new PlatformServicesInfo(serverDirs, type);
    }

    @Override
    public final void deleteService() {
        this.info.validate();
        this.initialize();
        this.initializeInternal();
        this.deleteServiceInternal();
    }

    @Override
    public PlatformServicesInfo getInfo() {
        return this.info;
    }

    @Override
    public final boolean isDomain() {
        return this.info.type == AppserverServiceType.Domain;
    }

    @Override
    public final boolean isInstance() {
        return this.info.type == AppserverServiceType.Instance;
    }

    @Override
    public final ServerDirs getServerDirs() {
        return this.info.serverDirs;
    }

    @Override
    public final void createService() {
        this.info.validate();
        this.initialize();
        this.initializeInternal();
        this.createServiceInternal();
    }

    @Override
    public String getLocationArgsRestart() {
        return this.getLocationArgsStart();
    }

    void initialize() {
        String parentPath = this.info.serverDirs.getServerParentDir().getPath();
        String serverName = this.info.serverDirs.getServerName();
        this.setAsadminCredentials();
        this.getTokenMap().put("LOCATION", parentPath);
        this.getTokenMap().put("ENTITY_NAME", serverName);
        this.getTokenMap().put("LOCATION_ARGS_START", this.getLocationArgsStart());
        this.getTokenMap().put("LOCATION_ARGS_RESTART", this.getLocationArgsRestart());
        this.getTokenMap().put("LOCATION_ARGS_STOP", this.getLocationArgsStop());
        this.getTokenMap().put("START_COMMAND", this.info.type.startCommand());
        this.getTokenMap().put("RESTART_COMMAND", this.info.type.restartCommand());
        this.getTokenMap().put("STOP_COMMAND", this.info.type.stopCommand());
        this.getTokenMap().put("FQSN", this.info.fqsn);
        this.getTokenMap().put("OS_USER", this.info.osUser);
        if (OS.isWindowsForSure()) {
            this.getTokenMap().put("NAME", this.info.serviceName);
            this.getTokenMap().put("ENTITY_NAME", serverName);
        } else {
            this.getTokenMap().put("NAME", this.info.smfFullServiceName);
        }
        this.getTokenMap().put("AS_ADMIN_PATH", this.info.asadminScript.getPath().replace('\\', '/'));
        this.getTokenMap().put("DATE_CREATED", this.info.date.toString());
        this.getTokenMap().put("TYPE", this.info.type.toString());
        this.getTokenMap().put("CREDENTIALS", this.getCredentials());
    }

    final String getCredentials() {
        if (this.info.passwordFile == null) {
            return " ";
        }
        String user = this.info.appserverUser;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.ok((String)user)) {
            sb.append(" --user ").append(user);
        }
        sb.append(" --passwordfile ").append(this.info.passwordFile.getPath()).append(" ");
        return sb.toString();
    }

    void trace(String s) {
        if (this.info.trace) {
            System.out.println("TRACE:  " + s);
        }
    }

    void dryRun(String s) {
        if (this.info.dryRun) {
            System.out.println("DRYRUN:  " + s);
        }
    }

    final Map<String, String> getTokenMap() {
        return this.tokenMap;
    }

    private void setAsadminCredentials() {
        if (this.info.passwordFile == null) {
            return;
        }
        if (!this.info.passwordFile.isFile()) {
            throw new IllegalArgumentException(Strings.get("windows.services.passwordFileNotA", this.info.passwordFile));
        }
        if (!this.info.passwordFile.canRead()) {
            throw new IllegalArgumentException(Strings.get("windows.services.passwordFileNotReadable", this.info.passwordFile));
        }
        Properties p = this.getProperties(this.info.passwordFile);
        String userFromPasswordFile = p.getProperty("AS_ADMIN_USER");
        if (StringUtils.ok((String)userFromPasswordFile)) {
            this.info.setAppServerUser(p.getProperty("AS_ADMIN_USER"));
        }
    }

    private Properties getProperties(File f) {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(f));
            Properties p = new Properties();
            p.load(bis);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

