/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import jakarta.ejb.Local;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateless;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class EjbClassUtilities {
    EjbClassUtilities() {
    }

    static List<Class<?>> getRemoteAndLocalIfaces(Class<?> resourceClass) {
        List<Class> list;
        LinkedList allLocalOrRemoteIfaces = new LinkedList();
        if (resourceClass.isAnnotationPresent(Remote.class)) {
            list = Arrays.asList(resourceClass.getAnnotation(Remote.class).value());
            allLocalOrRemoteIfaces.addAll(list);
        }
        if (resourceClass.isAnnotationPresent(Local.class)) {
            list = Arrays.asList(resourceClass.getAnnotation(Local.class).value());
            allLocalOrRemoteIfaces.addAll(list);
        }
        for (Class<?> i : resourceClass.getInterfaces()) {
            if (!i.isAnnotationPresent(Remote.class) && !i.isAnnotationPresent(Local.class)) continue;
            allLocalOrRemoteIfaces.add(i);
        }
        if (allLocalOrRemoteIfaces.isEmpty()) {
            for (Class<?> i : resourceClass.getInterfaces()) {
                if (!EjbClassUtilities.isAcceptableLocalInterface(i)) continue;
                allLocalOrRemoteIfaces.add(i);
            }
        }
        return allLocalOrRemoteIfaces;
    }

    private static boolean isAcceptableLocalInterface(Class<?> iface) {
        if (Stateless.class.getPackage().getName().equals(iface.getPackage().getName())) {
            return false;
        }
        return !Serializable.class.equals(iface) && !Externalizable.class.equals(iface);
    }
}

