/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class GlassFishLoggerFinder
extends System.LoggerFinder {
    @Override
    public System.Logger getLogger(String name, Module module) {
        GlassFishLoggingTracer.trace(this.getClass(), () -> "getLogger name: " + name + ", module: " + module.getName());
        return new GlassFishSystemLogger(Logger.getLogger(name));
    }

    private static class GlassFishSystemLogger
    implements System.Logger {
        private final Logger logger;

        private GlassFishSystemLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.logger.isLoggable(this.toJUL(level));
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            this.logger.logrb(this.toJUL(level), bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            this.logger.logrb(this.toJUL(level), bundle, format, params);
        }

        private Level toJUL(System.Logger.Level level) {
            switch (level) {
                case TRACE: {
                    return Level.FINER;
                }
                case DEBUG: {
                    return Level.FINE;
                }
                case INFO: {
                    return Level.INFO;
                }
                case WARNING: {
                    return Level.WARNING;
                }
                case ERROR: {
                    return Level.SEVERE;
                }
                case ALL: {
                    return Level.ALL;
                }
                case OFF: {
                    return Level.OFF;
                }
            }
            throw new IllegalStateException("Unknown level enum: " + String.valueOf((Object)level));
        }
    }
}

