/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.weld.logging.XmlLogger;

public class XmlLogger_$logger
extends DelegatingBasicLogger
implements XmlLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = XmlLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public XmlLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String configurationError$str() {
        return "WELD-001200: Error configuring XML parser";
    }

    @Override
    public final IllegalStateException configurationError(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configurationError$str(), new Object[0]), cause);
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String loadError$str() {
        return "WELD-001201: Error loading beans.xml {0}";
    }

    @Override
    public final IllegalStateException loadError(Object param1, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.loadError$str(), param1), cause);
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String parsingError$str() {
        return "WELD-001202: Error parsing {0}";
    }

    @Override
    public final IllegalStateException parsingError(Object param1, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.parsingError$str(), param1), cause);
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleAlternatives$str() {
        return "WELD-001203: <alternatives> can only be specified once, but appears multiple times:  {0}";
    }

    @Override
    public final DefinitionException multipleAlternatives(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.multipleAlternatives$str(), param1));
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleDecorators$str() {
        return "WELD-001204: <decorators> can only be specified once, but is specified multiple times:  {0}";
    }

    @Override
    public final DefinitionException multipleDecorators(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.multipleDecorators$str(), param1));
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleInterceptors$str() {
        return "WELD-001205: <interceptors> can only be specified once, but it is specified multiple times:  {0}";
    }

    @Override
    public final DefinitionException multipleInterceptors(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.multipleInterceptors$str(), param1));
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleScanning$str() {
        return "WELD-001207: <scan> can only be specified once, but it is specified multiple times:  {0}";
    }

    @Override
    public final DefinitionException multipleScanning(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.multipleScanning$str(), param1));
        XmlLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void xsdValidationError(Object param1, Object param2, Object param3) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.xsdValidationError$str(), param1, param2, param3);
    }

    protected String xsdValidationError$str() {
        return "WELD-001208: Error when validating {0}@{1} against xsd. {2}";
    }

    @Override
    public final void xsdValidationWarning(Object param1, Object param2, Object param3) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.xsdValidationWarning$str(), param1, param2, param3);
    }

    protected String xsdValidationWarning$str() {
        return "WELD-001210: Warning when validating {0}@{1} against xsd. {2}";
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

