/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.AllowedStatementExpression;
import org.jboss.jdeparser.BasicJCommentable;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

abstract class AbstractJCall
extends AbstractJExpr
implements JCall,
AllowedStatementExpression {
    private ArrayList<AbstractJType> typeArgs;
    private ArrayList<AbstractJExpr> args;
    private BasicJCommentable commentable;

    AbstractJCall(int prec) {
        super(prec);
    }

    @Override
    public JCall diamond() {
        throw new UnsupportedOperationException("Adding diamond to method call");
    }

    @Override
    public JCall typeArg(JType type) {
        if (this.typeArgs == null) {
            this.typeArgs = new ArrayList();
        }
        this.typeArgs.add((AbstractJType)type);
        return this;
    }

    @Override
    public JCall typeArg(String type) {
        return this.typeArg(JTypes.typeNamed(type));
    }

    @Override
    public JCall typeArg(Class<?> type) {
        return this.typeArg(JTypes.typeOf(type));
    }

    @Override
    public JCall arg(JExpr expr) {
        if (this.args == null) {
            this.args = new ArrayList();
        }
        this.args.add((AbstractJExpr)expr);
        return this;
    }

    @Override
    public JType[] typeArguments() {
        return this.typeArgs.toArray(new JType[this.typeArgs.size()]);
    }

    @Override
    public JExpr[] arguments() {
        return this.args.toArray(new JExpr[this.args.size()]);
    }

    public JComment lineComment() {
        if (this.commentable == null) {
            this.commentable = new BasicJCommentable();
        }
        return this.commentable.lineComment();
    }

    public JComment blockComment() {
        if (this.commentable == null) {
            this.commentable = new BasicJCommentable();
        }
        return this.commentable.blockComment();
    }

    void writeTypeArgs(SourceFileWriter writer) throws IOException {
        Iterator<AbstractJType> iterator;
        if (this.typeArgs != null && (iterator = this.typeArgs.iterator()).hasNext()) {
            writer.write(Tokens$.PUNCT.ANGLE.OPEN);
            writer.write(iterator.next());
            while (iterator.hasNext()) {
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA_TYPE_ARGUMENT);
                writer.write(iterator.next());
            }
            writer.write(Tokens$.PUNCT.ANGLE.CLOSE);
        }
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        Iterator<AbstractJExpr> iterator;
        writer.write(FormatPreferences.Space.BEFORE_PAREN_METHOD_CALL);
        writer.write(Tokens$.PUNCT.PAREN.OPEN);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION);
        if (this.args != null && (iterator = this.args.iterator()).hasNext()) {
            writer.write(iterator.next());
            while (iterator.hasNext()) {
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA);
                writer.write(iterator.next());
            }
        }
        writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION);
        writer.write(Tokens$.PUNCT.PAREN.CLOSE);
    }
}

