/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.logging.annotation.LogMessageInfo;

public class InstalledLibrariesResolver {
    private static Map<Extension, String> appLibsDirLibsStore = new HashMap<Extension, String>();
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Optional package {0} does not exist or its Specification-Version does not match. Unable to satisfy dependency for {1}", level="WARNING")
    private static final String PACKAGE_NOT_FOUND = "NCLS-DEPLOYMENT-00011";
    @LogMessageInfo(message="Optional package dependency satisfied for {0}", level="INFO")
    private static final String PACKAGE_SATISFIED = "NCLS-DEPLOYMENT-00012";
    @LogMessageInfo(message="Error in opening optional package file {0} due to exception: {1}.", level="WARNING")
    private static final String INVALID_ZIP = "NCLS-DEPLOYMENT-00013";
    @LogMessageInfo(message="Exception occurred : {0}.", level="WARNING")
    private static final String EXCEPTION_OCCURRED = "NCLS-DEPLOYMENT-00014";
    @LogMessageInfo(message="Specification-Version for the optional package [ {0} ] in the jarfile [ {1} ] is not specified. Please provide a valid specification version for this optional package", level="WARNING")
    private static final String NULL_SPEC_VERS = "NCLS-DEPLOYMENT-00015";
    @LogMessageInfo(message="Skipping extension processing for {0} due to error: {1}", level="INFO")
    private static final String SKIPPING_PROCESSING_INFO = "NCLS-DEPLOYMENT-00016";

    public static boolean resolveDependencies(Manifest manifest, String archiveUri) {
        try {
            InstalledLibrariesResolver.getInstalledLibraries(archiveUri, manifest, true, appLibsDirLibsStore);
        }
        catch (MissingResourceException e1) {
            deplLogger.log(Level.WARNING, PACKAGE_NOT_FOUND, new Object[]{e1.getClass(), archiveUri});
            return false;
        }
        deplLogger.log(Level.INFO, PACKAGE_SATISFIED, new Object[]{archiveUri});
        return true;
    }

    public static void initializeInstalledLibRegistry(String libDir) {
        InstalledLibrariesResolver.initializeInstalledLibRegistryForApplibs(libDir);
    }

    public static Set<String> getInstalledLibraries(ReadableArchive archive) throws IOException {
        HashSet<String> libraries = new HashSet<String>();
        if (archive == null) {
            return libraries;
        }
        Manifest manifest = archive.getManifest();
        Set<String> installedLibraries = InstalledLibrariesResolver.getInstalledLibraries(archive.getURI().toString(), manifest, false, appLibsDirLibsStore);
        libraries.addAll(installedLibraries);
        for (String libUri : InstalledLibrariesResolver.getEmbeddedLibraries(archive)) {
            InputStream embeddedLibInputStream = archive.getEntry(libUri);
            try {
                if (embeddedLibInputStream == null || (manifest = new JarInputStream(embeddedLibInputStream).getManifest()) == null) continue;
                libraries.addAll(InstalledLibrariesResolver.getInstalledLibraries(archive.getURI().toString(), manifest, false, appLibsDirLibsStore));
            }
            finally {
                if (embeddedLibInputStream == null) continue;
                embeddedLibInputStream.close();
            }
        }
        return libraries;
    }

    private static Set<String> getInstalledLibraries(String archiveURI, Manifest manifest, boolean strict, Map<Extension, String> libraryStore) {
        HashSet<String> libraries = new HashSet<String>();
        String extensionList = null;
        try {
            if (manifest == null) {
                return libraries;
            }
            extensionList = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
            if (deplLogger.isLoggable(Level.FINE)) {
                deplLogger.log(Level.FINE, "Extension-List for archive [{0}] : ", new Object[]{archiveURI, extensionList});
            }
        }
        catch (Exception e) {
            deplLogger.log(Level.FINE, "InstalledLibrariesResolver : exception occurred.", e);
        }
        if (extensionList != null) {
            StringTokenizer extensionListTokenizer = new StringTokenizer(extensionList, " ");
            while (extensionListTokenizer.hasMoreTokens()) {
                boolean isLibraryInstalled;
                String token = extensionListTokenizer.nextToken().trim();
                String extensionName = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.EXTENSION_NAME);
                if (extensionName != null) {
                    extensionName = extensionName.trim();
                }
                String specVersion = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.SPECIFICATION_VERSION);
                Extension extension = new Extension(extensionName);
                if (specVersion != null) {
                    extension.setSpecVersion(specVersion);
                }
                if (isLibraryInstalled = libraryStore.containsKey(extension)) {
                    libraries.add(libraryStore.get(extension));
                } else if (strict) {
                    throw new MissingResourceException(extensionName + " not found", extensionName, null);
                }
                if (!deplLogger.isLoggable(Level.FINEST)) continue;
                deplLogger.log(Level.FINEST, " is library installed [" + extensionName + "] for archive [" + archiveURI + "]: " + isLibraryInstalled);
            }
        }
        return libraries;
    }

    private static List<String> getEmbeddedLibraries(ReadableArchive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            Collections.emptyList();
        }
        ArrayList<String> libs = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (entryName.indexOf(47) != -1 || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initializeInstalledLibRegistryForApplibs(String domainLibDir) {
        String applibsDirString = domainLibDir + File.separator + "applibs";
        deplLogger.fine("applib-Dir-String..." + applibsDirString);
        ArrayList<File> validApplibsDirLibFiles = new ArrayList<File>();
        Map<Extension, String> installedLibraries = InstalledLibrariesResolver.getInstalledLibraries(applibsDirString, null, validApplibsDirLibFiles);
        appLibsDirLibsStore.putAll(installedLibraries);
        for (File file : validApplibsDirLibFiles) {
            JarFile jarFile = null;
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                try {
                    InstalledLibrariesResolver.getInstalledLibraries(file.getAbsolutePath(), manifest, true, appLibsDirLibsStore);
                }
                catch (MissingResourceException mre) {
                    deplLogger.log(Level.WARNING, PACKAGE_NOT_FOUND, new Object[]{mre.getClass(), file.getAbsolutePath()});
                }
            }
            if (jarFile == null) continue;
            try {
                jarFile.close();
            }
            catch (IOException e) {
                deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
            }
            continue;
            catch (IOException ioe) {
                try {
                    deplLogger.log(Level.WARNING, INVALID_ZIP, new Object[]{file.getAbsolutePath(), ioe.getMessage()});
                    if (jarFile == null) continue;
                }
                catch (Throwable throwable) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
                        }
                    }
                    throw throwable;
                }
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Extension, String> getInstalledLibraries(String libraryDirectoryName, Set<String> processedLibraryNames, List<File> processedLibraries) {
        File[] libraries;
        HashMap<Extension, String> installedLibraries = new HashMap<Extension, String>();
        File dir = new File(libraryDirectoryName);
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "installed library directory : " + dir);
        }
        if ((libraries = dir.listFiles()) != null) {
            try {
                for (File element : libraries) {
                    if (deplLogger.isLoggable(Level.FINE)) {
                        deplLogger.log(Level.FINE, "installed library : " + element);
                    }
                    if (element.isDirectory()) {
                        deplLogger.log(Level.FINE, "Skipping installed library processing on " + element.getAbsolutePath() + "; it is a directory");
                        continue;
                    }
                    if (!element.getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                        deplLogger.log(Level.FINE, "Skipping installed library processing on " + element.getAbsolutePath() + "; it does not appear to be a JAR file based on its file type");
                        continue;
                    }
                    try (JarFile jarFile = null;){
                        jarFile = new JarFile(element);
                        Manifest manifest = jarFile.getManifest();
                        if (processedLibraryNames != null) {
                            processedLibraryNames.add(element.toString());
                        }
                        if (processedLibraries != null) {
                            processedLibraries.add(element);
                        }
                        if (manifest == null) continue;
                        String extName = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
                        String specVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
                        deplLogger.fine("Extension " + element.getAbsolutePath() + ", extNameOfOPtionalPkg..." + extName + ", specVersion..." + specVersion);
                        if (extName == null) continue;
                        if (specVersion == null) {
                            deplLogger.log(Level.WARNING, NULL_SPEC_VERS, new Object[]{extName, jarFile.getName()});
                            specVersion = "";
                        }
                        Extension extension = new Extension(extName);
                        extension.setSpecVersion(specVersion);
                        installedLibraries.put(extension, element.getName());
                    }
                }
            }
            catch (IOException e) {
                deplLogger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.exception", new Object[]{e.getMessage()});
            }
        }
        return installedLibraries;
    }

    static class Extension {
        private String extensionName;
        private String specVersion = "";
        private String specVendor = "";
        private String implVersion = "";
        private String implVendor = "";

        public Extension(String name) {
            this.extensionName = name;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public void setExtensionName(String extensionName) {
            this.extensionName = extensionName;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        public String getSpecVendor() {
            return this.specVendor;
        }

        public void setSpecVendor(String specVendor) {
            this.specVendor = specVendor;
        }

        public String getImplVersion() {
            return this.implVersion;
        }

        public void setImplVersion(String implVersion) {
            this.implVersion = implVersion;
        }

        public String getImplVendor() {
            return this.implVendor;
        }

        public void setImplVendor(String implVendor) {
            this.implVendor = implVendor;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof Extension) {
                Extension e = (Extension)o;
                return !(o != this && (!e.getExtensionName().equals(this.extensionName) || !e.getImplVendor().equals(this.implVendor) && !e.getImplVendor().equals("") || !e.getImplVersion().equals(this.implVersion) && !e.getImplVersion().equals("") || !e.getSpecVendor().equals(this.specVendor) && !e.getSpecVendor().equals("") || !e.getSpecVersion().equals(this.specVersion) && !e.getSpecVersion().equals("")));
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.extensionName.hashCode();
            return result;
        }
    }
}

