/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.embeddable.archive.Assembler;

public class ScatteredEnterpriseArchive {
    String name;
    static final String type = "ear";
    Map<String, File> archives = new HashMap<String, File>();
    Map<String, File> metadatas = new HashMap<String, File>();

    public ScatteredEnterpriseArchive(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null.");
        }
        this.name = name;
    }

    public void addArchive(URI archiveURI) throws IOException {
        this.addArchive(archiveURI, null);
    }

    public void addArchive(URI archiveURI, String name) throws IOException {
        this.addArchive(archiveURI != null ? new File(archiveURI) : null, name);
    }

    public void addArchive(File archive) throws IOException {
        this.addArchive(archive, null);
    }

    public void addArchive(File archive, String name) throws IOException {
        if (archive == null) {
            throw new NullPointerException("archive must not be null.");
        }
        if (!archive.exists()) {
            throw new FileNotFoundException(archive + " does not exist.");
        }
        if (name == null) {
            name = archive.getName();
        }
        this.archives.put(name, archive);
    }

    public void addMetadata(File metadata) throws IOException {
        this.addMetadata(metadata, null);
    }

    public void addMetadata(File metadata, String name) throws IOException {
        if (metadata == null) {
            throw new NullPointerException("metadata must not be null.");
        }
        if (!metadata.exists()) {
            throw new IOException(metadata + " does not exist.");
        }
        if (metadata.isDirectory()) {
            throw new IllegalArgumentException(metadata + " is a directory.");
        }
        if (name == null) {
            name = "META-INF/" + metadata.getName();
        }
        this.metadatas.put((String)name, metadata);
    }

    public URI toURI() throws IOException {
        return new Assembler().assemble(this);
    }
}

