/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cp;

import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfg;
import com.sun.enterprise.glassfish.bootstrap.cp.ClassPathBuilder;
import com.sun.enterprise.glassfish.bootstrap.cp.EmbeddedAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.EquinoxAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.FelixAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.KnopflerfishAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.OsgiPlatformAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class ClassLoaderBuilder {
    private final ClassPathBuilder cpBuilder;
    private final StartupContextCfg cfg;

    private ClassLoaderBuilder(StartupContextCfg cfg) {
        this.cfg = cfg;
        this.cpBuilder = new ClassPathBuilder();
    }

    private void addPlatformDependencies() throws IOException {
        ClassLoaderBuilder.getOsgiPlatformAdapter(this.cfg).addFrameworkJars(this.cpBuilder);
    }

    private ClassLoader build(ClassLoader delegate) {
        return this.cpBuilder.build(delegate);
    }

    private void addLauncherDependencies() throws IOException {
        this.cpBuilder.addJar(this.cfg.getFileUnderInstallRoot(Path.of("modules", "glassfish.jar")));
    }

    private void addServerBootstrapDependencies() throws IOException {
        this.cpBuilder.addJar(this.cfg.getFileUnderInstallRoot(Path.of("modules", "simple-glassfish-api.jar")));
        this.cpBuilder.addJar(this.cfg.getFileUnderInstallRoot(Path.of("lib", "bootstrap", "glassfish-jul-extension.jar")));
    }

    public static ClassLoader createLauncherCL(StartupContextCfg cfg, ClassLoader delegate) {
        try {
            ClassLoader osgiFWLauncherCL = ClassLoaderBuilder.createOSGiFrameworkLauncherCL(cfg, delegate);
            ClassLoaderBuilder clb = new ClassLoaderBuilder(cfg);
            clb.addLauncherDependencies();
            return clb.build(osgiFWLauncherCL);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static ClassLoader createOSGiFrameworkLauncherCL(StartupContextCfg cfg, ClassLoader delegate) {
        try {
            ClassLoaderBuilder clb = new ClassLoaderBuilder(cfg);
            clb.addPlatformDependencies();
            clb.addServerBootstrapDependencies();
            ClassLoader classLoader = clb.build(delegate);
            String osgiPackages = classLoader.resources("META-INF/MANIFEST.MF").map(ClassLoaderBuilder::loadExports).collect(Collectors.joining(", "));
            System.err.println("OSGI framework packages:\n" + osgiPackages);
            String javaPackages = ClassLoaderBuilder.detectJavaPackages();
            System.err.println("JDK provided packages:\n" + javaPackages);
            cfg.setProperty("org.osgi.framework.system.packages", osgiPackages + ", " + javaPackages);
            return classLoader;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static OsgiPlatformAdapter getOsgiPlatformAdapter(StartupContextCfg cfg) {
        OsgiPlatformAdapter osgiPlatformAdapter;
        switch (cfg.getPlatform()) {
            case Felix: {
                osgiPlatformAdapter = new FelixAdapter(cfg);
                break;
            }
            case Knopflerfish: {
                osgiPlatformAdapter = new KnopflerfishAdapter(cfg);
                break;
            }
            case Equinox: {
                osgiPlatformAdapter = new EquinoxAdapter(cfg);
                break;
            }
            case Embedded: 
            case Static: {
                osgiPlatformAdapter = new EmbeddedAdapter();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported platform " + cfg.getPlatform());
            }
        }
        return osgiPlatformAdapter;
    }

    private static String loadExports(URL url) {
        String string;
        block8: {
            InputStream is = url.openStream();
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                string = attributes.getValue("Export-Package");
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not parse manifest from " + url, e);
                }
            }
            is.close();
        }
        return string;
    }

    private static String detectJavaPackages() {
        HashSet<String> packages = new HashSet<String>();
        for (Module module : ModuleLayer.boot().modules()) {
            ClassLoaderBuilder.addAllExportedPackages(module, packages);
        }
        return packages.stream().sorted().collect(Collectors.joining(", "));
    }

    private static void addAllExportedPackages(Module module, Set<String> packages) {
        for (String pkg : module.getPackages()) {
            if (!module.isExported(pkg) && !module.isOpen(pkg)) continue;
            packages.add(pkg);
        }
    }
}

