/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.contain;

import java.util.ArrayList;
import org.glassfish.pfl.basic.contain.IntMap;

public class DenseIntMapImpl<E>
implements IntMap<E> {
    private ArrayList<E> list = new ArrayList();

    private void checkKey(int key) {
        if (key < 0) {
            throw new IllegalArgumentException("Key must be >= 0.");
        }
    }

    @Override
    public E get(int key) {
        this.checkKey(key);
        E result = null;
        if (key < this.list.size()) {
            result = this.list.get(key);
        }
        return result;
    }

    @Override
    public void set(int key, E value) {
        this.checkKey(key);
        this.extend(key);
        this.list.set(key, value);
    }

    private void extend(int index) {
        if (index >= this.list.size()) {
            this.list.ensureCapacity(index + 1);
            int max = this.list.size();
            while (max++ <= index) {
                this.list.add(null);
            }
        }
    }
}

