/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.CachingLinkedHashMap;
import org.jboss.jdeparser.ImplJAnonymousClassDef;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.JAnonymousClassDef;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.NarrowedJType;
import org.jboss.jdeparser.NestedJType;
import org.jboss.jdeparser.NewJCall;
import org.jboss.jdeparser.PrimitiveJType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticRefJExpr;

class ReferenceJType
extends AbstractJType {
    private final PrimitiveJType unboxed;
    private final String packageName;
    private final String simpleName;
    private StaticRefJExpr classExpr;
    private StaticRefJExpr thisExpr;
    private StaticRefJExpr superExpr;
    private CachingLinkedHashMap<String, NestedJType> nestedTypes;

    ReferenceJType(String packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.unboxed = null;
    }

    ReferenceJType(String packageName, String simpleName, PrimitiveJType unboxed) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.unboxed = unboxed;
    }

    static ReferenceJType of(JType type) {
        AbstractJType type1 = AbstractJType.of(type);
        if (type1 instanceof ReferenceJType) {
            return (ReferenceJType)type1;
        }
        throw new IllegalArgumentException("Expected a reference type");
    }

    @Override
    String qualifiedName() {
        if (this.packageName.isEmpty()) {
            return this.simpleName;
        }
        return this.packageName + "." + this.simpleName;
    }

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    @Override
    public JExpr _class() {
        StaticRefJExpr expr = this.classExpr;
        if (expr == null) {
            expr = this.classExpr = new StaticRefJExpr(this, "class");
        }
        return expr;
    }

    @Override
    public JExpr _this() {
        StaticRefJExpr expr = this.thisExpr;
        if (expr == null) {
            expr = this.thisExpr = new StaticRefJExpr(this, "this");
        }
        return expr;
    }

    @Override
    public JExpr _super() {
        StaticRefJExpr expr = this.superExpr;
        if (expr == null) {
            expr = this.superExpr = new StaticRefJExpr(this, "super");
        }
        return expr;
    }

    @Override
    public JCall _new() {
        return new NewJCall(this);
    }

    @Override
    public JAnonymousClassDef _newAnon() {
        return new ImplJAnonymousClassDef(this);
    }

    @Override
    public JType unbox() {
        return this.unboxed == null ? this : this.unboxed;
    }

    @Override
    void writeDirect(SourceFileWriter sourceFileWriter) throws IOException {
        ImplJSourceFile cf = sourceFileWriter.getClassFile();
        String currentPackageName = cf.getPackageName();
        boolean packageMatches = currentPackageName.equals(this.packageName);
        if (packageMatches && cf.hasImport(this.simpleName())) {
            sourceFileWriter.writeClass(this.qualifiedName());
        } else if (this.packageName.equals("java.lang") && !sourceFileWriter.getClassFile().getSources().hasClass(currentPackageName + "." + this.simpleName()) || packageMatches) {
            sourceFileWriter.writeClass(this.simpleName());
        } else if (cf.hasImport(this)) {
            sourceFileWriter.writeClass(this.simpleName());
        } else {
            sourceFileWriter.writeClass(this.qualifiedName());
        }
    }

    @Override
    public JType typeArg(JType ... args) {
        if (this.unboxed != null) {
            return super.typeArg(args);
        }
        return new NarrowedJType(this, args);
    }

    @Override
    public JType nestedType(String name) {
        NestedJType nestedType;
        CachingLinkedHashMap<String, NestedJType> nestedTypes = this.nestedTypes;
        if (nestedTypes == null) {
            this.nestedTypes = new CachingLinkedHashMap();
            nestedTypes = this.nestedTypes;
        }
        if ((nestedType = (NestedJType)nestedTypes.get(name)) == null) {
            nestedType = new NestedJType(this, name);
            nestedTypes.put(name, nestedType);
        }
        return nestedType;
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof ReferenceJType && this.equals((ReferenceJType)other);
    }

    private boolean equals(ReferenceJType other) {
        return this.packageName.equals(other.packageName) && this.simpleName.equals(other.simpleName);
    }

    @Override
    public int hashCode() {
        return this.packageName.hashCode() * 17 + this.simpleName.hashCode();
    }

    @Override
    public String toString() {
        return "Reference of type " + this.simpleName();
    }
}

