/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container.distributed;

import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedReadOnlyBeanNotifier;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedReadOnlyBeanService;
import org.glassfish.persistence.ejb.entitybean.container.distributed.ReadOnlyBeanRefreshEventHandler;

class DistributedReadOnlyBeanServiceImpl
implements DistributedReadOnlyBeanService {
    private Logger _logger = LogDomains.getLogger(DistributedReadOnlyBeanServiceImpl.class, (String)"jakarta.enterprise.system.container.ejb");
    private ConcurrentHashMap<Long, ReadOnlyBeanRefreshHandlerInfo> refreshHandlers = new ConcurrentHashMap();
    private DistributedReadOnlyBeanNotifier robNotifier;

    DistributedReadOnlyBeanServiceImpl() {
    }

    @Override
    public void setDistributedReadOnlyBeanNotifier(DistributedReadOnlyBeanNotifier notifier) {
        this.robNotifier = notifier;
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanNotifier: " + notifier);
    }

    @Override
    public void addReadOnlyBeanRefreshEventHandler(long ejbID, ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
        this.refreshHandlers.put(ejbID, new ReadOnlyBeanRefreshHandlerInfo(loader, handler));
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanRefreshEventHandler: " + ejbID + "; " + handler);
    }

    @Override
    public void removeReadOnlyBeanRefreshEventHandler(long ejbID) {
        this.refreshHandlers.remove(ejbID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRefresh(long ejbID, Object pk) {
        if (this.robNotifier != null) {
            byte[] pkData = null;
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(pk);
                oos.flush();
                bos.flush();
                pkData = bos.toByteArray();
                this.robNotifier.notifyRefresh(ejbID, pkData);
            }
            catch (Exception ex) {
                this._logger.log(Level.WARNING, "Error during notifyRefresh", ex);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefresh: " + ejbID);
        }
    }

    @Override
    public void notifyRefreshAll(long ejbID) {
        if (this.robNotifier != null) {
            this.robNotifier.notifyRefreshAll(ejbID);
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefreshAll: " + ejbID);
        }
    }

    @Override
    public void handleRefreshRequest(long ejbID, byte[] pkData) {
        this.refreshRequestReceived(false, ejbID, pkData);
    }

    @Override
    public void handleRefreshAllRequest(long ejbID) {
        this.refreshRequestReceived(true, ejbID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshRequestReceived(boolean refreshAll, long ejbID, byte[] pkData) {
        ClassLoader prevClassLoader;
        Thread currentThread;
        block41: {
            final ReadOnlyBeanRefreshHandlerInfo info = this.refreshHandlers.get(ejbID);
            if (info == null) {
                return;
            }
            currentThread = Thread.currentThread();
            prevClassLoader = currentThread.getContextClassLoader();
            try {
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(info.loader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            currentThread.setContextClassLoader(info.loader);
                            return null;
                        }
                    });
                }
                if (!refreshAll) {
                    ByteArrayInputStream bis = null;
                    ObjectInputStream ois = null;
                    Serializable pk = null;
                    try {
                        bis = new ByteArrayInputStream(pkData);
                        ois = new ObjectInputStream(bis);
                        pk = (Serializable)ois.readObject();
                    }
                    catch (IOException ioEx) {
                        this._logger.log(Level.WARNING, "Error during refresh", ioEx);
                    }
                    catch (ClassNotFoundException cnfEx) {
                        this._logger.log(Level.WARNING, "Error during refresh", cnfEx);
                    }
                    finally {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException ioEx) {
                                this._logger.log(Level.WARNING, "Error while closing object stream", ioEx);
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException ioEx) {
                                this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx);
                            }
                        }
                    }
                    if (pk != null) {
                        info.handler.handleRefreshRequest(pk);
                    }
                    break block41;
                }
                info.handler.handleRefreshAllRequest();
            }
            catch (Exception ex) {
                try {
                    this._logger.log(Level.WARNING, "Error during refresh", ex);
                }
                catch (Throwable throwable) {
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(prevClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(){
                            final /* synthetic */ Thread val$currentThread;
                            final /* synthetic */ ClassLoader val$prevClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$prevClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$prevClassLoader);
                                return null;
                            }
                        });
                    }
                    throw throwable;
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(prevClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(prevClassLoader);
        } else {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private static class ReadOnlyBeanRefreshHandlerInfo {
        public ClassLoader loader;
        public ReadOnlyBeanRefreshEventHandler handler;

        public ReadOnlyBeanRefreshHandlerInfo(ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
            this.loader = loader;
            this.handler = handler;
        }
    }
}

