/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.rotation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.glassfish.main.jul.rotation.LogFileArchiver;
import org.glassfish.main.jul.rotation.MeteredFileWriter;
import org.glassfish.main.jul.rotation.MeteredStream;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class LogFileManager {
    private static final System.Logger LOG = System.getLogger(LogFileManager.class.getName());
    private static final DateTimeFormatter SUFFIX_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss");
    private final ReentrantLock lock = new ReentrantLock(true);
    private final File logFile;
    private final LogFileArchiver archiver;
    private final Charset fileEncoding;
    private final long maxFileSize;
    private MeteredFileWriter writer;

    public LogFileManager(File logFile, Charset fileEncoding, long maxFileSize, boolean compressOldLogFiles, int maxCountOfOldLogFiles) {
        this.logFile = logFile;
        this.fileEncoding = fileEncoding;
        this.maxFileSize = maxFileSize;
        this.archiver = new LogFileArchiver(logFile, compressOldLogFiles, maxCountOfOldLogFiles);
    }

    public void write(String text) throws IllegalStateException {
        this.lock.lock();
        try {
            if (!this.isOutputEnabled()) {
                throw new IllegalStateException("The file output is disabled!");
            }
            try {
                this.writer.write(text);
            }
            catch (Exception e) {
                GlassFishLoggingTracer.error(this.getClass(), "Could not write to the output stream.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void flush() {
        this.lock.lock();
        try {
            if (this.isOutputEnabled()) {
                try {
                    this.writer.flush();
                }
                catch (IOException e) {
                    GlassFishLoggingTracer.error(this.getClass(), "Could not flush the writer.", e);
                }
            }
            this.rollIfFileTooBig();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getFileSize() {
        this.lock.lock();
        try {
            long l = this.writer == null ? this.logFile.length() : this.writer.getBytesWritten();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rollIfFileTooBig() {
        this.lock.lock();
        try {
            if (this.isRollFileSizeLimitReached()) {
                this.roll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rollIfFileNotEmpty() {
        this.lock.lock();
        try {
            if (this.getFileSize() > 0L) {
                this.roll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void roll() {
        block14: {
            this.lock.lock();
            try {
                boolean wasOutputEnabled = this.isOutputEnabled();
                this.logInfoAsync(() -> "Rolling the file " + this.logFile + "; output was originally enabled: " + wasOutputEnabled);
                this.disableOutput();
                File archivedFile = null;
                try {
                    if (this.logFile.createNewFile()) {
                        return;
                    }
                    archivedFile = this.prepareAchivedLogFileTarget();
                    GlassFishLoggingTracer.trace(LogFileManager.class, "Archived file: " + archivedFile);
                    this.moveFile(this.logFile, archivedFile);
                    this.forceOSFilesync(this.logFile);
                }
                catch (Exception e) {
                    this.logErrorAsync("Error, could not rotate log file " + this.logFile, e);
                    break block14;
                }
                finally {
                    if (wasOutputEnabled) {
                        this.enableOutput();
                    }
                    if (archivedFile != null) {
                        this.archiver.archive(archivedFile);
                    }
                }
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isOutputEnabled() {
        this.lock.lock();
        try {
            boolean bl = this.writer != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableOutput() {
        this.lock.lock();
        try {
            if (this.isOutputEnabled()) {
                throw new IllegalStateException("Output is already enabled!");
            }
            File parent = this.logFile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException("Failed to create the parent directory " + parent.getAbsolutePath());
            }
            try {
                FileOutputStream fout = new FileOutputStream(this.logFile, true);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                MeteredStream stream = new MeteredStream(bout, this.logFile.length());
                this.writer = new MeteredFileWriter(stream, this.fileEncoding);
                GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Output enabled to " + this.logFile);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not open the log file for writing: " + this.logFile, e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disableOutput() {
        this.lock.lock();
        try {
            if (!this.isOutputEnabled()) {
                return;
            }
            try {
                GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Closing writer: " + this.writer);
                this.writer.close();
            }
            catch (IOException e) {
                GlassFishLoggingTracer.error(this.getClass(), "Could not close the output stream.", e);
            }
            this.writer = null;
            GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Output disabled to " + this.logFile);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRollFileSizeLimitReached() {
        if (this.maxFileSize <= 0L) {
            return false;
        }
        long fileSize = this.getFileSize();
        return fileSize >= this.maxFileSize;
    }

    private File prepareAchivedLogFileTarget() {
        String archivedFileNameBase = this.logFile.getName() + "_" + SUFFIX_FORMATTER.format(LocalDateTime.now());
        int counter = 1;
        String archivedFileName = archivedFileNameBase;
        while (true) {
            File archivedLogFile = new File(this.logFile.getParentFile(), archivedFileName);
            File archivedGzLogFile = this.archiver.getGzArchiveFile(archivedLogFile);
            if (!archivedLogFile.exists() && !archivedGzLogFile.exists()) {
                return archivedLogFile;
            }
            archivedFileName = archivedFileNameBase + "_" + ++counter;
        }
    }

    private void forceOSFilesync(File file) throws IOException {
        new FileOutputStream(file).close();
    }

    private void moveFile(File logFileToArchive, File target) throws IOException {
        this.logInfoAsync(() -> "Archiving file " + logFileToArchive + " to " + target);
        try {
            Files.move(logFileToArchive.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException | UnsupportedOperationException e) {
            this.logErrorAsync(String.format("File %s could not be renamed to %s atomically, now trying to move it without this request.", logFileToArchive, target), e);
            Files.move(logFileToArchive.toPath(), target.toPath(), new CopyOption[0]);
        }
    }

    private void logInfoAsync(Supplier<String> message) {
        GlassFishLoggingTracer.trace(this.getClass(), message);
        new Thread(() -> LOG.log(System.Logger.Level.INFO, message), "LogFileManager-Async-Info-Logger").start();
    }

    private void logErrorAsync(String message, Exception exception) {
        GlassFishLoggingTracer.error(this.getClass(), message, exception);
        new Thread(() -> LOG.log(System.Logger.Level.ERROR, message, (Throwable)exception), "LogFileManager-Async-Error-Logger").start();
    }
}

