/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class OutputParameterForCallableStatement
extends BindCallCustomParameter {
    protected boolean isCursor;
    protected int jdbcType;
    protected String typeName;
    protected boolean isTypeNameRequired;
    protected transient DatabasePlatform dbplatform = null;

    public OutputParameterForCallableStatement(DatabaseField field) {
        super(field);
    }

    public OutputParameterForCallableStatement(DatabaseField field, AbstractSession session) {
        this(field, session, false);
    }

    public OutputParameterForCallableStatement(DatabaseField field, AbstractSession session, boolean isCursor) {
        this(field);
        this.isCursor = isCursor;
        this.prepare(session);
    }

    public OutputParameterForCallableStatement(OutputParameterForCallableStatement outParameter) {
        super(outParameter.obj);
        this.isCursor = outParameter.isCursor;
        this.jdbcType = outParameter.jdbcType;
        this.typeName = outParameter.typeName;
        this.isTypeNameRequired = outParameter.isTypeNameRequired;
    }

    protected OutputParameterForCallableStatement() {
    }

    public void setIsCursor(boolean isCursor) {
        this.isCursor = isCursor;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public boolean isTypeNameRequired() {
        return this.isTypeNameRequired;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DatabaseField getOutputField() {
        return (DatabaseField)this.obj;
    }

    public void prepare(AbstractSession session) {
        this.dbplatform = session.getPlatform();
        if (this.isCursor()) {
            this.jdbcType = this.dbplatform.getCursorCode();
        } else {
            this.jdbcType = this.dbplatform.getJDBCType(this.getOutputField());
            if (this.obj instanceof ObjectRelationalDatabaseField) {
                this.isTypeNameRequired = true;
                this.typeName = ((ObjectRelationalDatabaseField)this.obj).getSqlTypeName();
            } else {
                this.isTypeNameRequired = this.dbplatform.requiresTypeNameToRegisterOutputParameter();
                if (this.isTypeNameRequired) {
                    this.typeName = this.dbplatform.getJdbcTypeName(this.jdbcType);
                }
            }
        }
    }

    @Override
    public void set(DatabasePlatform platform, PreparedStatement statement, int parameterIndex, AbstractSession session) throws SQLException {
        if (this.isTypeNameRequired) {
            platform.registerOutputParameter((CallableStatement)statement, parameterIndex, this.jdbcType, this.typeName);
        } else {
            platform.registerOutputParameter((CallableStatement)statement, parameterIndex, this.jdbcType);
        }
    }

    @Override
    public void set(DatabasePlatform platform, CallableStatement statement, String parameterName, AbstractSession session) throws SQLException {
        if (this.isTypeNameRequired) {
            platform.registerOutputParameter(statement, parameterName, this.jdbcType, this.typeName);
        } else {
            platform.registerOutputParameter(statement, parameterName, this.jdbcType);
        }
    }

    @Override
    public String toString() {
        return "=> " + this.getOutputField().getNameDelimited(this.dbplatform);
    }
}

