/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.security.services.common.SecureServiceAccessPermission;

final class SecurityAccessPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 2568719859057815986L;
    private transient Map<String, Permission> perms = new HashMap<String, Permission>(11);
    private boolean all_allowed = false;
    private Class permClass;
    private Logger log;
    private LocalStringManagerImpl localStrings;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", Class.class)};

    public SecurityAccessPermissionCollection(Class clazz, Logger log, LocalStringManagerImpl localStrings) {
        this.permClass = clazz;
        this.log = log;
        this.localStrings = localStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof SecureServiceAccessPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException(this.localStrings.getLocalString("perm.readonly", "attempt to add a Permission to a readonly PermissionCollection"));
        }
        SecureServiceAccessPermission bp = (SecureServiceAccessPermission)permission;
        if (this.permClass == null) {
            this.permClass = bp.getClass();
        } else if (bp.getClass() != this.permClass) {
            throw new IllegalArgumentException(this.localStrings.getLocalString("perm.invalid.perm", "invalid permission: {0}", new Object[]{permission}));
        }
        SecurityAccessPermissionCollection securityAccessPermissionCollection = this;
        synchronized (securityAccessPermissionCollection) {
            this.perms.put(bp.getCanonicalName(), permission);
        }
        if (!this.all_allowed && bp.getCanonicalName().equals("*")) {
            this.all_allowed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        int last;
        Permission x;
        if (!(permission instanceof SecureServiceAccessPermission)) {
            return false;
        }
        SecureServiceAccessPermission bp = (SecureServiceAccessPermission)permission;
        if (bp.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        Object path = bp.getCanonicalName();
        SecurityAccessPermissionCollection securityAccessPermissionCollection = this;
        synchronized (securityAccessPermissionCollection) {
            x = this.perms.get(path);
        }
        if (x != null) {
            return x.implies(permission);
        }
        int offset = ((String)path).length() - 1;
        while ((last = ((String)path).lastIndexOf("/", offset)) != -1) {
            path = ((String)path).substring(0, last + 1) + "*";
            SecurityAccessPermissionCollection securityAccessPermissionCollection2 = this;
            synchronized (securityAccessPermissionCollection2) {
                x = this.perms.get(path);
            }
            if (x != null) {
                return x.implies(permission);
            }
            offset = last - 1;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "pemission collection returns false");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        SecurityAccessPermissionCollection securityAccessPermissionCollection = this;
        synchronized (securityAccessPermissionCollection) {
            return Collections.enumeration(this.perms.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Permission> permissions = new Hashtable<String, Permission>(this.perms.size() * 2);
        SecurityAccessPermissionCollection securityAccessPermissionCollection = this;
        synchronized (securityAccessPermissionCollection) {
            permissions.putAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("permissions", permissions);
        pfields.put("permClass", this.permClass);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Enumeration e;
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new HashMap<String, Permission>(permissions.size() * 2);
        this.perms.putAll(permissions);
        this.all_allowed = gfields.get("all_allowed", false);
        this.permClass = (Class)gfields.get("permClass", null);
        if (this.permClass == null && (e = permissions.elements()).hasMoreElements()) {
            Permission p = (Permission)e.nextElement();
            this.permClass = p.getClass();
        }
    }
}

