/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgRemovalEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgAckEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgEvent;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransactionLogReplayer {
    public static final Logger logger = Globals.getLogger();
    MsgStore msgStore;

    public TransactionLogReplayer(MsgStore msgStore) {
        this.msgStore = msgStore;
    }

    String getPrefix() {
        return "TransactionLogReplayer: " + Thread.currentThread().getName();
    }

    void replayTransactionWork(TransactionWork txnWork, TransactionUID tid, Set dstLoadedSet) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " replayTransactionWork for tid " + tid + " txnWork=" + txnWork;
            logger.log(8, msg);
        }
        this.replaySentMessages(txnWork.getSentMessages(), dstLoadedSet);
        this.replayAcknowledgedMessages(txnWork.getMessageAcknowledgments(), dstLoadedSet);
    }

    private void replaySentMessages(List<TransactionWorkMessage> sentMessages, Set dstLoadedSet) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, this.getPrefix() + " replaySentMessages");
        }
        for (int i = 0; i < sentMessages.size(); ++i) {
            TransactionWorkMessage workMessage = sentMessages.get(i);
            this.replaySentMessage(workMessage, dstLoadedSet);
        }
    }

    private void replaySentMessage(TransactionWorkMessage workMessage, Set dstLoadedSet) throws IOException, BrokerException {
        Packet pkt = workMessage.getMessage();
        SysMessageID mid = pkt.getSysMessageID();
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " replaying sent message: " + workMessage + " dest= " + pkt.getDestination();
            logger.log(8, msg);
        }
        String dname = pkt.getDestination();
        int dtype = pkt.getIsQueue() ? 1 : 2;
        DestinationList DL = Globals.getDestinationList();
        List[] dss = DestinationList.findMatchingIDs(this.msgStore.parent, DestinationUID.getUID(dname, dtype));
        List dlist = dss[0];
        DestinationUID did2 = null;
        for (DestinationUID did2 : dlist) {
            String msg;
            boolean exists;
            Destination[] ds = DestinationList.getDestination((PartitionedStore)this.msgStore.parent, did2, dtype, true, true);
            Destination dst = ds[0];
            did2 = dst.getDestinationUID();
            if (!dstLoadedSet.contains(dst)) {
                dst.load();
                dstLoadedSet.add(dst);
            }
            if (exists = this.msgStore.containsMessage(did2, mid)) {
                if (Store.getDEBUG()) {
                    msg = this.getPrefix() + " stored message exists " + mid;
                    logger.log(8, msg);
                }
                HashMap storedInterests = this.msgStore.getInterestStates(did2, mid);
                boolean matched = this.compareStoredConsumers(mid, workMessage.getStoredInterests(), storedInterests);
                if (matched) continue;
                logger.log(64, "B1276", (Object)mid);
                dst.removeMessage(mid, RemoveReason.REMOVED_OTHER);
                if (this.msgStore.containsMessage(did2, mid)) {
                    this.msgStore.removeMessage(did2, mid, false);
                }
                this.rerouteMessage(pkt, mid, dst);
                continue;
            }
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " stored message does not exist " + mid;
                logger.log(8, msg);
            }
            this.rerouteMessage(pkt, mid, dst);
        }
    }

    private void rerouteMessage(Packet pkt, SysMessageID mid, Destination dst) throws BrokerException {
        logger.log(64, "B1277", (Object)mid, (Object)(dst + " [reroute]"));
        PacketReference pr = PacketReference.createReferenceWithDestination(this.msgStore.parent, pkt, dst, null);
        if (pr.isExpired()) {
            String msg = "not routing expired message on transaction log replay " + mid;
            logger.log(8, msg);
            return;
        }
        try {
            dst.queueMessage(pr, false);
            MessageDeliveryTimeInfo di = pr.getDeliveryTimeInfo();
            if (di == null || di.getOnTimerState() == null) {
                dst.routeNewMessage(pr);
            } else {
                di.setDeliveryReady();
            }
        }
        catch (SelectorFormatException e) {
            throw new BrokerException(Globals.getBrokerResources().getString("B3227", mid), e);
        }
    }

    private boolean compareStoredConsumers(SysMessageID mid, ConsumerUID[] logged, HashMap storedmap) {
        boolean match = true;
        int loggedLength = 0;
        if (logged != null) {
            loggedLength = logged.length;
        }
        if (loggedLength < storedmap.size()) {
            match = false;
            logger.log(32, "Mismatch in number of logged and stored consumers for " + mid + " logged=" + loggedLength + " stored=" + storedmap.size());
        }
        if (loggedLength > storedmap.size()) {
            match = false;
            logger.log(16, "Mismatch in number of logged and stored consumers for " + mid + " logged=" + loggedLength + " stored=" + storedmap.size());
        }
        HashSet<ConsumerUID> loggedSet = new HashSet<ConsumerUID>(loggedLength);
        for (int i = 0; i < loggedLength; ++i) {
            ConsumerUID c = logged[i];
            loggedSet.add(c);
            if (storedmap.containsKey(c)) continue;
            logger.log(16, "stored interest does not contain logged interest. sysid= " + mid + " ConsumerUID=" + c);
            match = false;
        }
        for (Object storedConsumer : storedmap.keySet()) {
            if (loggedSet.contains(storedConsumer)) continue;
            logger.log(32, "logged interests does not contain stored interst. sysid= " + mid + " consumerid=" + storedConsumer);
            match = false;
        }
        if (match && Store.getDEBUG()) {
            String msg = this.getPrefix() + " stored consumers match. numConsumers= " + loggedLength;
            logger.log(8, msg);
        }
        return match;
    }

    public void replayNonTxnMsgAck(NonTransactedMsgAckEvent event, Set dstLoadedSet) throws IOException, BrokerException {
        this.replayAcknowledgedMessage(event.messageAck, dstLoadedSet);
    }

    public void replayNonTxnMsg(NonTransactedMsgEvent event, Set dstLoadedSet) throws IOException, BrokerException {
        this.replaySentMessage(event.message, dstLoadedSet);
    }

    private void replayAcknowledgedMessages(List<TransactionWorkMessageAck> acknowledgedMessages, Set dstLoadedSet) throws IOException, BrokerException {
        for (int i = 0; i < acknowledgedMessages.size(); ++i) {
            TransactionWorkMessageAck messageAck = acknowledgedMessages.get(i);
            this.replayAcknowledgedMessage(messageAck, dstLoadedSet);
        }
    }

    private void replayAcknowledgedMessage(TransactionWorkMessageAck messageAck, Set dstLoadedSet) throws IOException, BrokerException {
        DestinationUID did = messageAck.getDestUID();
        SysMessageID mid = messageAck.getSysMessageID();
        ConsumerUID iid = messageAck.getConsumerID();
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " replaying acknowledged message " + messageAck;
            logger.log(8, msg);
        }
        Globals.getDestinationList();
        Destination[] ds = DestinationList.getDestination((PartitionedStore)this.msgStore.parent, did.getName(), did.isQueue() ? 1 : 2, true, true);
        Destination dst = ds[0];
        if (!dstLoadedSet.contains(dst)) {
            dst.load();
            dstLoadedSet.add(dst);
        }
        if (this.msgStore.containsMessage(did, mid)) {
            logger.log(64, "B1278", (Object)iid, (Object)mid);
            if (dst.isQueue() && iid.longValue() != 0L) {
                this.msgStore.updateInterestState(did, mid, PacketReference.getQueueUID(), 2, false);
            } else {
                this.msgStore.updateInterestState(did, mid, iid, 2, false);
            }
            this.acknowledgeOnReplay(dst, mid, iid);
        } else {
            logger.log(64, "B1279", (Object)iid, (Object)mid);
        }
    }

    public void replayMessageRemoval(MsgRemovalEvent event, Set dstLoadedSet) throws IOException, BrokerException {
        DestinationUID did = event.destUID;
        SysMessageID mid = event.sysMessageID;
        Globals.getDestinationList();
        Destination[] ds = DestinationList.getDestination((PartitionedStore)this.msgStore.parent, did.getName(), did.isQueue() ? 1 : 2, true, true);
        Destination dst = ds[0];
        if (!dstLoadedSet.contains(dst)) {
            dst.load();
            dstLoadedSet.add(dst);
        }
        logger.log(64, Globals.getBrokerResources().getKString("B1391", mid, dst));
        dst.removeMessage(mid, RemoveReason.REMOVED_OTHER);
        if (this.msgStore.containsMessage(did, mid)) {
            this.msgStore.removeMessage(did, mid, false);
        }
    }

    public void acknowledgeOnReplay(Destination dst, SysMessageID mid, ConsumerUID iid) throws IOException, BrokerException {
        String msg;
        PacketReference ref = dst.getMessage(mid);
        boolean allAcked = false;
        if (ref != null) {
            allAcked = ref.acknowledgedOnReplay(iid, iid);
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " acknowledgedOnReplay  " + mid + " allAcked =" + allAcked;
                logger.log(8, msg);
            }
        } else if (Store.getDEBUG()) {
            msg = this.getPrefix() + " did not find packet in destination " + mid;
            logger.log(8, msg);
        }
        if (allAcked) {
            dst.removeMessage(mid, RemoveReason.ACKNOWLEDGED);
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " removed message from destination " + mid;
                logger.log(8, msg);
            }
        }
    }

    public void replayRemoteAcks(TransactionAcknowledgement[] txnAcks, DestinationUID[] destIds, TransactionUID tid, HashSet dstLoadedSet) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " replayRemoteAcks ";
            logger.log(8, msg);
        }
        DestinationList DL = Globals.getDestinationList();
        for (int i = 0; i < txnAcks.length; ++i) {
            TransactionAcknowledgement txnAck = txnAcks[i];
            DestinationUID destId = destIds[i];
            SysMessageID mid = txnAck.getSysMessageID();
            ConsumerUID iid = txnAck.getStoredConsumerUID();
            int type = destId.isQueue() ? 1 : 2;
            Destination[] ds = DestinationList.getDestination((PartitionedStore)this.msgStore.parent, destId.getName(), type, true, true);
            Destination dest = ds[0];
            dest.load();
            PacketReference pr = dest.getMessage(mid);
            if (pr == null) {
                String msg = " could not find packet for replayed message ack " + txnAck + " dest " + destId + " in transaction " + tid;
                logger.log(16, msg);
                continue;
            }
            if (this.msgStore.containsMessage(destId, mid)) {
                logger.log(64, "B1278", (Object)iid, (Object)mid);
                if (dest.isQueue() && iid.longValue() != 0L) {
                    this.msgStore.updateInterestState(destId, mid, PacketReference.getQueueUID(), 2, false);
                } else {
                    this.msgStore.updateInterestState(destId, mid, iid, 2, false);
                }
                this.acknowledgeOnReplay(dest, mid, iid);
                continue;
            }
            logger.log(64, "B1279", (Object)iid, (Object)mid);
        }
    }
}

