/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tcp;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpStreams;
import com.sun.messaging.jmq.util.net.MQServerSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;

public class TcpProtocol
implements Protocol {
    private static boolean DEBUG = false;
    private static ServerSocketFactory ssf = MQServerSocketFactory.getDefault();
    public static final int defaultReadTimeout = 0;
    public static final int defaultLingerTimeout = 0;
    public static final int defaultPort = 8888;
    public static final int defaultBacklog = 100;
    protected static final Integer zero = 0;
    protected static final Integer one = 1;
    protected ProtocolCallback cb = null;
    protected Object callback_data = null;
    protected boolean canChangeBlocking = true;
    protected int readTimeout = 0;
    protected int lingerTimeout = 0;
    protected int port = 8888;
    protected String hostname = null;
    protected int backlog = 100;
    protected boolean nodelay = true;
    protected boolean blocking = true;
    protected int inputBufferSize = 0;
    protected int outputBufferSize = 0;
    protected ServerSocket serversocket = null;
    ServerSocketChannel chl = null;
    Selector selector = null;
    SelectionKey key = null;
    private boolean useChannels = false;
    Object protocolLock = new Object();
    private String modelName = null;
    boolean resetSocket = false;
    boolean startSocket = false;

    @Override
    public void registerProtocolCallback(ProtocolCallback cb, Object callback_data) {
        this.cb = cb;
        this.callback_data = callback_data;
    }

    protected void notifyProtocolCallback() {
        if (this.cb == null) {
            return;
        }
        this.cb.socketUpdated(this.callback_data, this.getLocalPort(), this.hostname);
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSocket createSocket(String hostname, int port, int backlog, boolean blocking, boolean useChannel) throws IOException {
        ServerSocket svc = null;
        Object object = this.protocolLock;
        synchronized (object) {
            this.useChannels = useChannel;
            this.blocking = blocking;
            if (hostname != null && hostname.trim().length() == 0) {
                hostname = null;
            }
            if (this.useChannels) {
                if (!blocking && this.selector == null) {
                    this.selector = Selector.open();
                }
                this.chl = ServerSocketChannel.open();
                svc = this.chl.socket();
                svc.setReuseAddress(true);
                InetSocketAddress endpoint = null;
                endpoint = hostname == null || hostname.equals("*") ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
                svc.bind(endpoint, backlog);
                this.serversocket = svc;
                if (!blocking) {
                    this.configureBlocking(blocking);
                    this.key = this.chl.register(this.selector, 16);
                    this.selector.wakeup();
                }
            } else if (hostname == null || hostname.equals("*")) {
                svc = ssf.createServerSocket(port, backlog);
            } else {
                InetAddress endpoint = InetAddress.getByName(hostname);
                svc = ssf.createServerSocket(port, backlog, endpoint);
            }
        }
        if (DEBUG && svc != null) {
            Globals.getLogger().log(4, "TcpProtocol.creatSocket: " + svc + " " + MQServerSocketFactory.serverSocketToString((ServerSocket)svc) + ", backlog=" + backlog);
        }
        return svc;
    }

    @Override
    public void configureBlocking(boolean blocking) throws UnsupportedOperationException, IOException {
        if (!this.useChannels) {
            return;
        }
        if (!this.canChangeBlocking && !blocking) {
            throw new UnsupportedOperationException(Globals.getBrokerResources().getKString("B4117", "This protocol can not be non-blocking"));
        }
        AbstractSelectableChannel asc = this.getChannel();
        if (asc == null) {
            throw new UnsupportedOperationException(Globals.getBrokerResources().getKString("B4117", "Can not change blocking because there isnt a socket channel"));
        }
        this.blocking = blocking;
        asc.configureBlocking(blocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractSelectableChannel getChannel() throws IOException {
        Object object = this.protocolLock;
        synchronized (object) {
            if (this.serversocket == null) {
                return null;
            }
            return this.serversocket.getChannel();
        }
    }

    protected TcpStreams createConnection(Socket socket) throws IOException {
        return new TcpStreams(socket, this.blocking, this.inputBufferSize, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProtocolStreams accept() throws IOException {
        ServerSocket currentsocket = null;
        Object object = this.protocolLock;
        synchronized (object) {
            currentsocket = this.serversocket;
        }
        try {
            Socket s = null;
            if (this.useChannels && !this.blocking) {
                int cnt = this.selector.select();
                if (this.resetSocket) {
                    try {
                        this.close();
                        this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                        this.notifyProtocolCallback();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.resetSocket = false;
                    }
                }
                if (this.startSocket) {
                    try {
                        this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                        this.notifyProtocolCallback();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.startSocket = false;
                    }
                }
                if (cnt <= 0) return this.accept();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> itr = keys.iterator();
                if (itr.hasNext()) {
                    SelectionKey listenkey = itr.next();
                    itr.remove();
                    ServerSocketChannel channel = (ServerSocketChannel)listenkey.channel();
                    SocketChannel sch = channel.accept();
                    s = sch.socket();
                }
            } else if (this.serversocket != null) {
                s = this.serversocket.accept();
            }
            if (s == null) {
                throw new IOException(Globals.getBrokerResources().getKString("B4117", "no socket"));
            }
            try {
                s.setTcpNoDelay(this.nodelay);
            }
            catch (SocketException e) {
                Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + s.toString() + "]setTcpNoDelay(" + this.nodelay + "): " + e.toString(), (Throwable)e);
            }
            if (this.readTimeout > 0) {
                try {
                    s.setSoTimeout(this.readTimeout * 1000);
                }
                catch (SocketException e) {
                    Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + s.toString() + "]setSoTimeout(" + this.readTimeout + "): " + e.toString(), (Throwable)e);
                }
            }
            if (this.lingerTimeout <= 0) return this.createConnection(s);
            try {
                s.setSoLinger(true, this.lingerTimeout * 1000);
                return this.createConnection(s);
            }
            catch (SocketException e) {
                Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + s.toString() + "]setSoLinger(" + this.lingerTimeout + "): " + e.toString(), (Throwable)e);
            }
            return this.createConnection(s);
        }
        catch (IOException ex) {
            if (currentsocket == this.serversocket) throw ex;
            return this.accept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException, IllegalStateException {
        Object object = this.protocolLock;
        synchronized (object) {
            if (this.selector != null && !this.startSocket) {
                this.startSocket = true;
                this.selector.wakeup();
                return;
            }
            if (this.serversocket != null || this.startSocket) {
                throw new IOException(Globals.getBrokerResources().getString("B4117", "can not open already opened protocol"));
            }
            this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
            this.notifyProtocolCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.protocolLock;
        synchronized (object) {
            return this.serversocket != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, IllegalStateException {
        Object object = this.protocolLock;
        synchronized (object) {
            try {
                if (this.serversocket == null) {
                    throw new IOException(Globals.getBrokerResources().getString("B4117", "can not close un-opened protocol"));
                }
                ServerSocketChannel channel = (ServerSocketChannel)this.getChannel();
                if (channel != null) {
                    SelectionKey mykey = channel.keyFor(this.selector);
                    if (mykey != null) {
                        mykey.cancel();
                    }
                    channel.close();
                }
                this.serversocket.close();
            }
            finally {
                this.serversocket = null;
                this.key = null;
            }
        }
    }

    @Override
    public void checkParameters(Map params) throws IllegalArgumentException {
        TcpProtocol.checkTcpParameters(params);
    }

    public static void checkTcpParameters(Map params) throws IllegalArgumentException {
        TcpProtocol.checkIntValue("port", params, zero, null);
        TcpProtocol.checkIntValue("backlog", params, one, null);
    }

    @Override
    public Map setParameters(Map params) throws IOException {
        boolean newhost;
        if (params.get("serviceFactoryHandlerName") != null) {
            this.modelName = (String)params.get("serviceFactoryHandlerName");
        }
        boolean active = this.serversocket != null;
        int newport = TcpProtocol.getIntValue("port", params, this.port);
        this.readTimeout = TcpProtocol.getIntValue("readtimeout", params, this.readTimeout);
        this.lingerTimeout = TcpProtocol.getIntValue("solinger", params, this.lingerTimeout);
        int newbacklog = TcpProtocol.getIntValue("backlog", params, this.backlog);
        this.blocking = TcpProtocol.getBooleanValue("blocking", params, this.blocking);
        this.useChannels = TcpProtocol.getBooleanValue("useChannels", params, this.useChannels);
        String newhostname = (String)params.get("hostname");
        if (newhostname == null) {
            newhostname = Globals.getHostname();
        }
        if (newhostname == null || newhostname.trim().length() == 0) {
            newhostname = "*";
        }
        int oldport = this.port;
        int oldbacklog = this.backlog;
        boolean bl = newhost = newhostname == null && this.hostname != null || newhostname != null && this.hostname == null || newhostname != null && this.hostname != null && !newhostname.equals(this.hostname);
        if (newport != this.port || newbacklog != this.backlog || newhost) {
            if (newport != -1) {
                this.port = newport;
            }
            if (newbacklog != -1) {
                this.backlog = newbacklog;
            }
            if (newhost) {
                this.hostname = newhostname;
            }
            if (!active) {
                return null;
            }
            if (this.getChannel() != null) {
                this.resetSocket = true;
                this.selector.wakeup();
                return null;
            }
            ServerSocket oldserversocket = this.serversocket;
            try {
                this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                this.notifyProtocolCallback();
                oldserversocket.close();
            }
            catch (IOException ex) {
                this.serversocket = oldserversocket;
                this.port = oldport;
                this.backlog = oldbacklog;
                throw ex;
            }
        }
        return null;
    }

    private static int checkIntValue(String propname, Map params) throws IllegalArgumentException {
        if (params == null) {
            return -1;
        }
        String propvalstr = (String)params.get(propname);
        if (propvalstr == null) {
            return -1;
        }
        try {
            return Integer.parseInt(propvalstr);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", "Can not convert " + propname));
        }
    }

    private static int checkIntValue(String propname, Map params, Integer min, Integer max) throws IllegalArgumentException {
        int value = TcpProtocol.checkIntValue(propname, params);
        if (value == -1) {
            return value;
        }
        if (min != null && value < min) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", propname + "(" + value + ") value below minimum of " + min));
        }
        if (max != null && value > max) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", propname + "(" + value + ") value above maximum of " + max));
        }
        return value;
    }

    public static int getIntValue(String propname, Map params, int defval) {
        String propvalstr = (String)params.get(propname);
        if (propvalstr == null) {
            return defval;
        }
        try {
            int val = Integer.parseInt(propvalstr);
            return val;
        }
        catch (Exception ex) {
            Globals.getLogger().log(8, "B3138", (Object)propname, (Throwable)ex);
            return defval;
        }
    }

    public static boolean getBooleanValue(String propname, Map params, boolean defval) {
        String propvalstr = (String)params.get(propname);
        if (propvalstr == null) {
            return defval;
        }
        try {
            boolean val = Boolean.valueOf(propvalstr);
            return val;
        }
        catch (Exception ex) {
            Globals.getLogger().log(8, "B3138", (Object)propname, (Throwable)ex);
            return defval;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public int getLocalPort() {
        if (this.serversocket == null) {
            return 0;
        }
        return this.serversocket.getLocalPort();
    }

    public String toString() {
        boolean nio = this.chl != null;
        boolean blockednio = nio && this.blocking;
        return "tcp(host = " + (this.hostname == null ? "*" : this.hostname) + ", port=" + this.port + ", mode=" + this.modelName + (blockednio ? " [blocked i/o]" : "") + ")";
    }

    @Override
    public void setNoDelay(boolean val) {
        this.nodelay = val;
    }

    @Override
    public void setTimeout(int val) {
        throw new UnsupportedOperationException("Setting timeouts no longer supported");
    }

    @Override
    public void setInputBufferSize(int val) {
        this.inputBufferSize = val;
    }

    @Override
    public void setOutputBufferSize(int val) {
        this.outputBufferSize = val;
    }

    @Override
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public boolean getBlocking() {
        return this.blocking;
    }
}

