/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.wsit;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public final class TCPTransportPolicyValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> clientSupportedAssertions = new ArrayList(2);
    private static final ArrayList<QName> commonSupportedAssertions = new ArrayList(2);

    @Override
    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion assertion) {
        return clientSupportedAssertions.contains(assertion.getName()) || commonSupportedAssertions.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion assertion) {
        return commonSupportedAssertions.contains(assertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public String[] declareSupportedDomains() {
        return new String[]{"http://java.sun.com/xml/ns/wsit/2006/09/policy/soaptcp/service", "http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client", "http://java.sun.com/xml/ns/wsit/2006/09/policy/soaptcp"};
    }

    static {
        clientSupportedAssertions.add(TCPConstants.SELECT_OPTIMAL_TRANSPORT_ASSERTION);
        commonSupportedAssertions.add(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION);
        commonSupportedAssertions.add(TCPConstants.TCPTRANSPORT_CONNECTION_MANAGEMENT_ASSERTION);
    }
}

