/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl;

import com.sun.faces.application.applicationimpl.events.ComponentSystemEventHelper;
import com.sun.faces.application.applicationimpl.events.EventInfo;
import com.sun.faces.application.applicationimpl.events.ReentrantLisneterInvocationGuard;
import com.sun.faces.application.applicationimpl.events.SystemEventHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.event.SystemEventListenerHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Events {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String CONTEXT = "context";
    private static final String LISTENER = "listener";
    private static final String SOURCE = "source";
    private static final String SYSTEM_EVENT_CLASS = "systemEventClass";
    private final SystemEventHelper systemEventHelper = new SystemEventHelper();
    private final ComponentSystemEventHelper compSysEventHelper = new ComponentSystemEventHelper();
    private ReentrantLisneterInvocationGuard listenerInvocationGuard = new ReentrantLisneterInvocationGuard();

    public void publishEvent(FacesContext context, Class<? extends SystemEvent> systemEventClass, Object source, ProjectStage projectStage) {
        this.publishEvent(context, systemEventClass, null, source, projectStage);
    }

    public void publishEvent(FacesContext context, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source, ProjectStage projectStage) {
        Util.notNull(CONTEXT, context);
        Util.notNull(SYSTEM_EVENT_CLASS, systemEventClass);
        Util.notNull(SOURCE, source);
        if (!this.needsProcessing(context, systemEventClass)) {
            return;
        }
        if (projectStage == ProjectStage.Development && sourceBaseType != null && !sourceBaseType.isInstance(source)) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.publish.event.base_type_mismatch", new Object[]{source.getClass().getName(), sourceBaseType.getName()});
            }
            return;
        }
        try {
            SystemEvent event = this.invokeComponentListenersFor(systemEventClass, source);
            event = this.invokeViewListenersFor(context, systemEventClass, event, source);
            event = this.invokeListenersFor(systemEventClass, event, source, sourceBaseType, true);
            this.invokeListenersFor(systemEventClass, event, source, null, false);
        }
        catch (AbortProcessingException ape) {
            context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, new ExceptionQueuedEventContext(context, ape));
        }
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.subscribeToEvent(systemEventClass, null, listener);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        Util.notNull(SYSTEM_EVENT_CLASS, systemEventClass);
        Util.notNull(LISTENER, listener);
        this.getListeners(systemEventClass, sourceClass).add(listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        Util.notNull(SYSTEM_EVENT_CLASS, systemEventClass);
        Util.notNull(LISTENER, listener);
        Set<SystemEventListener> listeners = this.getListeners(systemEventClass, sourceClass);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private Set<SystemEventListener> getListeners(Class<? extends SystemEvent> systemEvent, Class<?> sourceClass) {
        Set<SystemEventListener> listeners = null;
        EventInfo sourceInfo = this.systemEventHelper.getEventInfo(systemEvent, sourceClass);
        if (sourceInfo != null) {
            listeners = sourceInfo.getListeners();
        }
        return listeners;
    }

    private boolean needsProcessing(FacesContext context, Class<? extends SystemEvent> systemEventClass) {
        return context.isProcessingEvents() || ExceptionQueuedEvent.class.isAssignableFrom(systemEventClass);
    }

    private SystemEvent invokeComponentListenersFor(Class<? extends SystemEvent> systemEventClass, Object source) {
        if (source instanceof SystemEventListenerHolder) {
            List<SystemEventListener> listeners = ((SystemEventListenerHolder)source).getListenersForEventClass(systemEventClass);
            if (null == listeners) {
                return null;
            }
            EventInfo eventInfo = this.compSysEventHelper.getEventInfo(systemEventClass, source.getClass());
            return this.processListeners(listeners, null, source, eventInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemEvent invokeViewListenersFor(FacesContext ctx, Class<? extends SystemEvent> systemEventClass, SystemEvent event, Object source) {
        SystemEvent result = event;
        if (this.listenerInvocationGuard.isGuardSet(ctx, systemEventClass)) {
            return result;
        }
        this.listenerInvocationGuard.setGuard(ctx, systemEventClass);
        UIViewRoot root = ctx.getViewRoot();
        try {
            if (root != null) {
                List<SystemEventListener> listeners = root.getViewListenersForEventClass(systemEventClass);
                if (null == listeners) {
                    SystemEvent systemEvent = null;
                    return systemEvent;
                }
                EventInfo rootEventInfo = this.systemEventHelper.getEventInfo(systemEventClass, UIViewRoot.class);
                result = this.processListenersAccountingForAdds(listeners, event, source, rootEventInfo);
            }
        }
        finally {
            this.listenerInvocationGuard.clearGuard(ctx, systemEventClass);
        }
        return result;
    }

    private SystemEvent invokeListenersFor(Class<? extends SystemEvent> systemEventClass, SystemEvent event, Object source, Class<?> sourceBaseType, boolean useSourceLookup) throws AbortProcessingException {
        EventInfo eventInfo = this.systemEventHelper.getEventInfo(systemEventClass, source, sourceBaseType, useSourceLookup);
        if (eventInfo != null) {
            Set<SystemEventListener> listeners = eventInfo.getListeners();
            event = this.processListeners(listeners, event, source, eventInfo);
        }
        return event;
    }

    private SystemEvent processListeners(Collection<SystemEventListener> listeners, SystemEvent event, Object source, EventInfo eventInfo) {
        if (listeners != null && !listeners.isEmpty()) {
            ArrayList<SystemEventListener> list = new ArrayList<SystemEventListener>(listeners);
            for (SystemEventListener curListener : list) {
                if (curListener == null || !curListener.isListenerForSource(source)) continue;
                if (event == null) {
                    event = eventInfo.createSystemEvent(source);
                }
                assert (event != null);
                if (!event.isAppropriateListener(curListener)) continue;
                event.processListener(curListener);
            }
        }
        return event;
    }

    private SystemEvent processListenersAccountingForAdds(List<SystemEventListener> listeners, SystemEvent event, Object source, EventInfo eventInfo) {
        if (listeners != null && !listeners.isEmpty()) {
            SystemEventListener[] listenersCopy = new SystemEventListener[listeners.size()];
            int i = 0;
            for (i = 0; i < listenersCopy.length; ++i) {
                listenersCopy[i] = listeners.get(i);
            }
            HashMap<SystemEventListener, Boolean> processedListeners = new HashMap<SystemEventListener, Boolean>(listeners.size());
            boolean processedSomeEvents = false;
            boolean originalDiffersFromCopy = false;
            do {
                i = 0;
                originalDiffersFromCopy = false;
                if (0 >= listenersCopy.length) continue;
                for (i = 0; i < listenersCopy.length; ++i) {
                    SystemEventListener curListener = listenersCopy[i];
                    if (curListener == null || !curListener.isListenerForSource(source)) continue;
                    if (event == null) {
                        event = eventInfo.createSystemEvent(source);
                    }
                    assert (event != null);
                    if (processedListeners.containsKey(curListener) || !event.isAppropriateListener(curListener)) continue;
                    processedSomeEvents = true;
                    event.processListener(curListener);
                    processedListeners.put(curListener, Boolean.TRUE);
                }
                if (!this.originalDiffersFromCopy(listeners, listenersCopy)) continue;
                originalDiffersFromCopy = true;
                listenersCopy = this.copyListWithExclusions(listeners, processedListeners);
            } while (originalDiffersFromCopy && processedSomeEvents);
        }
        return event;
    }

    private boolean originalDiffersFromCopy(Collection<SystemEventListener> original, SystemEventListener[] copy) {
        int copyLen;
        boolean foundDifference = false;
        int i = 0;
        int originalLen = original.size();
        if (originalLen == (copyLen = copy.length)) {
            Iterator<SystemEventListener> iter = original.iterator();
            while (iter.hasNext() && !foundDifference) {
                SystemEventListener copyItem;
                SystemEventListener originalItem = iter.next();
                foundDifference = originalItem != (copyItem = copy[i++]);
            }
        } else {
            foundDifference = true;
        }
        return foundDifference;
    }

    private SystemEventListener[] copyListWithExclusions(Collection<SystemEventListener> original, Map<SystemEventListener, Boolean> excludes) {
        SystemEventListener[] result = null;
        SystemEventListener[] temp = new SystemEventListener[original.size()];
        int i = 0;
        for (SystemEventListener cur : original) {
            if (excludes.containsKey(cur)) continue;
            temp[i++] = cur;
        }
        result = new SystemEventListener[i];
        System.arraycopy(temp, 0, result, 0, i);
        return result;
    }
}

