/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.management.mbeans.resources.MBeanResources;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class MQMBeanReadOnly
extends NotificationBroadcasterSupport
implements DynamicMBean {
    int sequenceNumber = 0;
    protected Logger logger = Globals.getLogger();
    private String dClassName = this.getClass().getName();
    protected static final BrokerResources rb = Globals.getBrokerResources();
    protected static final MBeanResources mbr = Globals.getMBeanResources();
    private MBeanInfo dMBeanInfo = null;
    protected DestinationList DL = Globals.getDestinationList();

    public MQMBeanReadOnly() {
        this.buildDynamicMBeanInfo();
    }

    public abstract String getMBeanName();

    public abstract String getMBeanDescription();

    public abstract MBeanAttributeInfo[] getMBeanAttributeInfo();

    public abstract MBeanOperationInfo[] getMBeanOperationInfo();

    public abstract MBeanNotificationInfo[] getMBeanNotificationInfo();

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = null;
        if (attribute != null) {
            name = attribute.getName();
        }
        throw new AttributeNotFoundException("Attribute " + name + " cannot be set in MBean: " + this.getMBeanName());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute list passed to setAttributes()"));
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                String tmp = "MBean " + this.getMBeanName() + ": Problem encountered while setting attribute " + attr.getName() + ": " + e.toString();
                this.logger.log(16, tmp, e);
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object ret;
        block8: {
            if (operationName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Null Operation name passed to invoke()"));
            }
            MBeanOperationInfo op = this.getOperationInfo(operationName, signature);
            Method m = null;
            ret = null;
            if (op == null) {
                m = this.getIsIsMethod(operationName);
                if (m == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Invalid operation name and/or signature passed to invoke(): " + operationName));
                }
            } else {
                m = this.getMethod(op);
            }
            try {
                if (m == null) break block8;
                final Method finalM = m;
                final Object[] finalParams = params;
                final MQMBeanReadOnly receiver = this;
                try {
                    ret = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            return finalM.invoke((Object)receiver, finalParams);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                throw new MBeanException(e, "Exception caught while invoking operation " + operationName + " in MBean " + this.getMBeanName());
            }
        }
        return ret;
    }

    private Method getMethod(MBeanOperationInfo op) throws ReflectionException {
        Method m = null;
        String methodName = null;
        if (op == null) {
            return null;
        }
        try {
            Class[] methodParams = null;
            MBeanParameterInfo[] params = op.getSignature();
            methodName = op.getName();
            if (params != null && params.length > 0) {
                methodParams = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String className = params[i].getType();
                    try {
                        Class<?> paramClass;
                        methodParams[i] = paramClass = Class.forName(className);
                        continue;
                    }
                    catch (ClassNotFoundException cnfE) {
                        throw new ReflectionException(cnfE, "Parameter type/class not found for operation" + methodName + " in MBean " + this.getMBeanName());
                    }
                }
            }
            m = this.getClass().getMethod(methodName, methodParams);
        }
        catch (NoSuchMethodException noSuchE) {
            throw new ReflectionException(noSuchE, "Operation " + methodName + " does not exist in MBean" + this.getMBeanName());
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        return m;
    }

    private Method getIsIsMethod(String operationName) throws ReflectionException {
        Method m = null;
        String methodName = null;
        if (operationName == null) {
            return null;
        }
        String attr = operationName.substring(2);
        try {
            this.checkIsIsAttribute(attr);
        }
        catch (Exception e) {
            return null;
        }
        methodName = operationName;
        try {
            m = this.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchE) {
            throw new ReflectionException(noSuchE, "Operation " + methodName + " does not exist in MBean" + this.getMBeanName());
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        return m;
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute list passed to getAttributes()"));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                String tmp = "MBean " + this.getMBeanName() + ": Problem encountered while getting attribute " + attributeNames[i] + ": " + e.toString();
                this.logger.log(16, tmp, e);
            }
        }
        return resultList;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute passed to getAttribute()"));
        }
        this.checkReadableAttribute(attributeName);
        Method m = null;
        String methodName = "get" + attributeName;
        Object ret = null;
        try {
            Class<?>[] methodParams = null;
            m = this.getClass().getMethod(methodName, methodParams);
        }
        catch (NoSuchMethodException noSuchE) {
            String tmp = "MBean " + this.getMBeanName() + ": Cannot find method " + methodName;
            throw new ReflectionException(noSuchE, tmp);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        try {
            Object[] params = null;
            ret = m.invoke((Object)this, params);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return ret;
    }

    private void checkReadableAttribute(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("The attribute " + name + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!attrInfo.isReadable()) {
            throw new AttributeNotFoundException("The attribute " + name + " is not a gettable attribute for MBean" + this.getMBeanName());
        }
    }

    private void checkIsIsAttribute(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("The attribute " + name + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!attrInfo.isIs()) {
            throw new AttributeNotFoundException("The attribute " + name + " is not an isIs attribute for MBean" + this.getMBeanName());
        }
    }

    public MBeanAttributeInfo getAttributeInfo(String name) {
        MBeanAttributeInfo[] attrs = this.getMBeanAttributeInfo();
        if (attrs == null) {
            return null;
        }
        for (int i = 0; i < attrs.length; ++i) {
            MBeanAttributeInfo oneAttr = attrs[i];
            if (!oneAttr.getName().equals(name)) continue;
            return oneAttr;
        }
        return null;
    }

    public MBeanOperationInfo getOperationInfo(String operationName, String[] signature) {
        MBeanOperationInfo[] ops = this.getMBeanOperationInfo();
        if (ops == null) {
            return null;
        }
        for (int i = 0; i < ops.length; ++i) {
            MBeanOperationInfo oneOp = ops[i];
            if (!oneOp.getName().equals(operationName) || !this.operationSignatureOK(oneOp, signature)) continue;
            return oneOp;
        }
        return null;
    }

    private boolean operationSignatureOK(MBeanOperationInfo op, String[] signature) {
        if (op == null) {
            return false;
        }
        MBeanParameterInfo[] params = op.getSignature();
        if (params == null) {
            return signature == null;
        }
        if (signature == null) {
            return false;
        }
        if (params.length != signature.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            String paramType = params[i].getType();
            if (signature[i] == null) {
                return false;
            }
            if (signature[i].equals(paramType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    public MBeanConstructorInfo[] getMBeanConstructorInfo() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("Constructor", constructors[0])};
        return dConstructors;
    }

    protected void handleGetterException(String attrName, Throwable t) throws MBeanException {
        String tmp = this.getMBeanName() + ": Problem encountered while getting attribute " + attrName + ": " + t.toString();
        this.logger.log(16, tmp, t);
        throw new MBeanException(new Exception(tmp));
    }

    protected void handleSetterException(String attrName, Throwable t) throws MBeanException {
        String tmp = this.getMBeanName() + ": Problem encountered while setting attribute " + attrName + ": " + t.toString();
        this.logger.log(16, tmp, t);
        throw new MBeanException(new Exception(tmp));
    }

    protected void handleOperationException(String opName, Exception e) throws MBeanException {
        String tmp = "MBean " + this.getMBeanName() + ": Problem encountered while invoking operation " + opName + ": " + e.toString();
        this.logger.log(16, tmp);
        throw new MBeanException(new Exception(tmp));
    }

    private void buildDynamicMBeanInfo() {
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.getMBeanDescription(), this.getMBeanAttributeInfo(), this.getMBeanConstructorInfo(), this.getMBeanOperationInfo(), this.getMBeanNotificationInfo());
    }
}

