/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.sun.enterprise.admin.cli.cluster.Constants;
import com.sun.enterprise.admin.cli.cluster.InstallNodeBaseCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.SystemPropertyConstants;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="install-node-ssh")
@PerLookup
public class InstallNodeSshCommand
extends InstallNodeBaseCommand {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    int port;
    @Param(optional=true)
    String sshkeyfile;
    @Inject
    private SSHLauncher sshLauncher;
    private Map<String, char[]> sshPasswords = new HashMap<String, char[]>();

    @Override
    String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return this.port;
    }

    @Override
    String getSshKeyFile() {
        return this.sshkeyfile;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKey(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && SSHUtil.isEncryptedKey((String)this.sshkeyfile)) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    @Override
    void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws CommandException {
        try {
            this.copyToHostsInternal(zipFile, binDirFiles);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (JSchException ex) {
            throw new CommandException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new CommandException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    private void copyToHostsInternal(File zipFile, ArrayList<String> binDirFiles) throws JSchException, IOException, InterruptedException, CommandException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.getSshKeyFile(), this.sshkeypassphrase, logger);
            if (this.getSshKeyFile() != null && !this.sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = null;
                sshpass = this.sshPasswords.containsKey(host) ? String.valueOf(this.sshPasswords.get(host)) : this.getSSHPassword(host);
                this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), sshpass, this.getSshKeyFile(), this.sshkeypassphrase, logger);
                prompt = false;
            }
            String sshInstallDir = this.getInstallDir().replace('\\', '/');
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            ChannelSftp sftpChannel = sftpClient.getSftpChannel();
            try {
                if (!sftpClient.exists(sshInstallDir)) {
                    sftpClient.mkdirs(sshInstallDir, 493);
                }
            }
            catch (SftpException ioe) {
                logger.info(Strings.get("mkdir.failed", sshInstallDir, host));
                throw new IOException(ioe);
            }
            try {
                List<String> files = this.getListOfInstallFiles(sshInstallDir);
                this.deleteRemoteFiles(sftpClient, files, sshInstallDir, this.getForce());
            }
            catch (SftpException ex) {
                logger.finer("Failed to remove sshInstallDir contents");
                throw new IOException(ex);
            }
            catch (IOException ex) {
                logger.finer("Failed to remove sshInstallDir contents");
                throw new IOException(ex);
            }
            String zip = zipFile.getCanonicalPath();
            try {
                logger.info("Copying " + zip + " (" + zipFile.length() + " bytes) to " + host + ":" + sshInstallDir);
                sftpChannel.cd(sftpChannel.getHome());
                sftpChannel.cd(sshInstallDir);
                sftpChannel.put(zipFile.getAbsolutePath(), zipFile.getName());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Copied " + zip + " to " + host + ":" + sshInstallDir);
                }
            }
            catch (SftpException ex) {
                logger.info(Strings.get("cannot.copy.zip.file", zip, host));
                throw new IOException(ex);
            }
            try {
                logger.info("Installing " + this.getArchiveName() + " into " + host + ":" + sshInstallDir);
                String unzipCommand = "cd '" + sshInstallDir + "'; jar -xvf " + this.getArchiveName();
                int status = this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
                if (status != 0) {
                    logger.info(Strings.get("jar.failed", host, outStream.toString()));
                    throw new CommandException("Remote command output: " + outStream.toString());
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Installed " + this.getArchiveName() + " into " + host + ":" + sshInstallDir);
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("jar.failed", host, outStream.toString()));
                throw new IOException(ioe);
            }
            try {
                logger.info("Removing " + host + ":" + sshInstallDir + "/" + this.getArchiveName());
                sftpChannel.cd(sftpChannel.getHome());
                sftpChannel.rm(sshInstallDir + "/" + this.getArchiveName());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Removed " + host + ":" + sshInstallDir + "/" + this.getArchiveName());
                }
            }
            catch (SftpException ioe) {
                logger.info(Strings.get("remove.glassfish.failed", host, sshInstallDir));
                throw new IOException(ioe);
            }
            sftpClient.close();
            sftpClient = this.sshLauncher.getSFTPClient();
            logger.info("Fixing file permissions of all bin files under " + host + ":" + sshInstallDir);
            try {
                if (binDirFiles.isEmpty()) {
                    this.searchAndFixBinDirectoryFiles(sshInstallDir, sftpClient);
                } else {
                    for (String binDirFile : binDirFiles) {
                        sftpClient.chmod(sshInstallDir + "/" + binDirFile, 493);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Fixed file permissions of all bin files under " + host + ":" + sshInstallDir);
                }
            }
            catch (SftpException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, sshInstallDir));
                throw new IOException(ioe);
            }
            if (Constants.v4) {
                logger.info("Fixing file permissions for nadmin file under " + host + ":" + sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + "/lib");
                try {
                    sftpClient.chmod(sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + "/lib/nadmin", 493);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Fixed file permission for nadmin under " + host + ":" + sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + "/lib/nadmin");
                    }
                }
                catch (SftpException ioe) {
                    logger.info(Strings.get("fix.permissions.failed", host, sshInstallDir));
                    throw new IOException(ioe);
                }
            }
            sftpClient.close();
        }
    }

    private void searchAndFixBinDirectoryFiles(String installDir, SFTPClient sftpClient) throws SftpException {
        for (ChannelSftp.LsEntry directoryEntry : sftpClient.getSftpChannel().ls(installDir)) {
            if (directoryEntry.getFilename().equals(".") || directoryEntry.getFilename().equals("..") || !directoryEntry.getAttrs().isDir()) continue;
            String subDir = installDir + "/" + directoryEntry.getFilename();
            if (directoryEntry.getFilename().equals("bin")) {
                this.fixAllFiles(subDir, sftpClient);
                continue;
            }
            this.searchAndFixBinDirectoryFiles(subDir, sftpClient);
        }
    }

    private void fixAllFiles(String binDir, SFTPClient sftpClient) throws SftpException {
        for (ChannelSftp.LsEntry directoryEntry : sftpClient.getSftpChannel().ls(binDir)) {
            if (directoryEntry.getFilename().equals(".") || directoryEntry.getFilename().equals("..")) continue;
            String fName = binDir + "/" + directoryEntry.getFilename();
            sftpClient.chmod(fName, 493);
        }
    }

    private void checkIfAlreadyInstalled(String host, String sshInstallDir) throws JSchException, CommandException, IOException, InterruptedException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            String asadmin = Constants.v4 ? "/lib/nadmin' version --local --terse" : "/bin/asadmin' version --local --terse";
            String cmd = "'" + sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + asadmin;
            int status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
            if (status == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(host + ":'" + cmd + "' returned [" + outStream.toString() + "]");
                }
                throw new CommandException(Strings.get("install.dir.exists", sshInstallDir));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(host + ":'" + cmd + "' failed [" + outStream.toString() + "]");
            }
        }
        catch (IOException ex) {
            logger.info(Strings.get("glassfish.install.check.failed", host));
            throw new IOException(ex);
        }
    }

    @Override
    final void precopy() throws CommandException {
        if (this.getForce()) {
            return;
        }
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.getSshKeyFile(), this.sshkeypassphrase, logger);
            if (this.getSshKeyFile() != null && !this.sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = this.getSSHPassword(host);
                this.sshPasswords.put(host, sshpass.toCharArray());
                this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), sshpass, this.getSshKeyFile(), this.sshkeypassphrase, logger);
                prompt = false;
            }
            String sshInstallDir = this.getInstallDir().replaceAll("\\\\", "/");
            try {
                SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
                if (sftpClient.exists(sshInstallDir)) {
                    this.checkIfAlreadyInstalled(host, sshInstallDir);
                }
                sftpClient.close();
            }
            catch (SftpException ex) {
                throw new CommandException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
            catch (JSchException ex) {
                throw new CommandException((Throwable)ex);
            }
            catch (InterruptedException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
    }
}

