/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class BrokerPasswdDialog
extends AdminDialog {
    private static final long serialVersionUID = -1827338283083710831L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private JTextField username;
    private JTextField password;

    public BrokerPasswdDialog(Frame parent) {
        super(parent, acr.getString("A1141"), 81);
        this.setHelpId("conndis_broker");
    }

    public BrokerPasswdDialog(Frame parent, int whichButtons) {
        super(parent, acr.getString("A1141"), whichButtons);
        this.setHelpId("conndis_broker");
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        workPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        LabelledComponent[] items = new LabelledComponent[2];
        this.username = new JTextField(20);
        this.username.addActionListener(this);
        items[0] = new LabelledComponent(acr.getString("A1405"), this.username);
        this.password = new JPasswordField(20);
        this.password.addActionListener(this);
        items[1] = new LabelledComponent(acr.getString("A1406"), this.password);
        LabelValuePanel lvp = new LabelValuePanel(items, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        gridbag.setConstraints(lvp, c);
        workPanel.add(lvp);
        return workPanel;
    }

    @Override
    public void doOK() {
        String usernameValue = this.username.getText().trim();
        String passwordValue = this.password.getText().trim();
        BrokerAdminEvent bae = new BrokerAdminEvent(this, 3);
        bae.setUsername(usernameValue);
        bae.setPassword(passwordValue);
        bae.setOKAction(true);
        this.fireAdminEventDispatched(bae);
        this.username.requestFocus();
        if (usernameValue.length() != 0 && passwordValue.length() == 0) {
            this.password.requestFocus();
        }
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.setVisible(false);
    }

    @Override
    public void doClose() {
        this.setVisible(false);
    }

    @Override
    public void doClear() {
        this.username.setText("");
        this.password.setText("");
    }

    public void show(BrokerAdmin ba) {
        this.doClear();
        String usernameValue = ba.getUserName();
        String passwordValue = ba.getPassword();
        this.username.requestFocus();
        if (usernameValue.length() != 0 || passwordValue.length() != 0) {
            if (usernameValue.length() == 0) {
                this.password.setText(passwordValue);
            } else {
                this.username.setText(usernameValue);
                this.password.requestFocus();
            }
        }
        this.setDefaultButton(1);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.username) {
            this.password.requestFocus();
        } else if (ev.getSource() == this.password) {
            this.doOK();
        } else {
            super.actionPerformed(ev);
        }
    }
}

