/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityContextProxy;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.glassfish.security.common.PrincipalImpl;

public class WebPrincipal
extends PrincipalImpl
implements SecurityContextProxy {
    private static final long serialVersionUID = -7855179427171479644L;
    private char[] password;
    private X509Certificate[] certificates;
    private boolean useCertificate;
    private SecurityContext securityContext;
    private Principal customPrincipal;

    public WebPrincipal(Principal principal, SecurityContext context) {
        super(principal.getName());
        if (!(principal instanceof PrincipalImpl)) {
            this.customPrincipal = principal;
        }
        this.useCertificate = false;
        this.securityContext = context;
    }

    public WebPrincipal(String user, char[] pwd, SecurityContext context) {
        super(user);
        this.password = pwd == null ? null : Arrays.copyOf(pwd, pwd.length);
        this.useCertificate = false;
        this.securityContext = context;
    }

    public WebPrincipal(String user, String password, SecurityContext context) {
        this(user, password.toCharArray(), context);
    }

    public WebPrincipal(X509Certificate[] certs, SecurityContext context) {
        super(WebPrincipal.getPrincipalName(context, certs));
        this.certificates = certs;
        this.useCertificate = true;
        this.securityContext = context;
    }

    public char[] getPassword() {
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public boolean isUsingCertificate() {
        return this.useCertificate;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public String getName() {
        if (this.customPrincipal == null) {
            return super.getName();
        }
        return this.customPrincipal.getName();
    }

    public boolean equals(Object another) {
        if (this.customPrincipal == null) {
            return super.equals(another);
        }
        return this.customPrincipal.equals(another);
    }

    public int hashCode() {
        if (this.customPrincipal == null) {
            return super.hashCode();
        }
        return this.customPrincipal.hashCode();
    }

    public String toString() {
        if (this.customPrincipal == null) {
            return super.toString();
        }
        return this.customPrincipal.toString();
    }

    private static String getPrincipalName(SecurityContext securityContext, X509Certificate[] certificates) {
        Principal callerPrincipal = securityContext.getCallerPrincipal();
        if (callerPrincipal != null) {
            return callerPrincipal.getName();
        }
        if (certificates != null && certificates.length > 0) {
            return certificates[0].getSubjectX500Principal().getName();
        }
        return null;
    }
}

