/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.JmsProviderLifecycle;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class JMSConfigListener
implements ConfigListener {
    private JmsService jmsService;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private Servers servers;
    private ActiveJmsResourceAdapter aresourceAdapter;
    private static final Logger _logger = JMSLoggerInfo.getLogger();
    private static StringManager sm = StringManager.getManager(JMSConfigListener.class);

    public void setActiveResourceAdapter(ActiveJmsResourceAdapter aresourceAdapter) {
        this.aresourceAdapter = aresourceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        this.jmsService = (JmsService)this.serverConfig.getExtensionByType(JmsService.class);
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In JMSConfigListener - received config event");
        }
        Domain domain = (Domain)Globals.get(Domain.class);
        String jmsProviderPort = null;
        ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
        Server thisServer = domain.getServerNamed(serverContext.getInstanceName());
        for (int i = 0; i < events.length; ++i) {
            GrizzlyService grizzlyService;
            JmsHost jmsHost;
            PropertyChangeEvent event = events[i];
            String eventName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "In JMSConfigListener " + eventName + oldValue + newValue);
            }
            if (oldValue != null && oldValue.equals(newValue)) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Event " + eventName + " did not change existing value of " + oldValue);
                continue;
            }
            if (event.getSource().toString().indexOf("connectors.jms.config.JmsService") != -1) {
                boolean notifyFlag = true;
                if (oldValue != null && newValue == null && "jms-host".equals(event.getPropertyName())) {
                    jmsHost = (JmsHost)oldValue;
                    String name = "JMS_PROXY_" + jmsHost.getName();
                    ActiveJmsResourceAdapter adapter = (ActiveJmsResourceAdapter)((Object)Globals.get(ActiveJmsResourceAdapter.class));
                    if (adapter.getGrizzlyListeners().contains(name)) {
                        grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                        Set<String> set = adapter.getGrizzlyListeners();
                        synchronized (set) {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "Stopping Grizzly proxy " + name);
                            }
                            grizzlyService.removeNetworkProxy(name);
                            adapter.getGrizzlyListeners().remove(name);
                        }
                        notifyFlag = false;
                    }
                }
                if (notifyFlag) {
                    UnprocessedChangeEvent uchangeEvent = new UnprocessedChangeEvent(event, "restart required");
                    unprocessedEvents.add(uchangeEvent);
                }
            } else if (event.getSource().toString().indexOf("connectors.jms.config.JmsHost") != -1 && oldValue == null && newValue != null && "name".equals(event.getPropertyName())) {
                ActiveJmsResourceAdapter adapter;
                JmsProviderLifecycle lifecycle = (JmsProviderLifecycle)Globals.get(JmsProviderLifecycle.class);
                jmsHost = (JmsHost)event.getSource();
                if ("EMBEDDED".equalsIgnoreCase(this.jmsService.getType()) && !(adapter = (ActiveJmsResourceAdapter)((Object)Globals.get(ActiveJmsResourceAdapter.class))).getDoBind() && Boolean.valueOf(jmsHost.getLazyInit()).booleanValue()) {
                    String host = null;
                    host = jmsHost.getHost() != null && "localhost".equals(jmsHost.getHost()) ? "0.0.0.0" : jmsHost.getHost();
                    try {
                        grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                        DummyNetworkListener dummy = new DummyNetworkListener();
                        dummy.setPort(jmsHost.getPort());
                        dummy.setAddress(host);
                        dummy.setType("proxy");
                        dummy.setProtocol("mq-service");
                        dummy.setTransport("tcp");
                        String name = "JMS_PROXY_" + jmsHost.getName();
                        dummy.setName(name);
                        Set<String> set = adapter.getGrizzlyListeners();
                        synchronized (set) {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "Starting Grizzly proxy " + name + " on port " + jmsHost.getPort());
                            }
                            grizzlyService.createNetworkProxy((NetworkListener)dummy);
                            adapter.getGrizzlyListeners().add(name);
                        }
                        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
                    }
                    catch (Exception e) {
                        LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"AS-JMS-CORE-00016", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
            if ("JMS_PROVIDER_PORT".equals(newValue)) {
                PropertyChangeEvent nextevent = events[i + 1];
                jmsProviderPort = (String)nextevent.getNewValue();
            }
            if (event.getSource() instanceof JmsService && eventName.equals("master-broker")) {
                Server newMBServer;
                String newMB;
                String oldMB = oldValue != null ? oldValue.toString() : null;
                String string = newMB = newValue != null ? newValue.toString() : null;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Got JmsService Master Broker change event " + event.getSource() + " " + eventName + " " + oldMB + " " + newMB);
                }
                if (newMB != null && (newMBServer = domain.getServerNamed(newMB)) != null) {
                    Node node = domain.getNodeNamed(newMBServer.getNodeRef());
                    String newMasterBrokerPort = JmsRaUtil.getJMSPropertyValue(newMBServer);
                    if (newMasterBrokerPort == null) {
                        newMasterBrokerPort = this.getDefaultJmsHost(this.jmsService).getPort();
                    }
                    String newMasterBrokerHost = node.getNodeHost();
                    this.aresourceAdapter.setMasterBroker(newMasterBrokerHost + ":" + newMasterBrokerPort);
                }
            }
            if (eventName.equals("server-ref")) {
                String newServerRef;
                String oldServerRef = oldValue != null ? oldValue.toString() : null;
                String string = newServerRef = newValue != null ? newValue.toString() : null;
                if (oldServerRef != null && newServerRef == null && !thisServer.isDas()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Got Cluster change event for server_ref" + event.getSource() + " " + eventName + " " + oldServerRef + " null");
                    }
                    String url = this.getBrokerList();
                    this.aresourceAdapter.setClusterBrokerList(url);
                    break;
                }
            }
            if (!(event.getSource() instanceof Server)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "In JMSConfigListener - recieved cluster event " + event.getSource());
            }
            Server changedServer = (Server)event.getSource();
            if (thisServer.isDas()) {
                return null;
            }
            if (jmsProviderPort == null) continue;
            String nodeName = changedServer.getNodeRef();
            String nodeHost = null;
            if (nodeName != null) {
                nodeHost = domain.getNodeNamed(nodeName).getNodeHost();
            }
            Object url = this.getBrokerList();
            url = (String)url + ",mq://" + nodeHost + ":" + jmsProviderPort;
            this.aresourceAdapter.setClusterBrokerList((String)url);
            break;
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }

    private String getBrokerList() {
        MQAddressList addressList = new MQAddressList();
        try {
            addressList.setup(true);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "AS-JMS-CORE-00017", new Object[]{ex.getLocalizedMessage()});
            ex.printStackTrace();
        }
        return addressList.toString();
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost jmsHost = null;
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        List<JmsHost> jmsHostsList = jmsService.getJmsHost();
        for (int i = 0; i < jmsHostsList.size(); ++i) {
            JmsHost tmpJmsHost = jmsHostsList.get(i);
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHostName)) continue;
            jmsHost = tmpJmsHost;
        }
        if (jmsHost == null && jmsHostsList.size() > 0) {
            jmsHost = jmsHostsList.get(0);
        }
        return jmsHost;
    }
}

