/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.runtime.InvokableAnnotatedMethod;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public class Decorators {
    private Decorators() {
    }

    public static Set<InvokableAnnotatedMethod<?>> getDecoratorMethods(BeanManagerImpl beanManager, WeldDecorator<?> decorator) {
        ImmutableSet.Builder<InvokableAnnotatedMethod<?>> builder = ImmutableSet.builder();
        for (Type type : decorator.getDecoratedTypes()) {
            EnhancedAnnotatedType<?> weldClass = Decorators.getEnhancedAnnotatedTypeOfDecoratedType(beanManager, type);
            for (EnhancedAnnotatedMethod<?, ?> method : weldClass.getDeclaredEnhancedMethods()) {
                if (decorator.getEnhancedAnnotated().getEnhancedMethod(method.getSignature()) == null) continue;
                builder.add(InvokableAnnotatedMethod.of(method.slim()));
            }
        }
        return builder.build();
    }

    private static EnhancedAnnotatedType<?> getEnhancedAnnotatedTypeOfDecoratedType(BeanManagerImpl beanManager, Type type) {
        if (type instanceof Class) {
            return beanManager.createEnhancedAnnotatedType((Class)type);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return beanManager.createEnhancedAnnotatedType((Class)((ParameterizedType)type).getRawType());
        }
        throw BeanLogger.LOG.unableToProcessDecoratedType(type);
    }

    public static WeldInjectionPointAttributes<?, ?> findDelegateInjectionPoint(AnnotatedType<?> type, Iterable<InjectionPoint> injectionPoints) {
        WeldInjectionPointAttributes result = null;
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (!injectionPoint.isDelegate()) continue;
            if (result != null) {
                throw BeanLogger.LOG.tooManyDelegateInjectionPoints(type);
            }
            result = InjectionPoints.getWeldInjectionPoint(injectionPoint);
        }
        if (result == null) {
            throw BeanLogger.LOG.noDelegateInjectionPoint(type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getOuterDelegate(Bean<T> bean, T instance, CreationalContext<T> creationalContext, Class<T> proxyClass, InjectionPoint originalInjectionPoint, BeanManagerImpl manager, List<Decorator<?>> decorators) {
        TargetBeanInstance beanInstance = new TargetBeanInstance(bean, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, bean, proxyClass, manager, manager.getServices().get(ContextualStore.class), decorators);
        DecorationHelper.push(decorationHelper);
        try {
            T outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
            if (outerDelegate == null) {
                throw new WeldException(BeanLogger.LOG.proxyInstantiationFailed(bean));
            }
            T t = outerDelegate;
            return t;
        }
        finally {
            DecorationHelper.pop();
        }
    }

    public static void checkDelegateType(Decorator<?> decorator) {
        Set<Type> types = new HierarchyDiscovery(decorator.getDelegateType()).getTypeClosure();
        for (Type decoratedType : decorator.getDecoratedTypes()) {
            if (types.contains(decoratedType)) continue;
            throw BeanLogger.LOG.delegateMustSupportEveryDecoratedType(decoratedType, decorator);
        }
    }

    public static <T> void checkAbstractMethods(Set<Type> decoratedTypes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        if (decoratedTypes == null) {
            decoratedTypes = new HashSet<Type>(type.getInterfaceClosure());
            decoratedTypes.remove(Serializable.class);
        }
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        for (Type type2 : decoratedTypes) {
            for (EnhancedAnnotatedMethod method : ClassTransformer.instance(beanManager).getEnhancedAnnotatedType(Reflections.getRawType(type2), beanManager.getId()).getEnhancedMethods()) {
                signatures.add(method.getSignature());
            }
        }
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : type.getEnhancedMethods()) {
            MethodSignature methodSignature;
            if (!Reflections.isAbstract(enhancedAnnotatedMethod.getJavaMember()) || signatures.contains(methodSignature = enhancedAnnotatedMethod.getSignature())) continue;
            throw BeanLogger.LOG.abstractMethodMustMatchDecoratedType(enhancedAnnotatedMethod, Formats.formatAsStackTraceElement(enhancedAnnotatedMethod.getJavaMember()));
        }
    }

    public static boolean isPassivationCapable(Decorator<?> decorator) {
        if (decorator instanceof CustomDecoratorWrapper) {
            decorator = ((CustomDecoratorWrapper)Reflections.cast(decorator)).delegate();
        }
        if (decorator instanceof DecoratorImpl) {
            DecoratorImpl weldDecorator = (DecoratorImpl)decorator;
            return weldDecorator.getEnhancedAnnotated().isSerializable();
        }
        return decorator instanceof PassivationCapable;
    }
}

