/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.CompleteEstablishContext;
import com.sun.corba.ee.org.omg.CSI.ContextError;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.Counter;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityContextUtil;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SecServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private InheritableThreadLocal counterForCalls = new InheritableThreadLocal();
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_MECHANISM_MAJOR = 2;
    private static final int INVALID_MECHANISM_MINOR = 1;
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static final boolean NO_REPLACE = false;
    private String prname;
    private String name;
    private Codec codec;
    private SecurityContextUtil secContextUtil = null;
    private GlassFishORBHelper orbHelper;
    private SecurityMechanismSelector smSelector = null;

    public SecServerRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
        this.secContextUtil = Lookups.getSecurityContextUtil();
        this.orbHelper = Lookups.getGlassFishORBHelper();
        this.smSelector = Lookups.getSecurityMechanismSelector();
    }

    public String name() {
        return this.name;
    }

    private SASContextBody createContextError(int status) {
        return this.createContextError(1, status);
    }

    private SASContextBody createContextError(int major, int minor) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating ContextError message: major code = " + major + "minor code= " + minor);
        }
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, major, minor, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext(int status) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating CompleteEstablishContext message");
        }
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext cec = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(cec);
        return sasctxtbody;
    }

    private ServiceContext createSvcContext(SASContextBody sasctxtbody, ORB orb) {
        ServiceContext sc = null;
        Any a = orb.create_any();
        SASContextBodyHelper.insert((Any)a, (SASContextBody)sasctxtbody);
        byte[] cdr_encoded_saselm = new byte[]{};
        try {
            cdr_encoded_saselm = this.codec.encode_value(a);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", e);
        }
        sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        return sc;
    }

    private void createIdCred(SecurityContext sc, IdentityToken idtok) throws Exception {
        switch (idtok.discriminator()) {
            case 0: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity token type is Absent");
                }
                sc.identcls = null;
                break;
            }
            case 1: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity token type is Anonymous");
                    _logger.log(Level.FINE, "Adding AnonyCredential to subject's PublicCredentials");
                }
                sc.subject.getPublicCredentials().add(new AnonCredential());
                sc.identcls = AnonCredential.class;
                break;
            }
            case 8: {
                byte[] derenc = idtok.dn();
                if (this.isCDR(derenc)) {
                    Any any = this.codec.decode_value(derenc, X501DistinguishedNameHelper.type());
                    derenc = X501DistinguishedNameHelper.extract((Any)any);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Create an X500Principal object from identity token");
                }
                X500Principal xname = new X500Principal(derenc);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity to be asserted is " + xname.toString());
                    _logger.log(Level.FINE, "Adding X500Principal to subject's PublicCredentials");
                }
                sc.subject.getPublicCredentials().add(xname);
                sc.identcls = X500Principal.class;
                break;
            }
            case 4: {
                byte[] derenc;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity token type is a X509 Certificate Chain");
                }
                if (this.isCDR(derenc = idtok.certificate_chain())) {
                    Any any = this.codec.decode_value(derenc, X509CertificateChainHelper.type());
                    derenc = X509CertificateChainHelper.extract((Any)any);
                }
                List<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertPath(new ByteArrayInputStream(derenc)).getCertificates();
                X509Certificate[] certchain = new X509Certificate[certificates.size()];
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Contents of X509 Certificate chain:");
                }
                for (int i = 0; i < certchain.length; ++i) {
                    certchain[i] = (X509Certificate)certificates.get(i);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "    " + certchain[i].getSubjectX500Principal().getName());
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Creating a X509CertificateCredential object from certchain");
                }
                X509CertificateCredential cred = new X509CertificateCredential(certchain, certchain[0].getSubjectX500Principal().getName(), "default");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Adding X509CertificateCredential to subject's PublicCredentials");
                }
                sc.subject.getPublicCredentials().add(cred);
                sc.identcls = X509CertificateCredential.class;
                break;
            }
            case 2: {
                byte[] expname;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Identity token type is GSS Exported Name");
                }
                if (this.isCDR(expname = idtok.principal_name())) {
                    Any any = this.codec.decode_value(expname, GSS_NT_ExportedNameHelper.type());
                    expname = GSS_NT_ExportedNameHelper.extract((Any)any);
                }
                if (!GSSUtils.verifyMechOID(GSSUtils.GSSUP_MECH_OID, expname)) {
                    throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
                }
                GSSUPName gssname = new GSSUPName(expname);
                sc.subject.getPublicCredentials().add(gssname);
                sc.identcls = GSSUPName.class;
                _logger.log(Level.FINE, "Adding GSSUPName credential to subject");
                break;
            }
            default: {
                _logger.log(Level.SEVERE, "iiop.unknown_identity");
                throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
            }
        }
    }

    private boolean isCDR(byte[] bytes) {
        return bytes != null && bytes.length > 0 && (bytes[0] == 0 || bytes[0] == 1);
    }

    private void createAuthCred(SecurityContext sc, byte[] authtok, ORB orb) throws Exception {
        _logger.log(Level.FINE, "Constructing a PasswordCredential from client authentication token");
        GSSUPToken tok = GSSUPToken.getServerSideInstance(orb, this.codec, authtok);
        final PasswordCredential pwdcred = tok.getPwdcred();
        final SecurityContext fsc = sc;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Password credential = " + pwdcred.toString());
            _logger.log(Level.FINE, "Adding PasswordCredential to subject's PrivateCredentials");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fsc.subject.getPrivateCredentials().add(pwdcred);
                return null;
            }
        });
        sc = fsc;
        sc.authcls = PasswordCredential.class;
    }

    private void handle_null_service_context(ServerRequestInfo ri, ORB orb) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "No SAS context element found in service context list for operation: " + ri.operation());
        }
        ServiceContext sc = null;
        int secStatus = this.secContextUtil.setSecurityContext(null, ri.object_id(), ri.operation(), this.getServerSocket());
        if (secStatus == 1) {
            SASContextBody sasctxbody = this.createContextError(2, 1);
            sc = this.createSvcContext(sasctxbody, orb);
            ri.add_reply_service_context(sc, false);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SecServerRequestInterceptor.receive_request: NO_PERMISSION");
            }
            throw new NO_PERMISSION();
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        Any SasAny;
        SecurityContext seccontext = null;
        ServiceContext sc = null;
        int status = 0;
        boolean raise_no_perm = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_request");
        }
        ORB orb = this.orbHelper.getORB();
        try {
            sc = ri.get_request_service_context(15);
            if (sc == null) {
                this.handle_null_service_context(ri, orb);
                return;
            }
        }
        catch (BAD_PARAM e) {
            this.handle_null_service_context(ri, orb);
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Received a non null SAS context element");
        }
        try {
            SasAny = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", e);
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Successfully decoded CDR encoded SAS context element.");
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)SasAny);
        short sasdiscr = sasctxbody.discriminator();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SAS context element is a/an " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        }
        if (sasdiscr == 5) {
            sasctxbody = this.createContextError(4);
            sc = this.createSvcContext(sasctxbody, orb);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Adding ContextError message to service context list");
                _logger.log(Level.FINE, "SecurityContext set to null");
            }
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        if (sasdiscr != 0) {
            _logger.log(Level.SEVERE, "iiop.not_establishcontext_msg");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_not_ec_msg", "Received message not an EstablishContext message."));
        }
        EstablishContext ec = sasctxbody.establish_msg();
        seccontext = new SecurityContext();
        seccontext.subject = new Subject();
        try {
            if (ec.client_authentication_token.length != 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Message contains Client Authentication Token");
                }
                this.createAuthCred(seccontext, ec.client_authentication_token, orb);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.authentication_exception", e);
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        try {
            if (ec.identity_token != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Message contains an Identity Token");
                }
                this.createIdCred(seccontext, ec.identity_token);
            }
        }
        catch (SecurityException secex) {
            _logger.log(Level.SEVERE, "iiop.security_exception", secex);
            sasctxbody = this.createContextError(2, 1);
            sc = this.createSvcContext(sasctxbody, orb);
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.generic_exception", e);
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Invoking setSecurityContext() to set security context");
        }
        status = this.secContextUtil.setSecurityContext(seccontext, ri.object_id(), ri.operation(), this.getServerSocket());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setSecurityContext() returned status code " + status);
        }
        if (status == 1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "setSecurityContext() returned STATUS_FAILED");
            }
            sasctxbody = this.createContextError(status);
            sc = this.createSvcContext(sasctxbody, orb);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Adding ContextError message to service context list");
            }
            ri.add_reply_service_context(sc, false);
            throw new NO_PERMISSION();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setSecurityContext() returned SUCCESS");
        }
        sasctxbody = this.createCompleteEstablishContext(status);
        sc = this.createSvcContext(sasctxbody, orb);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Adding CompleteEstablisContext message to service context list");
        }
        ri.add_reply_service_context(sc, false);
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        Counter cntr = (Counter)this.counterForCalls.get();
        if (cntr == null) {
            cntr = new Counter();
            this.counterForCalls.set(cntr);
        }
        if (cntr.count == 0) {
            SecurityContextUtil.unsetSecurityContext(this.isLocal());
        }
        cntr.increment();
        Socket s = null;
        Connection c = null;
        if (ri instanceof RequestInfoExt) {
            c = ((RequestInfoExt)ri).connection();
        }
        ServerConnectionContext scc = null;
        if (c != null) {
            s = c.getSocket();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "RECEIVED request on connection: " + c);
                _logger.log(Level.FINE, "Socket =" + s);
            }
            scc = new ServerConnectionContext(s);
        } else {
            scc = new ServerConnectionContext();
        }
        SecServerRequestInterceptor.setServerConnectionContext(scc);
    }

    public void send_reply(ServerRequestInfo ri) {
        this.unsetSecurityContext();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void destroy() {
    }

    private void unsetSecurityContext() {
        try {
            Counter cntr = (Counter)this.counterForCalls.get();
            if (cntr == null) {
                cntr = new Counter(1);
            }
            cntr.decrement();
            if (cntr.count == 0) {
                SecurityContextUtil.unsetSecurityContext(this.isLocal());
            }
        }
        finally {
            ConnectionExecutionContext.removeClientThreadID();
        }
    }

    private boolean isLocal() {
        Long clientID;
        boolean local = true;
        ServerConnectionContext scc = this.getServerConnectionContext();
        if (scc != null && scc.getSocket() != null) {
            local = false;
        }
        if ((clientID = ConnectionExecutionContext.readClientThreadID()) != null && clientID.longValue() == Thread.currentThread().getId()) {
            local = true;
        }
        return local;
    }

    private Socket getServerSocket() {
        ServerConnectionContext scc = this.getServerConnectionContext();
        if (scc != null) {
            return scc.getSocket();
        }
        return null;
    }

    private ServerConnectionContext getServerConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    static {
        _logger = LogDomains.getLogger(SecServerRequestInterceptor.class, (String)"javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
    }
}

