/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.rest.client.utils.Util;

public class RestResponse {
    private String message;
    private int status;
    private Map<String, Object> extraProperties;
    private List children;
    private Map<String, String> properties;

    public RestResponse(Response response) {
        Map<String, Object> responseMap = Util.processJsonMap((String)response.readEntity(String.class));
        this.status = response.getStatus();
        this.message = (String)responseMap.get("message");
        this.extraProperties = (Map)responseMap.get("extraProperties");
        this.children = (List)responseMap.get("children");
        Map respProps = (Map)responseMap.get("properties");
        if (respProps != null) {
            this.properties = respProps;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return this.status >= 200 && this.status <= 299;
    }

    public Map<String, Object> getExtraProperties() {
        return Collections.unmodifiableMap(this.extraProperties);
    }

    public List getChildren() {
        return this.children;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

