/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.ManagedConnection;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.Serializable;
import java.util.logging.Logger;

public class ConnectionManager
implements Serializable,
jakarta.resource.spi.ConnectionManager,
ConnectionEventListener {
    private static final transient String _className = "com.sun.messaging.jms.ra.ConnectionManager";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_CM";
    protected static final transient String _lgrMID_EET = "MQJMSRA_CM1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_CM1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_CM2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_CM3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_CM4001: ";

    public ConnectionManager() {
        _loggerOC.entering(_className, "constructor()");
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Object[] params = new Object[]{mcf, cxRequestInfo};
        _loggerOC.entering(_className, "allocateConnection()", params);
        jakarta.resource.spi.ManagedConnection mc = null;
        mc = mcf.createManagedConnection(null, cxRequestInfo);
        mc.addConnectionEventListener((ConnectionEventListener)this);
        return mc.getConnection(null, cxRequestInfo);
    }

    public void connectionClosed(ConnectionEvent event) {
        _loggerOC.entering(_className, "connectionClosed()", event);
        if (event != null) {
            ManagedConnection mc = (ManagedConnection)event.getSource();
            try {
                _loggerOC.fine("MQJMSRA_CM1101: connectionClosed:event=" + event + ":cleanup&destroy mc=" + mc.toString());
                mc.cleanup();
                mc.destroy();
            }
            catch (Exception re) {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:Exception on cleanup&destroy:" + re.getMessage() + ":event=" + event + ":mc=" + mc.toString());
                re.printStackTrace();
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        _loggerOC.entering(_className, "connectionErrorOccurred()", event);
        if (event != null) {
            ManagedConnection mc = (ManagedConnection)event.getSource();
            try {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:event=" + event + ":Destroying mc=" + mc.toString());
                mc.destroy();
            }
            catch (Exception re) {
                _loggerOC.warning("MQJMSRA_CM2001: connectionErrorOccurred:Exception on destroy():" + re.getMessage() + ":event=" + event + ":mc=" + mc.toString());
                re.printStackTrace();
            }
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        _loggerOC.entering(_className, "localTransactionCommitted()", event);
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        _loggerOC.entering(_className, "localTransactionRolledback()", event);
    }

    public void localTransactionStarted(ConnectionEvent event) {
        _loggerOC.entering(_className, "localTransactionStarted()", event);
    }
}

