/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ContextableConnection;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAQueueSessionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsclient.XATopicSessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.MQInvalidClientIDRuntimeException;
import com.sun.messaging.jms.MQRuntimeException;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.SessionAdapter;
import com.sun.messaging.jms.ra.api.JMSRAConnectionAdapter;
import com.sun.messaging.jms.ra.api.JMSRASessionAdapter;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.resource.ResourceException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class ConnectionAdapter
implements Connection,
QueueConnection,
TopicConnection,
JMSRAConnectionAdapter,
ContextableConnection {
    private ResourceAdapter ra = null;
    private ManagedConnection mc = null;
    public XAConnectionImpl xac = null;
    private SessionAdapter sa = null;
    private boolean sessions_allowed = true;
    private Set<SessionAdapter> sessions = null;
    private boolean destroyed = false;
    private boolean closed = false;
    private boolean inACC = true;
    private static final transient String _className = "com.sun.messaging.jms.ra.ConnectionAdapter";
    protected static final transient String _lgrNameJMSConnection = "jakarta.jms.Connection.mqjmsra";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJC = Logger.getLogger("jakarta.jms.Connection.mqjmsra");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_CA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_CA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_CA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_CA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_CA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_CA4001: ";

    public ConnectionAdapter(ManagedConnection mc, XAConnectionImpl xac, ResourceAdapter ra) throws ResourceException {
        Object[] params = new Object[]{mc, xac, ra};
        _loggerOC.entering(_className, "constructor()", params);
        this.mc = mc;
        this.xac = xac;
        this.ra = ra;
        this.sessions = new HashSet<SessionAdapter>();
        if (ra != null) {
            this.inACC = ra.getInAppClientContainer();
            if (ra.getInClusteredContainer() && this.getManagedConnection().getManagedConnectionFactory().isUseSharedSubscriptionInClusteredContainer()) {
                xac.setRANamespaceUID(ra._getRAUID());
            }
        }
    }

    public void setClientID(String clientId) throws jakarta.jms.JMSException {
        _loggerJC.entering(_className, "setClientID()", clientId);
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-setClientID()");
        }
        this.checkClosed();
        this.xac.setClientID(clientId);
    }

    @Override
    public void _setClientIDForContext(String clientID) {
        _loggerJC.entering(_className, "_setClientIDForContext()", clientID);
        this.checkClosed2();
        try {
            this.xac._setClientID(clientID);
        }
        catch (InvalidClientIDException ice) {
            throw new MQInvalidClientIDRuntimeException(ice);
        }
        catch (jakarta.jms.JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public String getClientID() throws jakarta.jms.JMSException {
        _loggerJC.entering(_className, "getClientID()");
        this.checkClosed();
        return this.xac.getClientID();
    }

    public void setExceptionListener(ExceptionListener listener) throws jakarta.jms.JMSException {
        _loggerJC.entering(_className, "setExceptionListener()", listener);
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-setExceptionListener()");
        }
        this.checkClosed();
        this.xac.setExceptionListener(listener);
    }

    public ExceptionListener getExceptionListener() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.xac.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.xac.getMetaData();
    }

    public void start() throws jakarta.jms.JMSException {
        this.checkClosed();
        this.xac.start();
    }

    public void stop() throws jakarta.jms.JMSException {
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-stop()");
        }
        this.checkClosed();
        this.xac.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws jakarta.jms.JMSException {
        _loggerOC.fine("MQJMSRA_CA1101: close():xacId=" + this.xac._getConnectionID() + ":clientId=" + this.xac.getClientID());
        ConnectionAdapter connectionAdapter = this;
        synchronized (connectionAdapter) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.xac._isClosed()) {
                this.xac.stop();
            }
            Set<SessionAdapter> set = this.sessions;
            synchronized (set) {
                Iterator<SessionAdapter> it = this.sessions.iterator();
                while (it.hasNext()) {
                    SessionAdapter sa = it.next();
                    if (sa == null) continue;
                    sa.close(true);
                    it.remove();
                }
                this.sessions.clear();
                this.sessions_allowed = true;
                this.sa = null;
            }
            try {
                if (!this.getManagedConnection().xaTransactionActive()) {
                    _loggerOC.fine("MQJMSRA_CA1101: close():xacId=" + this.xac._getConnectionID() + ":unsetting clientId");
                    this.xac._closeForPooling();
                }
            }
            catch (jakarta.jms.JMSException jmse) {
                System.err.println("MQRA:CA:close:Got JMSExc during _closeForPooling:ignoring:" + jmse.getMessage());
                jmse.printStackTrace();
            }
            this.mc.sendEvent(1, null, this);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", code, uoex);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", code, uoex);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", code, uoex);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createDurableConnectionConsumer", code, uoex);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createSharedConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createSharedConnectionConsumer", code, uoex);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws jakarta.jms.JMSException {
        UnsupportedOperationException uoex = new UnsupportedOperationException("createSharedDurableConnectionConsumer");
        String code = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createSharedDurableConnectionConsumer", code, uoex);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = true;
            }
        }
        catch (Exception ee) {
            this.sessions_allowed = true;
        }
        XASessionImpl xas = ResourceAdapter._isFixCR6760301() ? (XASessionImpl)this.xac.createSession(this.overrideTransacted(transacted), this.overrideAcknowledgeMode(acknowledgeMode), this.inACC ? null : this.mc) : (XASessionImpl)this.xac.createSession(this.mc.xaTransactionStarted() ? true : transacted, acknowledgeMode, this.inACC ? null : this.mc);
        SessionAdapter sess_adapter = new SessionAdapter(this, this.xac, xas);
        this.addSessionAdapter(sess_adapter);
        return sess_adapter;
    }

    public Session createSession(int sessionMode) throws jakarta.jms.JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, sessionMode);
        }
        return this.createSession(false, sessionMode);
    }

    public Session createSession() throws jakarta.jms.JMSException {
        return this.createSession(false, 1);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createQueueSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = true;
            }
        }
        catch (Exception ee) {
            this.sessions_allowed = true;
        }
        XAQueueSessionImpl xas = ResourceAdapter._isFixCR6760301() ? (XAQueueSessionImpl)this.xac.createQueueSession(this.overrideTransacted(transacted), this.overrideAcknowledgeMode(acknowledgeMode), this.inACC ? null : this.mc) : (XAQueueSessionImpl)this.xac.createQueueSession(this.mc.xaTransactionStarted() ? true : transacted, acknowledgeMode, this.inACC ? null : this.mc);
        SessionAdapter sess_adapter = new SessionAdapter(this, this.xac, xas);
        sess_adapter.setQueueSession();
        this.addSessionAdapter(sess_adapter);
        return sess_adapter;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createTopicSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = true;
            }
        }
        catch (Exception ee) {
            this.sessions_allowed = true;
        }
        XATopicSessionImpl xas = ResourceAdapter._isFixCR6760301() ? (XATopicSessionImpl)this.xac.createTopicSession(this.overrideTransacted(transacted), this.overrideAcknowledgeMode(acknowledgeMode), this.inACC ? null : this.mc) : (XATopicSessionImpl)this.xac.createTopicSession(this.mc.xaTransactionStarted() ? true : transacted, acknowledgeMode, this.inACC ? null : this.mc);
        SessionAdapter sess_adapter = new SessionAdapter(this, this.xac, xas);
        sess_adapter.setTopicSession();
        this.addSessionAdapter(sess_adapter);
        return sess_adapter;
    }

    private boolean overrideTransacted(boolean suppliedTransactedArgument) {
        if (this.mc.xaTransactionStarted()) {
            return true;
        }
        boolean actualTransactedArg = this.inACC ? suppliedTransactedArgument : false;
        return actualTransactedArg;
    }

    private int overrideAcknowledgeMode(int suppliedAcknowledgeModeArgument) {
        int actualAcknowledgeModeArg = this.inACC ? suppliedAcknowledgeModeArgument : (suppliedAcknowledgeModeArgument == 2 ? 1 : suppliedAcknowledgeModeArgument);
        return actualAcknowledgeModeArg;
    }

    void checkClosed() throws jakarta.jms.JMSException {
        if (this.closed) {
            throw new IllegalStateException("MQRA:CA:Illegal:Connection is closed");
        }
    }

    void checkClosed2() {
        if (this.closed) {
            throw new IllegalStateRuntimeException("MQRA:CA:Illegal:Connection is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSessionAdapter(SessionAdapter sa) {
        Set<SessionAdapter> set = this.sessions;
        synchronized (set) {
            this.sessions.add(sa);
            if (this.sa == null) {
                this.sa = sa;
            }
            if (!this.inACC) {
                this.sessions_allowed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSessionAdapter(SessionAdapter sa) {
        Set<SessionAdapter> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(sa);
            if (!this.sessions_allowed && this.sessions.isEmpty()) {
                this.sessions_allowed = true;
                this.sa = null;
            }
        }
    }

    public void associateManagedConnection(ManagedConnection newmc) throws ResourceException {
        if (this.destroyed) {
            System.err.println("MQRA:CA:associateMC:cnxn is destroyed. DebugState=" + this.xac.getDebugState(false).toString());
            throw new jakarta.resource.spi.IllegalStateException("MQRA:CA:unable to associate ManagedConnection - Connection is destoryed");
        }
        if (newmc != null) {
            this.mc = newmc;
        }
    }

    public void destroy() {
        try {
            this.xac.close();
        }
        catch (jakarta.jms.JMSException jmse) {
            System.err.println("MQRA:CA:destroy:Exception on phys cnxn close-ignoring:" + jmse.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set<SessionAdapter> set = this.sessions;
        synchronized (set) {
            for (SessionAdapter sa : this.sessions) {
                if (sa == null) continue;
                sa.closeAdapter();
            }
            this.sessions.clear();
            this.sessions_allowed = true;
            this.sa = null;
        }
    }

    protected ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public SessionAdapter getSessionAdapter() {
        return this.sa;
    }

    @Override
    public JMSRASessionAdapter getJMSRASessionAdapter() {
        return this.sa;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String clientId) throws jakarta.jms.JMSException {
        ConnectionAdapter connectionAdapter = this;
        synchronized (connectionAdapter) {
            this.xac._setClientID(clientId);
            this.closed = false;
        }
    }

    public void open() {
        this.closed = false;
    }

    @Override
    public void closeForPoolingIfClosed() throws jakarta.jms.JMSException {
        if (this.closed) {
            this.xac._closeForPooling();
        }
    }
}

