/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.module.bootstrap.StartupContext;
import jakarta.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ACCStartupContext
extends StartupContext {
    private static final String DERBY_ROOT_PROPERTY = "AS_DERBY_INSTALL";

    public ACCStartupContext() {
        super(ACCStartupContext.accEnvironment());
    }

    private static Properties accEnvironment() {
        Properties result = MainHelper.parseAsEnv((File)ACCStartupContext.getRootDirectory());
        result.setProperty("com.sun.aas.installRoot", ACCStartupContext.getRootDirectory().getAbsolutePath());
        File javadbDir = new File(ACCStartupContext.getRootDirectory().getParentFile(), "javadb");
        if (javadbDir.isDirectory()) {
            result.setProperty(DERBY_ROOT_PROPERTY, javadbDir.getAbsolutePath());
        }
        return result;
    }

    private static File getRootDirectory() {
        URI jarURI = null;
        try {
            jarURI = ACCClassLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (jarURI.getScheme().startsWith("http")) {
            return new File(System.getProperty("user.home"));
        }
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        return dirFile;
    }
}

