/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.util.Map;

public final class ButtonRenderer
extends RendererBase {
    private static final String[] ATTRIBUTES = new String[]{"alt", "align", "dir", "lang", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "style", "tabIndex"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Button button = (Button)component;
        if (button.isReset()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId) || map.containsKey(clientId + ".x") && map.containsKey(clientId + ".y")) {
            button.queueEvent((FacesEvent)new ActionEvent((UIComponent)button));
        }
    }

    @Override
    protected String[] getModuleNames(UIComponent component) {
        return new String[]{"button"};
    }

    @Override
    protected JsonObjectBuilder getProperties(FacesContext context, UIComponent component) throws IOException {
        Button button = (Button)component;
        JsonObjectBuilder jsonBuilder = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("className", button.getStyleClass()).add("disabled", button.isDisabled()).add("mini", button.isMini()).add("name", button.getClientId(context)).add("primary", button.isPrimary()).add("title", button.getToolTip()).add("visible", button.isVisible());
        if (button.isReset()) {
            jsonBuilder.add("type", "reset");
        } else {
            jsonBuilder.add("type", "submit");
        }
        String text = ConversionUtilities.convertValueToString((UIComponent)button, button.getText());
        if (text != null && text.trim().length() > 0) {
            if (!button.isNoTextPadding()) {
                if (text.trim().length() <= 3) {
                    text = "  " + text + "  ";
                } else if (text.trim().length() == 4) {
                    text = " " + text + " ";
                }
            }
            jsonBuilder.add("contents", text);
        }
        ButtonRenderer.addAttributeProperties(ATTRIBUTES, component, jsonBuilder);
        return jsonBuilder;
    }

    @Override
    protected void renderNestedContent(FacesContext context, UIComponent component) throws IOException {
    }
}

