/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.util;

import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ExprEval {
    private static final System.Logger logger = System.getLogger(ExprEval.class.getName());

    private ExprEval() {
    }

    public static String buildElExpr(boolean deferred, String operation) {
        Object sandwich = null;
        sandwich = operation == null ? "{A}" : ("unary_minus".equals(operation) ? "{-A}" : ("unary_not".equals(operation) ? "{not A}" : ("unary_bang".equals(operation) ? "{! A}" : ("empty".equals(operation) ? "{empty A}" : ("conditional".equals(operation) ? "{A ?B: C}" : ("null_coalescing".equals(operation) ? "{A ??B}" : ("elvis".equals(operation) ? "{A ?:B}" : "{A " + operation + " B}")))))));
        return deferred ? "#" + (String)sandwich : "$" + (String)sandwich;
    }

    public static Object evaluateValueExpression(String exprStr, NameValuePair[] nameVals, Class<?> expectedClass, ResolverType resolverType) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(resolverType).getELContext();
        ELResolver resolver = context.getELResolver();
        ExprEval.cleanup();
        if (nameVals == null) {
            resolver.setValue(context, null, (Object)"A", null);
            logger.log(System.Logger.Level.TRACE, "setting var 'A' to value null");
            resolver.setValue(context, null, (Object)"B", null);
            logger.log(System.Logger.Level.TRACE, "setting var 'B' to value null");
        } else {
            for (int i = 0; i < nameVals.length; ++i) {
                String name = nameVals[i].getName();
                Object val = nameVals[i].getValue();
                logger.log(System.Logger.Level.TRACE, "setting var " + name + " to value " + String.valueOf(val));
                resolver.setValue(context, null, (Object)name, val);
            }
        }
        logger.log(System.Logger.Level.TRACE, "Creating ValueExpression");
        logger.log(System.Logger.Level.TRACE, "context is " + context.getClass().toString());
        logger.log(System.Logger.Level.TRACE, "exprStr is " + exprStr);
        logger.log(System.Logger.Level.TRACE, "expectedClass is " + expectedClass.toString());
        logger.log(System.Logger.Level.TRACE, "resolver is " + context.getELResolver().getClass().toString());
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        return vexp.getValue(context);
    }

    public static Object evaluateValueExpression(String exprStr, NameValuePair[] nameVals, Class<?> expectedClass) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        return ExprEval.evaluateValueExpression(exprStr, nameVals, expectedClass, ResolverType.VARIABLE_ELRESOLVER);
    }

    public static Object evaluateMethodExpression(String exprStr, Class<?>[] params, Class<?> expectedClass, ResolverType resolverType) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(resolverType).getELContext();
        MethodExpression mexp = expFactory.createMethodExpression(context, exprStr, expectedClass, (Class[])params);
        return mexp.invoke(context, (Object[])params);
    }

    public static Object evaluateCoerceValueExpression(String exprStr, Object exprVal, Class<?> expectedClass) throws ELException, PropertyNotFoundException, PropertyNotWritableException {
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(ResolverType.VARIABLE_ELRESOLVER).getELContext();
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        vexp.setValue(context, exprVal);
        return vexp.getValue(context);
    }

    public static boolean evaluateManyValueExpression(String exprStr, Object exprVal, Class<?> expectedClass, Hashtable<Class<?>, Object> contextobj) throws ELException, PropertyNotFoundException, PropertyNotWritableException, ClassNotFoundException {
        boolean result = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        ELContext context = new SimpleELContext(ResolverType.VARIABLE_ELRESOLVER).getELContext();
        ValueExpression vexp = expFactory.createValueExpression(context, exprStr, expectedClass);
        vexp.setValue(context, exprVal);
        Enumeration<Class<?>> keys = contextobj.keys();
        while (keys.hasMoreElements()) {
            Class<?> cl = keys.nextElement();
            Object value = contextobj.get(cl);
            context.putContext(cl, value);
            logger.log(System.Logger.Level.TRACE, "Adding value: \"" + String.valueOf(value) + "\" To Context!");
            if (ExprEval.compareValue(exprVal, vexp.getValue(context))) continue;
            logger.log(System.Logger.Level.ERROR, "Expression Failed! After Adding: \"" + String.valueOf(value) + "\" To Context");
            result = false;
        }
        return result;
    }

    public static boolean compareClass(Object obj, Class<?> expectedClass) {
        boolean isInstance = expectedClass.isInstance(obj);
        if (!isInstance) {
            logger.log(System.Logger.Level.ERROR, "Unexpected type for expression evaluation");
            logger.log(System.Logger.Level.ERROR, "Expected type: " + expectedClass.toString());
            logger.log(System.Logger.Level.ERROR, "Computed type: " + obj.getClass().toString());
        }
        return isInstance;
    }

    public static boolean compareValue(Object val, Object expectedVal) {
        if (!val.equals(expectedVal)) {
            logger.log(System.Logger.Level.ERROR, "Unexpected value for expression evaluation");
            logger.log(System.Logger.Level.ERROR, "Expected value: " + expectedVal.toString());
            logger.log(System.Logger.Level.ERROR, "Computed value: " + val.toString());
            return false;
        }
        return true;
    }

    public static boolean compareValue(Boolean val, Boolean expectedVal) {
        if (!val.equals(expectedVal)) {
            logger.log(System.Logger.Level.ERROR, "Unexpected value for expression evaluation");
            logger.log(System.Logger.Level.ERROR, "Expected value: " + expectedVal.toString());
            logger.log(System.Logger.Level.ERROR, "Computed value: " + val.toString());
            return false;
        }
        return true;
    }

    public static boolean compareValue(Double val, Float expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal.doubleValue());
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(Float val, Float expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val.doubleValue());
        BigDecimal b = new BigDecimal(expectedVal.doubleValue());
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(Long val, Long expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal);
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(BigInteger val, BigInteger expectedVal, int eps) {
        BigDecimal a = new BigDecimal(val);
        BigDecimal b = new BigDecimal(expectedVal);
        return ExprEval.compareValue(a, b, eps);
    }

    public static boolean compareValue(BigDecimal val, BigDecimal expectedVal, int eps) {
        BigDecimal b;
        MathContext mc = new MathContext(eps, RoundingMode.DOWN);
        BigDecimal a = val.abs(mc);
        if (0 != a.compareTo(b = expectedVal.abs(mc))) {
            logger.log(System.Logger.Level.ERROR, "Unexpected value for expression evaluation");
            logger.log(System.Logger.Level.ERROR, "Expected value: " + String.valueOf(expectedVal));
            logger.log(System.Logger.Level.ERROR, "Computed value: " + String.valueOf(val));
            return false;
        }
        return true;
    }

    public static void cleanup() {
        new SimpleELContext().cleanup();
    }
}

