/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.methodexpression;

import com.sun.ts.tests.el.common.api.expression.ExpressionTest;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.Expression;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String NL = System.getProperty("line.seperator", "\n");
    private Properties testProps = System.getProperties();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void positiveMethodExpressionTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
            ELContext context = simpleContext.getELContext();
            Object[] params1 = new Object[]{"new member"};
            Class[] paramTypes1 = new Class[]{Object.class};
            String exprStr1 = "#{vect.add}";
            MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes1);
            pass1 = ExpressionTest.testMethodExpression(mexp1, context, exprStr1, params1, Boolean.TRUE, false, buf);
            Object[] params2 = new Object[]{0, "new member"};
            Class[] paramTypes2 = new Class[]{Integer.TYPE, Object.class};
            String exprStr2 = "#{vect.add}";
            MethodExpression mexp2 = expFactory.createMethodExpression(context, exprStr2, null, paramTypes2);
            pass2 = ExpressionTest.testMethodExpression(mexp2, context, exprStr2, params2, null, false, buf);
            Object[] params3 = null;
            Class[] paramTypes3 = new Class[]{};
            String exprStr3 = "true";
            MethodExpression mexp3 = expFactory.createMethodExpression(context, exprStr3, String.class, paramTypes3);
            pass3 = ExpressionTest.testMethodExpression(mexp3, context, exprStr3, params3, "true", true, buf);
            Object[] params4 = null;
            Class[] paramTypes4 = new Class[]{};
            String exprStr4 = "true";
            MethodExpression mexp4 = expFactory.createMethodExpression(context, exprStr4, Boolean.class, paramTypes4);
            pass4 = ExpressionTest.testMethodExpression(mexp4, context, exprStr4, params4, Boolean.TRUE, true, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    @Test
    public void negativeMethodExpressionTest() throws Exception {
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        SimpleELContext simpleContext = new SimpleELContext(ResolverType.VECT_ELRESOLVER);
        ELContext context = simpleContext.getELContext();
        Object[] params = new Object[]{"new member"};
        Class[] paramTypes = new Class[]{Object.class};
        String exprStr1 = "#{vect.add}";
        MethodExpression mexp1 = expFactory.createMethodExpression(context, exprStr1, Boolean.TYPE, paramTypes);
        try {
            mexp1.getMethodInfo(null);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with null ELContext parameter did not" + NL);
            logger.log(System.Logger.Level.ERROR, " cause an exception to be thrown" + NL);
        }
        catch (NullPointerException npe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, when Null ELContext passed to getMethodInfo(): " + npe.getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with null ELContext threw the wrong Exception!" + NL + "Expected: NullPointerException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        try {
            mexp1.invoke(null, params);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() with null ELContext parameter did not" + NL);
            logger.log(System.Logger.Level.ERROR, " cause an exception to be thrown" + NL);
        }
        catch (NullPointerException npe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, when Null ELContext passed to invoke(): " + npe.getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() with null ELContext throw the wrong Exception!" + NL + "Expected: NullPointerException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        String exprStr2 = "#{vect.noSuchMethod}";
        MethodExpression mexp2 = expFactory.createMethodExpression(context, exprStr2, Boolean.TYPE, paramTypes);
        try {
            mexp2.getMethodInfo(context);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() for non-existent method did not cause" + NL);
            logger.log(System.Logger.Level.ERROR, " an exception to be thrown" + NL);
        }
        catch (MethodNotFoundException mnfe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, when method does not exists for getMethodInfo(): " + ((Object)((Object)mnfe)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() for non-existent method threw the wrong exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        try {
            mexp2.invoke(context, params);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for non-existent method did not cause" + NL);
            logger.log(System.Logger.Level.ERROR, " an exception to be thrown" + NL);
        }
        catch (MethodNotFoundException mnfe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, when method does not exists for invoke(): " + ((Object)((Object)mnfe)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() for non-existent method threw the wrong exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        String exprStr3 = "#{wect.add}";
        MethodExpression mexp3 = expFactory.createMethodExpression(context, exprStr3, Boolean.TYPE, paramTypes);
        try {
            mexp3.getMethodInfo(context);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() for non-existent property did not cause" + NL);
            logger.log(System.Logger.Level.ERROR, " an exception to be thrown" + NL);
        }
        catch (PropertyNotFoundException pnfe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, No such property in ELContextfor getMethodInfo(): " + ((Object)((Object)pnfe)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() for non-existent property threw the wrong exception!" + NL + "Expected: PropertyNotFoundException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        try {
            mexp3.invoke(context, params);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for non-existent property did not cause" + NL);
            logger.log(System.Logger.Level.ERROR, " an exception to be thrown" + NL);
        }
        catch (PropertyNotFoundException pnfe) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown, No such property in ELContextfor invoke(): " + ((Object)((Object)pnfe)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for non-existent property threw the wrong exception!" + NL + "Expected: PropertyNotFoundException" + NL + "Received: " + e.toString() + NL);
            e.printStackTrace();
        }
        String exprStr4 = "literal";
        MethodExpression mexp4 = expFactory.createMethodExpression(context, exprStr4, Void.TYPE, paramTypes);
        try {
            mexp4.invoke(context, params);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for string literal with expected return" + NL);
            logger.log(System.Logger.Level.ERROR, " value of void did not cause an exception to be thrown" + NL);
        }
        catch (ELException ee) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown. Call to invoke() with string literal ELContext for invoke()." + NL + "Expected return type is void: " + ((Object)((Object)ee)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for string literal with expected return" + NL + "value of void caused the wrong exception to be thrown!" + NL + "Expected: ELException: " + NL + "Received: " + e.toString());
            e.printStackTrace();
        }
        String exprStr5 = "literal";
        MethodExpression mexp5 = expFactory.createMethodExpression(context, exprStr5, Double.class, paramTypes);
        try {
            mexp5.invoke(context, params);
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for string literal with non-coercable expected " + NL);
            logger.log(System.Logger.Level.ERROR, "return value did not cause an exception to be thrown" + NL);
        }
        catch (ELException ee) {
            logger.log(System.Logger.Level.INFO, "Expected Exception Thrown. Call to invoke() with string literal ELContext for invoke()." + NL + "Expected return type can't be coerced: " + ((Object)((Object)ee)).getClass().getSimpleName());
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to invoke() for string literal with non-coercable expected " + NL + "return value caused the wrong exception to be thrown!" + NL + "Expected: ELException: " + NL + "Received: " + e.toString());
            e.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }

    @Test
    public void methodExpressionSerializableTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        Class[] paramTypes = new Class[]{Object.class};
        String exprStr = "#{vect.add}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new SimpleELContext().getELContext();
            MethodExpression evalmexp = expFactory.createMethodExpression(context, exprStr, Boolean.class, paramTypes);
            logger.log(System.Logger.Level.TRACE, "Eval Method Expression For Testing: " + evalmexp.toString() + NL);
            MethodExpression literalmexp = expFactory.createMethodExpression(context, "vect.add", Boolean.class, paramTypes);
            logger.log(System.Logger.Level.TRACE, "Literal Method Expression For Testing: " + literalmexp.toString() + NL);
            if (!ExpressionTest.expressionSerializableTest((Expression)evalmexp, buf) || !ExpressionTest.expressionSerializableTest((Expression)literalmexp, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingExactPreferredTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetA('text')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression(me, context, exprStr, null, "String", false, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingOverloadBeatsCoercionTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetB('1')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression(me, context, exprStr, null, "CharSequence", false, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingOverloadBeatsExactVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetC('aaa','bbb')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression(me, context, exprStr, null, "CharSequence-CharSequence", false, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingCoercionBeatsExactVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetD('1','1')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression(me, context, exprStr, null, "Long-Long", false, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingVarArgsTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetD('aaa','bbb')}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            if (!ExpressionTest.testMethodExpression(me, context, exprStr, null, "String-Strings", false, buf)) {
                pass = false;
            }
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with valid method expression threw an Exception!" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void methodExpressionMatchingAmbiguousTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        String exprStr = "#{bean.targetE('1234',1234)}";
        boolean pass = true;
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression me = expFactory.createMethodExpression(context, exprStr, String.class, null);
            me.getMethodInfo(context);
            pass = false;
        }
        catch (MethodNotFoundException mnfe) {
            pass = true;
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Call to getMethodInfo() with ambiguous method expression threw the wrong Exception!" + NL + "Expected: MethodNotFoundException" + NL + "Received: " + ex.toString() + NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

