/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.functionmapper;

import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.FunctionMapper;
import java.lang.reflect.Method;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void functionMapperTest() throws Exception {
        String expected = "public static java.lang.Integer java.lang.Integer.valueOf(java.lang.String) throws java.lang.NumberFormatException";
        FuncMapperELContext context = new FuncMapperELContext();
        FunctionMapper funcMapper = context.getFunctionMapper();
        logger.log(System.Logger.Level.TRACE, "FunctionMapper is " + funcMapper.toString());
        if (funcMapper.resolveFunction("foo", "bar") != null) {
            logger.log(System.Logger.Level.ERROR, "Expected call to resolveFunction() to unassigned function to return null" + ELTestUtil.NL + "Instead call returned: " + funcMapper.resolveFunction("foo", "bar").getName() + ELTestUtil.NL);
            throw new Exception("Resolved unassigned function");
        }
        Method method = funcMapper.resolveFunction("Int", "val");
        if (method == null) {
            logger.log(System.Logger.Level.ERROR, "Expected call to resolveFunction() to resolvable function to return a non-null value" + ELTestUtil.NL);
            throw new Exception("Incorrect resolution: null method");
        }
        String methodSignature = method.toString();
        if (!methodSignature.equals(expected)) {
            logger.log(System.Logger.Level.ERROR, "Method Signature of resolved function is invalid" + ELTestUtil.NL + "Expected value:" + expected + ELTestUtil.NL);
            throw new Exception("Incorrect resolution: wrong method Signature");
        }
    }
}

