/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.standalone.entity;

import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.ReadOnlyTest;
import ee.jakarta.tck.data.framework.junit.anno.Standalone;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacter;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacters;
import ee.jakarta.tck.data.framework.read.only.AsciiCharactersPopulator;
import ee.jakarta.tck.data.framework.read.only.CustomRepository;
import ee.jakarta.tck.data.framework.read.only.NaturalNumber;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbers;
import ee.jakarta.tck.data.framework.read.only.NaturalNumbersPopulator;
import ee.jakarta.tck.data.framework.read.only.PositiveIntegers;
import ee.jakarta.tck.data.framework.read.only._AsciiChar;
import ee.jakarta.tck.data.framework.read.only._AsciiCharacter;
import ee.jakarta.tck.data.framework.utilities.TestPropertyUtility;
import ee.jakarta.tck.data.standalone.entity.Box;
import ee.jakarta.tck.data.standalone.entity.Boxes;
import ee.jakarta.tck.data.standalone.entity.Coordinate;
import ee.jakarta.tck.data.standalone.entity.MultipleEntityRepo;
import jakarta.data.Limit;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

@Standalone
@AnyEntity
@ReadOnlyTest
public class EntityTests {
    public static final Logger log = Logger.getLogger(EntityTests.class.getCanonicalName());
    @Inject
    Boxes boxes;
    @Inject
    NaturalNumbers numbers;
    @Inject
    PositiveIntegers positives;
    @Inject
    CustomRepository customRepo;
    @Inject
    AsciiCharacters characters;
    @Inject
    MultipleEntityRepo shared;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{EntityTests.class, Box.class, Boxes.class});
    }

    @BeforeEach
    public void setup() {
        Assertions.assertNotNull((Object)this.numbers);
        NaturalNumbersPopulator.get().populate(this.numbers);
        Assertions.assertNotNull((Object)this.characters);
        AsciiCharactersPopulator.get().populate(this.characters);
    }

    @Assertion(id="136", strategy="Ensures that the prepopulation step for readonly entities was successful")
    public void ensureNaturalNumberPrepopulation() {
        Assertions.assertEquals((long)100L, (long)this.numbers.countAll());
        Assertions.assertTrue((boolean)this.numbers.findById(0L).isEmpty(), (String)"Zero should not have been in the set of natural numbers.");
        Assertions.assertFalse((boolean)((NaturalNumber)this.numbers.findById(10L).get()).isOdd());
    }

    @Assertion(id="136", strategy="Ensures that multiple readonly entities will be prepopulated before testing")
    public void ensureCharacterPrepopulation() {
        Assertions.assertEquals((long)127L, (long)this.characters.countByHexadecimalNotNull());
        Assertions.assertEquals((char)'0', (char)this.characters.findByNumericValue(48).get().getThisCharacter());
        Assertions.assertTrue((boolean)this.characters.findByNumericValue(1).get().isControl());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from BasicRepository and adds some methods of its own. Use both built-in methods and the additional methods.")
    public void testBasicRepository() {
        Stream<NaturalNumber> found = this.numbers.findByIdBetweenOrderByNumTypeAsc(50L, 59L, (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.asc((String)"id")}));
        List list = found.map(NaturalNumber::getId).collect(Collectors.toList());
        Assertions.assertEquals(List.of(Long.valueOf(53L), Long.valueOf(59L), Long.valueOf(50L), Long.valueOf(51L), Long.valueOf(52L), Long.valueOf(54L), Long.valueOf(55L), Long.valueOf(56L), Long.valueOf(57L), Long.valueOf(58L)), list);
        Assertions.assertEquals((long)60L, (long)((NaturalNumber)this.numbers.findById(60L).orElseThrow()).getId());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from BasicRepository and defines no additional methods of its own. Use all of the built-in methods.")
    public void testBasicRepositoryBuiltInMethods() {
        List saved = this.boxes.saveAll(List.of(Box.of("TestBasicRepositoryMethods-01", 119, 120, 169), Box.of("TestBasicRepositoryMethods-02", 20, 21, 29), Box.of("TestBasicRepositoryMethods-03", 33, 56, 65), Box.of("TestBasicRepositoryMethods-04", 45, 28, 53)));
        Iterator savedIt = saved.iterator();
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box1 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-01", (Object)box1.boxIdentifier);
        Assertions.assertEquals((int)119, (int)box1.length);
        Assertions.assertEquals((int)120, (int)box1.width);
        Assertions.assertEquals((int)169, (int)box1.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box2 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-02", (Object)box2.boxIdentifier);
        Assertions.assertEquals((int)20, (int)box2.length);
        Assertions.assertEquals((int)21, (int)box2.width);
        Assertions.assertEquals((int)29, (int)box2.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box3 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-03", (Object)box3.boxIdentifier);
        Assertions.assertEquals((int)33, (int)box3.length);
        Assertions.assertEquals((int)56, (int)box3.width);
        Assertions.assertEquals((int)65, (int)box3.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box4 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-04", (Object)box4.boxIdentifier);
        Assertions.assertEquals((int)45, (int)box4.length);
        Assertions.assertEquals((int)28, (int)box4.width);
        Assertions.assertEquals((int)53, (int)box4.height);
        Assertions.assertEquals((Object)false, (Object)savedIt.hasNext());
        TestPropertyUtility.waitForEventualConsistency();
        box2.length = 21;
        box2.width = 20;
        box2 = (Box)this.boxes.save(box2);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-02", (Object)box2.boxIdentifier);
        Assertions.assertEquals((int)21, (int)box2.length);
        Assertions.assertEquals((int)20, (int)box2.width);
        Assertions.assertEquals((int)29, (int)box2.height);
        Box box5 = (Box)this.boxes.save(Box.of("TestBasicRepositoryMethods-05", 153, 104, 185));
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        TestPropertyUtility.waitForEventualConsistency();
        this.boxes.deleteAll(List.of(box1, box2));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)3L, (long)this.boxes.findAll().count());
        this.boxes.delete(box4);
        TestPropertyUtility.waitForEventualConsistency();
        Stream stream = this.boxes.findAll();
        List list = stream.sorted(Comparator.comparing(b -> b.boxIdentifier)).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)list.size());
        box4 = (Box)list.get(0);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-03", (Object)box3.boxIdentifier);
        Assertions.assertEquals((int)33, (int)box3.length);
        Assertions.assertEquals((int)56, (int)box3.width);
        Assertions.assertEquals((int)65, (int)box3.height);
        box5 = (Box)list.get(1);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        this.boxes.deleteById("TestBasicRepositoryMethods-03");
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((Object)false, (Object)this.boxes.findById("TestBasicRepositoryMethods-03").isPresent());
        box5 = (Box)this.boxes.findById("TestBasicRepositoryMethods-05").orElseThrow();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        this.boxes.deleteById("TestBasicRepositoryMethods-05");
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)0L, (long)this.boxes.findAll().count());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from BasicRepository and defines no additional methods of its own. Use all of the built-in methods.")
    public void testBasicRepositoryMethods() {
        List saved = this.boxes.saveAll(List.of(Box.of("TestBasicRepositoryMethods-01", 119, 120, 169), Box.of("TestBasicRepositoryMethods-02", 20, 21, 29), Box.of("TestBasicRepositoryMethods-03", 33, 56, 65), Box.of("TestBasicRepositoryMethods-04", 45, 28, 53)));
        Iterator savedIt = saved.iterator();
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box1 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-01", (Object)box1.boxIdentifier);
        Assertions.assertEquals((int)119, (int)box1.length);
        Assertions.assertEquals((int)120, (int)box1.width);
        Assertions.assertEquals((int)169, (int)box1.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box2 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-02", (Object)box2.boxIdentifier);
        Assertions.assertEquals((int)20, (int)box2.length);
        Assertions.assertEquals((int)21, (int)box2.width);
        Assertions.assertEquals((int)29, (int)box2.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box3 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-03", (Object)box3.boxIdentifier);
        Assertions.assertEquals((int)33, (int)box3.length);
        Assertions.assertEquals((int)56, (int)box3.width);
        Assertions.assertEquals((int)65, (int)box3.height);
        Assertions.assertEquals((Object)true, (Object)savedIt.hasNext());
        Box box4 = (Box)savedIt.next();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-04", (Object)box4.boxIdentifier);
        Assertions.assertEquals((int)45, (int)box4.length);
        Assertions.assertEquals((int)28, (int)box4.width);
        Assertions.assertEquals((int)53, (int)box4.height);
        Assertions.assertEquals((Object)false, (Object)savedIt.hasNext());
        TestPropertyUtility.waitForEventualConsistency();
        box2.length = 21;
        box2.width = 20;
        box2 = (Box)this.boxes.save(box2);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-02", (Object)box2.boxIdentifier);
        Assertions.assertEquals((int)21, (int)box2.length);
        Assertions.assertEquals((int)20, (int)box2.width);
        Assertions.assertEquals((int)29, (int)box2.height);
        Box box5 = (Box)this.boxes.save(Box.of("TestBasicRepositoryMethods-05", 153, 104, 185));
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        TestPropertyUtility.waitForEventualConsistency();
        this.boxes.deleteAll(List.of(box1, box2));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)3L, (long)this.boxes.findAll().count());
        this.boxes.delete(box4);
        TestPropertyUtility.waitForEventualConsistency();
        Stream stream = this.boxes.findAll();
        List list = stream.sorted(Comparator.comparing(b -> b.boxIdentifier)).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)list.size());
        box4 = (Box)list.get(0);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-03", (Object)box3.boxIdentifier);
        Assertions.assertEquals((int)33, (int)box3.length);
        Assertions.assertEquals((int)56, (int)box3.width);
        Assertions.assertEquals((int)65, (int)box3.height);
        box5 = (Box)list.get(1);
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        this.boxes.deleteById("TestBasicRepositoryMethods-03");
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((Object)false, (Object)this.boxes.findById("TestBasicRepositoryMethods-03").isPresent());
        box5 = (Box)this.boxes.findById("TestBasicRepositoryMethods-05").orElseThrow();
        Assertions.assertEquals((Object)"TestBasicRepositoryMethods-05", (Object)box5.boxIdentifier);
        Assertions.assertEquals((int)153, (int)box5.length);
        Assertions.assertEquals((int)104, (int)box5.width);
        Assertions.assertEquals((int)185, (int)box5.height);
        this.boxes.deleteById("TestBasicRepositoryMethods-05");
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)0L, (long)this.boxes.findAll().count());
    }

    @Assertion(id="133", strategy="Request a Page higher than the final Page, expecting an empty Page with 0 results.")
    public void testBeyondFinalPage() {
        Page<AsciiCharacter> page;
        PageRequest sixth = PageRequest.ofPage((long)6L).size(10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, sixth, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiCharacter.numericValue.asc()}));
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request a Slice higher than the final Slice, expecting an empty Slice with 0 results.")
    public void testBeyondFinalSlice() {
        PageRequest sixth = PageRequest.ofPage((long)6L).size(5).withoutTotal();
        Page<NaturalNumber> page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, sixth, (Sort<NaturalNumber>)Sort.desc((String)"id"));
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
    }

    @Assertion(id="133", strategy="Use a parameter-based find operation that uses the By annotation to identify the entity attribute names.")
    public void testBy() {
        AsciiCharacter ch = this.characters.find('L', "4c").orElseThrow();
        Assertions.assertEquals((char)'L', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"4c", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)76L, (long)ch.getId());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        Assertions.assertEquals((Object)true, (Object)this.characters.find('M', "4b").isEmpty());
    }

    @Assertion(id="133", strategy="Use a repository that inherits some if its methods from another interface.")
    public void testCommonInterfaceQueries() {
        Assertions.assertEquals((long)4L, (long)this.numbers.countByIdBetween(87L, 90L));
        Assertions.assertEquals((long)5L, (long)this.characters.countByIdBetween(86L, 90L));
        Assertions.assertEquals((Object)true, (Object)this.numbers.existsById(73L));
        Assertions.assertEquals((Object)true, (Object)this.characters.existsById(74L));
        Assertions.assertEquals((Object)false, (Object)this.numbers.existsById(-1L));
        Assertions.assertEquals((Object)false, (Object)this.characters.existsById(-2L));
        Assertions.assertEquals(List.of(Long.valueOf(68L), Long.valueOf(69L), Long.valueOf(70L), Long.valueOf(71L), Long.valueOf(72L)), (Object)this.characters.withIdEqualOrAbove(68L, Limit.of((int)5)));
        Assertions.assertEquals(List.of(Long.valueOf(71L), Long.valueOf(72L), Long.valueOf(73L), Long.valueOf(74L), Long.valueOf(75L)), (Object)this.numbers.withIdEqualOrAbove(71L, Limit.of((int)5)));
    }

    @Assertion(id="133", strategy="Use a repository method with Contains to query for a substring of a String attribute.")
    public void testContainsInString() {
        List<AsciiCharacter> found = this.characters.findByHexadecimalContainsAndIsControlNot("4", true);
        Assertions.assertEquals(List.of("24", "34", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "54", "64", "74"), found.stream().map(AsciiCharacter::getHexadecimal).sorted().toList());
    }

    @Assertion(id="133", strategy="Use a repository that inherits from DataRepository and defines all of its own methods.")
    public void testDataRepository() {
        AsciiCharacter del = this.characters.findByIsControlTrueAndNumericValueBetween(33, 127);
        Assertions.assertEquals((int)127, (int)del.getNumericValue());
        Assertions.assertEquals((Object)"7f", (Object)del.getHexadecimal());
        Assertions.assertEquals((Object)true, (Object)del.isControl());
        AsciiCharacter j = this.characters.findByHexadecimalIgnoreCase("6A");
        Assertions.assertEquals((Object)"6a", (Object)j.getHexadecimal());
        Assertions.assertEquals((char)'j', (char)j.getThisCharacter());
        Assertions.assertEquals((int)106, (int)j.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)j.isControl());
        AsciiCharacter d = this.characters.findByNumericValue(100).orElseThrow();
        Assertions.assertEquals((int)100, (int)d.getNumericValue());
        Assertions.assertEquals((char)'d', (char)d.getThisCharacter());
        Assertions.assertEquals((Object)"64", (Object)d.getHexadecimal());
        Assertions.assertEquals((Object)false, (Object)d.isControl());
        Assertions.assertEquals((Object)true, (Object)this.characters.existsByThisCharacter('D'));
    }

    @Assertion(id="133", strategy="Use a default method from a repository interface where the default method invokes other repository methods.")
    public void testDefaultMethod() {
        Assertions.assertEquals(List.of(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d')), this.characters.retrieveAlphaNumericIn(87L, 100L).map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with one Sort parameter specifying descending order, and verify all results are returned and are in descending order according to the sort criteria.")
    public void testDescendingSort() {
        Stream<AsciiCharacter> stream = this.characters.findByIdBetween(52L, 57L, (Sort<AsciiCharacter>)Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Character[]{Character.valueOf('9'), Character.valueOf('8'), Character.valueOf('7'), Character.valueOf('6'), Character.valueOf('5'), Character.valueOf('4')}), (Object)Arrays.toString(stream.map(AsciiCharacter::getThisCharacter).toArray()));
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that has no clauses.")
    public void testEmptyQuery() {
        Assertions.assertEquals(List.of(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f')), this.characters.all(Limit.range((long)97L, (long)102L), Sort.asc((String)"id")).map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where no result is found. Expect EmptyResultException.")
    public void testEmptyResultException() {
        try {
            AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2g");
            Assertions.fail((String)("Unexpected result of findByHexadecimalIgnoreCase(2g): " + ch.getHexadecimal()));
        }
        catch (EmptyResultException x) {
            log.info("testEmptyResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Use a repository method with the False keyword.")
    public void testFalse() {
        List<NaturalNumber> even = this.positives.findByIsOddFalseAndIdBetween(50L, 60L);
        Assertions.assertEquals((long)6L, (long)even.stream().count());
        Assertions.assertEquals(List.of(Long.valueOf(50L), Long.valueOf(52L), Long.valueOf(54L), Long.valueOf(56L), Long.valueOf(58L), Long.valueOf(60L)), even.stream().map(NaturalNumber::getId).sorted().collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Request the last Page of up to 10 results, expecting to find the final 3.")
    public void testFinalPageOfUpTo10() {
        Page<AsciiCharacter> page;
        PageRequest fifthPageRequest = PageRequest.ofPage((long)5L).size(10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, fifthPageRequest, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiCharacter.numericValue.asc()}));
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Iterator it = page.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        AsciiCharacter ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'X', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"58", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)88L, (long)ch.getId());
        Assertions.assertEquals((int)88, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Y', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"59", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)89L, (long)ch.getId());
        Assertions.assertEquals((int)89, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        ch = (AsciiCharacter)it.next();
        Assertions.assertEquals((char)'Z', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"5a", (Object)ch.getHexadecimal());
        Assertions.assertEquals((long)90L, (long)ch.getId());
        Assertions.assertEquals((int)90, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)page.pageRequest().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)3, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
    }

    @Assertion(id="133", strategy="Request the last Slice of up to 5 results, expecting to find the final 2.")
    public void testFinalSliceOfUpTo5() {
        PageRequest fifth = PageRequest.ofPage((long)5L).size(5).withoutTotal();
        Page<NaturalNumber> page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fifth, (Sort<NaturalNumber>)Sort.desc((String)"id"));
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((long)5L, (long)page.pageRequest().page());
        Assertions.assertEquals((int)2, (int)page.numberOfElements());
        Iterator it = page.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)3L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)2L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)1L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)false, (Object)number.isOdd());
        Assertions.assertEquals((Short)2, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use the findAll method of a repository that inherits from BasicRepository to request a Page 2 of size 12, specifying a PageRequest that requires a mixture of ascending and descending sort. Verify the page contains all 12 expected entities, sorted according to the mixture of ascending and descending sort orders specified.")
    public void testFindAllWithPagination() {
        PageRequest page2request = PageRequest.ofPage((long)2L).size(12);
        Page page2 = this.positives.findAll(page2request, Order.by((Sort[])new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")}));
        Assertions.assertEquals((int)12, (int)page2.numberOfElements());
        Assertions.assertEquals((long)2L, (long)page2.pageRequest().page());
        Assertions.assertEquals(List.of(11L, 10L, 9L, 24L, 23L, 22L, 21L, 20L, 19L, 18L, 17L, 16L), page2.stream().map(n -> n.getId()).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with findFirstBy that returns the first entity value where multiple results would otherwise be found.")
    public void testFindFirst() {
        Optional<AsciiCharacter> none = this.characters.findFirstByHexadecimalStartsWithAndIsControlOrderByIdAsc("h", false);
        Assertions.assertEquals((Object)true, (Object)none.isEmpty());
        AsciiCharacter ch = this.characters.findFirstByHexadecimalStartsWithAndIsControlOrderByIdAsc("4", false).orElseThrow();
        Assertions.assertEquals((char)'@', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"40", (Object)ch.getHexadecimal());
        Assertions.assertEquals((int)64, (int)ch.getNumericValue());
    }

    @Assertion(id="133", strategy="Use a repository method with findFirst3By that returns the first 3 results.")
    public void testFindFirst3() {
        AsciiCharacter[] found = this.characters.findFirst3ByNumericValueGreaterThanEqualAndHexadecimalEndsWith(40, "4", (Sort<AsciiCharacter>)Sort.asc((String)"numericValue"));
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((char)'4', (char)found[0].getThisCharacter());
        Assertions.assertEquals((char)'D', (char)found[1].getThisCharacter());
        Assertions.assertEquals((char)'T', (char)found[2].getThisCharacter());
    }

    @Assertion(id="133", strategy="Find a list of entities, querying by entity attributes with names that match the method parameter names, with results capped by a Limit parameter and sorted according to a variable arguments Sort parameter.")
    public void testFindList() {
        List<NaturalNumber> oddCompositeNumbers = this.positives.findOdd(true, NaturalNumber.NumberType.COMPOSITE, Limit.of((int)10), (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"numBitsRequired"), Sort.asc((String)"id")}));
        Assertions.assertEquals(List.of(Long.valueOf(9L), Long.valueOf(15L), Long.valueOf(21L), Long.valueOf(33L), Long.valueOf(35L), Long.valueOf(25L), Long.valueOf(27L), Long.valueOf(39L), Long.valueOf(45L), Long.valueOf(49L)), oddCompositeNumbers.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        List<NaturalNumber> evenPrimeNumbers = this.positives.findOdd(false, NaturalNumber.NumberType.PRIME, Limit.of((int)9), (Order<NaturalNumber>)Order.by((Sort[])new Sort[0]));
        Assertions.assertEquals((int)1, (int)evenPrimeNumbers.size());
        NaturalNumber num = evenPrimeNumbers.get(0);
        Assertions.assertEquals((long)2L, (long)num.getId());
        Assertions.assertEquals((long)1L, (long)num.getFloorOfSquareRoot());
        Assertions.assertEquals((Short)2, (Short)num.getNumBitsRequired());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)num.getNumType()));
        Assertions.assertEquals((Object)false, (Object)num.isOdd());
    }

    @Assertion(id="133", strategy="Find a single entity, querying by entity attributes with names that match the method parameter names.")
    public void testFindOne() {
        AsciiCharacter j = this.characters.find('j');
        Assertions.assertEquals((Object)"6a", (Object)j.getHexadecimal());
        Assertions.assertEquals((long)106L, (long)j.getId());
        Assertions.assertEquals((int)106, (int)j.getNumericValue());
        Assertions.assertEquals((char)'j', (char)j.getThisCharacter());
    }

    @Assertion(id="133", strategy="Find a single entity that might or might not exist, querying by entity attributes with names that match the method parameter names.")
    public void testFindOptional() {
        NaturalNumber num = this.positives.findNumber(67L).orElseThrow();
        Assertions.assertEquals((long)67L, (long)num.getId());
        Assertions.assertEquals((long)8L, (long)num.getFloorOfSquareRoot());
        Assertions.assertEquals((Short)7, (Short)num.getNumBitsRequired());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)num.getNumType()));
        Assertions.assertEquals((Object)true, (Object)num.isOdd());
        Optional<NaturalNumber> opt = this.positives.findNumber(-40L);
        Assertions.assertEquals((Object)false, (Object)opt.isPresent());
    }

    @Assertion(id="133", strategy="Find a page of entities, with entity attributes identified by the parameter names and matching the parameter values.")
    public void testFindPage() {
        PageRequest page1Request = PageRequest.ofSize((int)7);
        Page<NaturalNumber> page1 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page1Request, Sort.desc((String)"id"));
        Assertions.assertEquals(List.of(Long.valueOf(99L), Long.valueOf(98L), Long.valueOf(96L), Long.valueOf(95L), Long.valueOf(94L), Long.valueOf(93L), Long.valueOf(92L)), page1.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals((Object)true, (Object)page1.hasNext());
        Page<NaturalNumber> page2 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page1.nextPageRequest(), Sort.desc((String)"id"));
        Assertions.assertEquals(List.of(Long.valueOf(91L), Long.valueOf(90L), Long.valueOf(88L), Long.valueOf(87L), Long.valueOf(86L), Long.valueOf(85L), Long.valueOf(84L)), page2.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals((Object)true, (Object)page2.hasNext());
        Page<NaturalNumber> page3 = this.positives.findMatching(9L, (short)7, NaturalNumber.NumberType.COMPOSITE, page2.nextPageRequest(), Sort.desc((String)"id"));
        Assertions.assertEquals(List.of(Long.valueOf(82L), Long.valueOf(81L)), page3.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals((Object)false, (Object)page3.hasNext());
    }

    @Assertion(id="133", strategy="Request the first CursoredPage of 8 results, expecting to find all 8, then request the next CursoredPage and the CursoredPage after that, expecting to find all results.")
    public void testFirstCursoredPageOf8AndNextPages() {
        CursoredPage<NaturalNumber> page;
        Order order = Order.by((Sort[])new Sort[]{Sort.asc((String)"id")});
        PageRequest first8 = PageRequest.ofSize((int)8);
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(4L, 33L, first8, (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)8, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{32L, 25L, 26L, 27L, 28L, 29L, 30L, 31L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(4L, 33L, page.nextPageRequest(), (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)8, (int)page.numberOfElements());
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(4L, 33L, page.nextPageRequest(), (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)7, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{4L, 5L, 6L, 7L, 2L, 3L, 1L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Request the first CursoredPage of 6 results, expecting to find all 6, then request the next CursoredPage and the CursoredPage after that, expecting to find all results.")
    public void testFirstCursoredPageWithoutTotalOf6AndNextPages() {
        CursoredPage<NaturalNumber> slice;
        PageRequest first6 = PageRequest.ofSize((int)6).withoutTotal();
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, first6);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{49L, 50L, 51L, 52L, 53L, 54L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageRequest());
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)6, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{55L, 56L, 57L, 58L, 59L, 60L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(7L, slice.nextPageRequest());
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 62L, 63L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)3, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request the first Page of 10 results, expecting to find all 10. From the Page, verify the totalElements and totalPages expected.")
    public void testFirstPageOf10() {
        Page<AsciiCharacter> page;
        PageRequest first10 = PageRequest.ofSize((int)10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, first10, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiCharacter.numericValue.asc()}));
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)1L, (long)page.pageRequest().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"30:0;31:1;32:2;33:3;34:4;35:5;36:6;37:7;38:8;39:9;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the first Slice of 5 results, expecting to find all 5.")
    public void testFirstSliceOf5() {
        PageRequest first5 = PageRequest.ofSize((int)5).withoutTotal();
        Page<NaturalNumber> page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, first5, (Sort<NaturalNumber>)Sort.desc((String)"id"));
        Assertions.assertEquals((int)5, (int)page.numberOfElements());
        Iterator it = page.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)79L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)8L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)7, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)73L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)71L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)67L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        number = (NaturalNumber)it.next();
        Assertions.assertEquals((long)61L, (long)number.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)number.getNumType()));
        Assertions.assertEquals((long)7L, (long)number.getFloorOfSquareRoot());
        Assertions.assertEquals((Object)true, (Object)number.isOdd());
        Assertions.assertEquals((Short)6, (Short)number.getNumBitsRequired());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="133", strategy="Use a repository method existsByIdGreaterThan confirming the correct boolean is returned.")
    public void testGreaterThanEqualExists() {
        Assertions.assertEquals((Object)true, (Object)this.positives.existsByIdGreaterThan(0L));
        Assertions.assertEquals((Object)true, (Object)this.positives.existsByIdGreaterThan(99L));
        Assertions.assertEquals((Object)false, (Object)this.positives.existsByIdGreaterThan(100L));
    }

    @Assertion(id="133", strategy="Use a repository method with the In keyword.")
    public void testIn() {
        Stream<NaturalNumber> nonPrimes = this.positives.findByNumTypeInOrderByIdAsc(Set.of(NaturalNumber.NumberType.COMPOSITE, NaturalNumber.NumberType.ONE), Limit.of((int)9));
        Assertions.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(6L), Long.valueOf(8L), Long.valueOf(9L), Long.valueOf(10L), Long.valueOf(12L), Long.valueOf(14L), Long.valueOf(15L)), nonPrimes.map(NaturalNumber::getId).collect(Collectors.toList()));
        Stream<NaturalNumber> primes = this.positives.findByNumTypeInOrderByIdAsc(Collections.singleton(NaturalNumber.NumberType.PRIME), Limit.of((int)6));
        Assertions.assertEquals(List.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(5L), Long.valueOf(7L), Long.valueOf(11L), Long.valueOf(13L)), primes.map(NaturalNumber::getId).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with the IgnoreCase keyword.")
    public void testIgnoreCase() {
        Stream<AsciiCharacter> found = this.characters.findByHexadecimalIgnoreCaseBetweenAndHexadecimalNotIn("4c", "5A", Set.of("5"), (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{Sort.asc((String)"hexadecimal")}));
        Assertions.assertEquals(List.of(Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')), found.map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Request a CursoredPage of 7 results after the cursor of the 20th result, expecting to find the next 7 results. Then request the CursoredPage before the cursor of the first entry of the page, expecting to find the previous 7 results. Then request the CursoredPage after the last entry of the original slice, expecting to find the next 7.")
    public void testCursoredPageOf7FromCursor() {
        CursoredPage<NaturalNumber> nextPage;
        CursoredPage<NaturalNumber> previousPage;
        CursoredPage<NaturalNumber> page;
        Order order = Order.by((Sort[])new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")});
        PageRequest middle7 = PageRequest.afterCursor((PageRequest.Cursor)PageRequest.Cursor.forKey((Object[])new Object[]{(short)5, 5L, 26L}), (long)4L, (int)7, (boolean)true);
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(6L, 50L, middle7, (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{25L, 8L, 15L, 14L, 13L, 12L, 11L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)page.numberOfElements());
        Assertions.assertEquals((Object)true, (Object)page.hasPrevious());
        try {
            previousPage = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(6L, 50L, page.previousPageRequest(), (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{16L, 31L, 30L, 29L, 28L, 27L, 26L}), (Object)Arrays.toString(previousPage.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)previousPage.numberOfElements());
        try {
            nextPage = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(6L, 50L, page.nextPageRequest(), (Order<NaturalNumber>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{10L, 9L, 7L, 6L, 5L, 4L, 3L}), (Object)Arrays.toString(nextPage.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)7, (int)nextPage.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a CursoredPage of results where none match the query, expecting an empty CursoredPage with 0 results.")
    public void testCursoredPageOfNothing() {
        CursoredPage<NaturalNumber> page;
        try {
            page = this.positives.findByFloorOfSquareRootNotAndIdLessThanOrderByNumBitsRequiredDesc(1L, 4L, PageRequest.ofPage((long)1L), (Order<NaturalNumber>)Order.by((Sort[])new Sort[0]));
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.hasNext());
        Assertions.assertEquals((Object)false, (Object)page.hasPrevious());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        try {
            page.nextPageRequest();
            Assertions.fail((String)"nextPageRequest must raise NoSuchElementException when current page is empty.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            page.previousPageRequest();
            Assertions.fail((String)"previousPageRequest must raise NoSuchElementException when current page is empty.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Assertion(id="133", strategy="Request a CursoredPage of 9 results after the cursor of the 20th result, expecting to find the next 9 results. Then request the CursoredPage before the cursor of the first entry of the slice, expecting to find the previous 9 results. Then request the CursoredPage after the last entry of the original slice, expecting to find the next 9.")
    public void testCursoredPageWithoutTotalOf9FromCursor() {
        CursoredPage<NaturalNumber> nextSlice;
        CursoredPage<NaturalNumber> previousSlice;
        CursoredPage<NaturalNumber> slice;
        PageRequest middle9 = PageRequest.afterCursor((PageRequest.Cursor)PageRequest.Cursor.forKey((Object[])new Object[]{6L, 46L}), (long)4L, (int)9, (boolean)false);
        Order order = Order.by((Sort[])new Sort[]{Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id")});
        try {
            slice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, (Order<NaturalNumber>)order, middle9);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{48L, 25L, 26L, 27L, 28L, 30L, 32L, 33L, 34L}), (Object)Arrays.toString(slice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)slice.numberOfElements());
        Assertions.assertEquals((Object)true, (Object)slice.hasPrevious());
        try {
            previousSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, (Order<NaturalNumber>)order, slice.previousPageRequest());
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 36L, 38L, 39L, 40L, 42L, 44L, 45L, 46L}), (Object)Arrays.toString(previousSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)previousSlice.numberOfElements());
        try {
            nextSlice = this.numbers.findByNumTypeAndNumBitsRequiredLessThan(NaturalNumber.NumberType.COMPOSITE, (short)7, (Order<NaturalNumber>)order, slice.nextPageRequest());
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{35L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L}), (Object)Arrays.toString(nextSlice.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((int)9, (int)nextSlice.numberOfElements());
    }

    @Assertion(id="133", strategy="Request a CursoredPage of results where none match the query, expecting an empty CursoredPage with 0 results.")
    public void testCursoredPageWithoutTotalOfNothing() {
        CursoredPage<NaturalNumber> slice;
        PageRequest pagination = PageRequest.ofSize((int)33).afterCursor(PageRequest.Cursor.forKey((Object[])new Object[]{30L})).withoutTotal();
        try {
            slice = this.numbers.findByFloorOfSquareRootOrderByIdAsc(3L, pagination);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((Object)false, (Object)slice.hasContent());
        Assertions.assertEquals((int)0, (int)slice.content().size());
        Assertions.assertEquals((int)0, (int)slice.numberOfElements());
    }

    @Assertion(id="133", strategy="Use a repository method countByIdLessThan confirming the correct count is returned.")
    public void testLessThanWithCount() {
        Assertions.assertEquals((long)91L, (long)this.positives.countByIdLessThan(92L));
        Assertions.assertEquals((long)0L, (long)this.positives.countByIdLessThan(1L));
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, and verify that the Limit caps the number of results and that results are ordered according to the sort criteria.")
    public void testLimit() {
        List<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(60L, Limit.of((int)10), (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"id")}));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{63L, 62L, 61L, 60L, 80L, 79L, 78L, 77L, 76L, 75L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with both Sort and Limit, where the Limit is a range,  and verify that the Limit range starts in the correct place, caps the number of results,  and that results are ordered according to the sort criteria.")
    public void testLimitedRange() {
        List<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(40L, Limit.range((long)6L, (long)10L), (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.asc((String)"numType"), Sort.asc((String)"id")}));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{61L, 67L, 71L, 73L, 79L}), (Object)Arrays.toString(nums.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with Limit and verify that the Limit caps the number of results to the amount that is specified.")
    public void testLimitToOneResult() {
        List<NaturalNumber> nums = this.numbers.findByIdGreaterThanEqual(80L, Limit.of((int)1), (Order<NaturalNumber>)Order.by((Sort[])new Sort[0]));
        Iterator it = nums.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        NaturalNumber num = (NaturalNumber)it.next();
        Assertions.assertEquals((Object)true, (Object)(num.getId() >= 80L ? 1 : 0));
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL Query that specifies an enum literal and a boolean false literal.")
    public void testLiteralEnumAndLiteralFalse() {
        NaturalNumber two = this.numbers.two().orElseThrow();
        Assertions.assertEquals((long)2L, (long)two.getId());
        Assertions.assertEquals((Object)((Object)NaturalNumber.NumberType.PRIME), (Object)((Object)two.getNumType()));
        Assertions.assertEquals((Short)2, (Short)two.getNumBitsRequired());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL Query that specifies literal Integer values.")
    public void testLiteralInteger() {
        Assertions.assertEquals((long)24L, (long)this.characters.twentyFour());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL Query that specifies literal String values.")
    public void testLiteralString() {
        Assertions.assertEquals(List.of(Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M')), this.characters.jklOr("4d").map(AsciiCharacter::getThisCharacter).sorted().collect(Collectors.toList()));
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL Query that specifies a boolean true literal.")
    public void testLiteralTrue() {
        Page<Long> page1 = this.numbers.oddsFrom21To(40L, PageRequest.ofSize((int)5));
        Assertions.assertEquals((long)10L, (long)page1.totalElements());
        Assertions.assertEquals((long)2L, (long)page1.totalPages());
        Assertions.assertEquals(List.of(Long.valueOf(21L), Long.valueOf(23L), Long.valueOf(25L), Long.valueOf(27L), Long.valueOf(29L)), (Object)page1.content());
        Assertions.assertEquals((Object)true, (Object)page1.hasNext());
        Page<Long> page2 = this.numbers.oddsFrom21To(40L, page1.nextPageRequest());
        Assertions.assertEquals(List.of(Long.valueOf(31L), Long.valueOf(33L), Long.valueOf(35L), Long.valueOf(37L), Long.valueOf(39L)), (Object)page2.content());
        if (page2.hasNext()) {
            Page<Long> page3 = this.numbers.oddsFrom21To(40L, page2.nextPageRequest());
            Assertions.assertEquals((Object)false, (Object)page3.hasContent());
            Assertions.assertEquals((Object)false, (Object)page3.hasNext());
        }
    }

    @Assertion(id="133", strategy="Use a repository method with two Sort parameters specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testMixedSort() {
        NaturalNumber[] nums = this.numbers.findByIdLessThan(15L, (Sort<NaturalNumber>)Sort.asc((String)"numBitsRequired"), (Sort<NaturalNumber>)Sort.desc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{1L, 3L, 2L, 7L, 6L, 5L, 4L, 14L, 13L, 12L, 11L, 10L, 9L, 8L}), (Object)Arrays.toString(Stream.of(nums).map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method that ought to return a single entity value but where multiple results are found.Expect NonUniqueResultException.")
    public void testNonUniqueResultException() {
        try {
            AsciiCharacter ch = this.characters.findByIsControlTrueAndNumericValueBetween(10, 15);
            Assertions.fail((String)("Unexpected result of findByIsControlTrueAndNumericValueBetween(10, 15): " + ch.getHexadecimal()));
        }
        catch (NonUniqueResultException x) {
            log.info("testNonUniqueResultException expected to catch exception " + x + ". Printing its stack trace:");
            x.printStackTrace(System.out);
        }
    }

    @Assertion(id="133", strategy="Use a repository method with the Not keyword.")
    public void testNot() {
        NaturalNumber[] n = this.numbers.findByNumTypeNot(NaturalNumber.NumberType.COMPOSITE, Limit.of((int)8), (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.asc((String)"id")}));
        Assertions.assertEquals((int)8, (int)n.length);
        Assertions.assertEquals((long)1L, (long)n[0].getId());
        Assertions.assertEquals((long)2L, (long)n[1].getId());
        Assertions.assertEquals((long)3L, (long)n[2].getId());
        Assertions.assertEquals((long)5L, (long)n[3].getId());
        Assertions.assertEquals((long)7L, (long)n[4].getId());
        Assertions.assertEquals((long)11L, (long)n[5].getId());
        Assertions.assertEquals((long)13L, (long)n[6].getId());
        Assertions.assertEquals((long)17L, (long)n[7].getId());
    }

    @Assertion(id="133", strategy="Use a repository method with Or, expecting UnsupportedOperationException if the underlying database is not capable.")
    public void testOr() {
        Stream<NaturalNumber> found;
        try {
            found = this.positives.findByNumTypeOrFloorOfSquareRoot(NaturalNumber.NumberType.ONE, 2L);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L)), found.map(NaturalNumber::getId).sorted().collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverPageRequestSorts() {
        PageRequest pagination = PageRequest.ofSize((int)8);
        Order order = Order.by((Sort[])new Sort[]{Sort.asc((String)"numType"), Sort.desc((String)"id")});
        Page<NaturalNumber> page = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination, (Order<NaturalNumber>)order);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{23L, 19L, 17L, 24L, 22L, 21L, 20L, 18L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((Object)true, (Object)page.hasNext());
        pagination = page.nextPageRequest();
        page = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination, (Order<NaturalNumber>)order);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{16L, 13L, 11L, 15L, 14L, 12L, 10L, 9L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((Object)true, (Object)page.hasNext());
        pagination = page.nextPageRequest();
        page = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination, (Order<NaturalNumber>)order);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{7L, 5L, 8L, 6L, 4L, 1L, 3L, 2L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        if (page.hasNext()) {
            pagination = page.nextPageRequest();
            page = this.numbers.findByIdLessThanOrderByFloorOfSquareRootDesc(25L, pagination, (Order<NaturalNumber>)order);
            Assertions.assertEquals((Object)false, (Object)page.hasContent());
        }
    }

    @Assertion(id="133", strategy="Use a repository method with OrderBy (static) and a PageRequest with a Sort parameter (dynamic), verfying that all results are returned and are ordered first by the static sort criteria, followed by the dynamic sort criteria when the value(s) being compared by the static criteria match.")
    public void testOrderByHasPrecedenceOverSorts() {
        Stream<NaturalNumber> nums = this.numbers.findByIdBetweenOrderByNumTypeAsc(5L, 24L, (Order<NaturalNumber>)Order.by((Sort[])new Sort[]{Sort.desc((String)"floorOfSquareRoot"), Sort.asc((String)"id")}));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 19L, 23L, 11L, 13L, 5L, 7L, 16L, 18L, 20L, 21L, 22L, 24L, 9L, 10L, 12L, 14L, 15L, 6L, 8L}), (Object)Arrays.toString(nums.map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Request a Page of results where none match the query, expecting an empty Page with 0 results.")
    public void testPageOfNothing() {
        Page<AsciiCharacter> page;
        PageRequest pagination = PageRequest.ofSize((int)6);
        try {
            page = this.characters.findByNumericValueBetween(150, 160, pagination, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiCharacter.id.asc()}));
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
        Assertions.assertEquals((long)0L, (long)page.stream().count());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((Object)false, (Object)page.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)page.totalElements());
        Assertions.assertEquals((long)0L, (long)page.totalPages());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that consists of only an ORDER BY clause.")
    public void testPartialQueryOrderBy() {
        Assertions.assertEquals(List.of(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F')), this.characters.alphabetic(Limit.range((long)65L, (long)70L)).map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that consists of only the SELECT and ORDER BY clauses.")
    public void testPartialQuerySelectAndOrderBy() {
        Character[] chars = this.characters.reverseAlphabetic(Limit.range((long)6L, (long)13L));
        for (int i = 0; i < chars.length; ++i) {
            Assertions.assertEquals((char)"zyxwvuts".charAt(i), (Character)chars[i]);
        }
    }

    @Assertion(id="133", strategy="Use count and exists methods where the primary entity class is inferred from the lifecycle methods.")
    public void testPrimaryEntityClassDeterminedByLifeCycleMethods() {
        Assertions.assertEquals((long)4L, (long)this.customRepo.countByIdIn(Set.of(Long.valueOf(2L), Long.valueOf(15L), Long.valueOf(37L), Long.valueOf(-5L), Long.valueOf(60L))));
        Assertions.assertEquals((Object)true, (Object)this.customRepo.existsByIdIn(Set.of(Long.valueOf(17L), Long.valueOf(14L), Long.valueOf(-1L))));
        Assertions.assertEquals((Object)false, (Object)this.customRepo.existsByIdIn(Set.of(Long.valueOf(-10L), Long.valueOf(-12L), Long.valueOf(-14L))));
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that uses the NOT operator with LIKE, IN, and BETWEEN.")
    public void testQueryWithNot() {
        Character[] abcdfo = this.characters.getABCDFO();
        Assertions.assertEquals((int)6, (int)abcdfo.length);
        for (int i = 0; i < abcdfo.length; ++i) {
            Assertions.assertEquals((char)"ABCDFO".charAt(i), (Character)abcdfo[i]);
        }
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that uses the NULL keyword.")
    public void testQueryWithNull() {
        Assertions.assertEquals((Object)"4a", (Object)this.characters.hex('J').orElseThrow());
        Assertions.assertEquals((Object)"44", (Object)this.characters.hex('D').orElseThrow());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that relies on the OR operator.")
    public void testQueryWithOr() {
        CursoredPage<NaturalNumber> page2;
        CursoredPage<NaturalNumber> page1;
        PageRequest page1Request = PageRequest.ofSize((int)4);
        try {
            page1 = this.positives.withBitCountOrOfTypeAndBelow((short)4, NaturalNumber.NumberType.COMPOSITE, 20L, (Sort<NaturalNumber>)Sort.desc((String)"numBitsRequired"), (Sort<NaturalNumber>)Sort.asc((String)"id"), page1Request);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals(List.of(Long.valueOf(16L), Long.valueOf(18L), Long.valueOf(8L), Long.valueOf(9L)), page1.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals((Object)true, (Object)page1.hasTotals());
        Assertions.assertEquals((long)3L, (long)page1.totalPages());
        Assertions.assertEquals((long)12L, (long)page1.totalElements());
        Assertions.assertEquals((Object)true, (Object)page1.hasNext());
        try {
            page2 = this.positives.withBitCountOrOfTypeAndBelow((short)4, NaturalNumber.NumberType.COMPOSITE, 20L, (Sort<NaturalNumber>)Sort.desc((String)"numBitsRequired"), (Sort<NaturalNumber>)Sort.asc((String)"id"), page1.nextPageRequest());
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals(List.of(Long.valueOf(10L), Long.valueOf(11L), Long.valueOf(12L), Long.valueOf(13L)), page2.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        Assertions.assertEquals((Object)true, (Object)page2.hasNext());
        CursoredPage<NaturalNumber> page3 = this.positives.withBitCountOrOfTypeAndBelow((short)4, NaturalNumber.NumberType.COMPOSITE, 20L, (Sort<NaturalNumber>)Sort.desc((String)"numBitsRequired"), (Sort<NaturalNumber>)Sort.asc((String)"id"), page2.nextPageRequest());
        Assertions.assertEquals(List.of(Long.valueOf(14L), Long.valueOf(15L), Long.valueOf(4L), Long.valueOf(6L)), page3.stream().map(NaturalNumber::getId).collect(Collectors.toList()));
        if (page3.hasNext()) {
            CursoredPage<NaturalNumber> page4 = this.positives.withBitCountOrOfTypeAndBelow((short)4, NaturalNumber.NumberType.COMPOSITE, 20L, (Sort<NaturalNumber>)Sort.desc((String)"numBitsRequired"), (Sort<NaturalNumber>)Sort.asc((String)"id"), page3.nextPageRequest());
            Assertions.assertEquals((Object)false, (Object)page4.hasContent());
        }
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL query that uses parenthesis to make OR be evaluated before AND.")
    public void testQueryWithParenthesis() {
        Assertions.assertEquals(List.of(Long.valueOf(15L), Long.valueOf(7L), Long.valueOf(5L), Long.valueOf(3L), Long.valueOf(1L)), this.positives.oddAndEqualToOrBelow(15L, 9L));
    }

    @Assertion(id="133", strategy="Use a repository method that returns a single entity value where a single result is found.")
    public void testSingleEntity() {
        AsciiCharacter ch = this.characters.findByHexadecimalIgnoreCase("2B");
        Assertions.assertEquals((char)'+', (char)ch.getThisCharacter());
        Assertions.assertEquals((Object)"2b", (Object)ch.getHexadecimal());
        Assertions.assertEquals((int)43, (int)ch.getNumericValue());
        Assertions.assertEquals((Object)false, (Object)ch.isControl());
    }

    @Assertion(id="133", strategy="Request a Slice of results where none match the query, expecting an empty Slice with 0 results.")
    public void testSliceOfNothing() {
        PageRequest pagination = PageRequest.ofSize((int)5).withoutTotal();
        Page<NaturalNumber> page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.COMPOSITE, 1L, pagination, (Sort<NaturalNumber>)Sort.desc((String)"id"));
        Assertions.assertEquals((Object)false, (Object)page.hasContent());
        Assertions.assertEquals((int)0, (int)page.content().size());
        Assertions.assertEquals((int)0, (int)page.numberOfElements());
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to obtain ascending Sorts for an entity attribute in a type-safe manner.")
    public void testStaticMetamodelAscendingSorts() {
        Assertions.assertEquals((Object)Sort.asc((String)"id"), (Object)_AsciiChar.id.asc());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"hexadecimal"), (Object)_AsciiChar.hexadecimal.ascIgnoreCase());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"thisCharacter"), (Object)_AsciiChar.thisCharacter.ascIgnoreCase());
        PageRequest pageRequest = PageRequest.ofSize((int)6);
        Page<AsciiCharacter> page1 = this.characters.findByNumericValueBetween(68, 90, pageRequest, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiChar.numericValue.asc()}));
        Assertions.assertEquals(List.of(Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I')), page1.stream().map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use a pre-generated StaticMetamodel to obtain ascending Sorts for an entity attribute in a type-safe manner.")
    public void testStaticMetamodelAscendingSortsPreGenerated() {
        Assertions.assertEquals((Object)Sort.asc((String)"id"), (Object)_AsciiCharacter.id.asc());
        Assertions.assertEquals((Object)Sort.asc((String)"isControl"), (Object)_AsciiCharacter.isControl.asc());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"hexadecimal"), (Object)_AsciiCharacter.hexadecimal.ascIgnoreCase());
        Assertions.assertEquals((Object)Sort.ascIgnoreCase((String)"thisCharacter"), (Object)_AsciiCharacter.thisCharacter.ascIgnoreCase());
        PageRequest pageRequest = PageRequest.ofSize((int)7);
        Page<AsciiCharacter> page1 = this.characters.findByNumericValueBetween(100, 122, pageRequest, (Order<AsciiCharacter>)Order.by((Sort[])new Sort[]{_AsciiCharacter.numericValue.asc()}));
        Assertions.assertEquals(List.of(Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j')), page1.stream().map(AsciiCharacter::getThisCharacter).collect(Collectors.toList()));
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to refer to entity attribute names in a type-safe manner.")
    public void testStaticMetamodelAttributeNames() {
        Assertions.assertEquals((Object)"hexadecimal", (Object)_AsciiChar.hexadecimal.name());
        Assertions.assertEquals((Object)"id", (Object)_AsciiChar.id.name());
        Assertions.assertEquals((Object)"isControl", (Object)_AsciiChar.isControl.name());
        Assertions.assertEquals((Object)"numericValue", (Object)_AsciiChar.numericValue.name());
        Assertions.assertEquals((Object)"thisCharacter", (Object)_AsciiChar.thisCharacter.name());
    }

    @Assertion(id="133", strategy="Use a pre-generated StaticMetamodel to refer to entity attribute names in a type-safe manner.")
    public void testStaticMetamodelAttributeNamesPreGenerated() {
        Assertions.assertEquals((Object)"hexadecimal", (Object)_AsciiCharacter.hexadecimal.name());
        Assertions.assertEquals((Object)"id", (Object)_AsciiCharacter.id.name());
        Assertions.assertEquals((Object)"isControl", (Object)_AsciiCharacter.isControl.name());
        Assertions.assertEquals((Object)"numericValue", (Object)_AsciiCharacter.numericValue.name());
        Assertions.assertEquals((Object)"thisCharacter", (Object)_AsciiCharacter.thisCharacter.name());
    }

    @Assertion(id="133", strategy="Use the StaticMetamodel to obtain descending Sorts for an entity attribute a type-safe manner.")
    public void testStaticMetamodelDescendingSorts() {
        Assertions.assertEquals((Object)Sort.desc((String)"id"), (Object)_AsciiChar.id.desc());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"hexadecimal"), (Object)_AsciiChar.hexadecimal.descIgnoreCase());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"thisCharacter"), (Object)_AsciiChar.thisCharacter.descIgnoreCase());
        Sort sort = _AsciiChar.numericValue.desc();
        AsciiCharacter[] found = this.characters.findFirst3ByNumericValueGreaterThanEqualAndHexadecimalEndsWith(30, "1", (Sort<AsciiCharacter>)sort);
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((char)'q', (char)found[0].getThisCharacter());
        Assertions.assertEquals((char)'a', (char)found[1].getThisCharacter());
        Assertions.assertEquals((char)'Q', (char)found[2].getThisCharacter());
    }

    @Assertion(id="133", strategy="Use a pre-generated StaticMetamodel to obtain descending Sorts for an entity attribute a type-safe manner.")
    public void testStaticMetamodelDescendingSortsPreGenerated() {
        Assertions.assertEquals((Object)Sort.desc((String)"id"), (Object)_AsciiCharacter.id.desc());
        Assertions.assertEquals((Object)Sort.desc((String)"isControl"), (Object)_AsciiCharacter.isControl.desc());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"hexadecimal"), (Object)_AsciiCharacter.hexadecimal.descIgnoreCase());
        Assertions.assertEquals((Object)Sort.descIgnoreCase((String)"thisCharacter"), (Object)_AsciiCharacter.thisCharacter.descIgnoreCase());
        Sort sort = _AsciiCharacter.numericValue.desc();
        AsciiCharacter[] found = this.characters.findFirst3ByNumericValueGreaterThanEqualAndHexadecimalEndsWith(30, "4", (Sort<AsciiCharacter>)sort);
        Assertions.assertEquals((int)3, (int)found.length);
        Assertions.assertEquals((char)'t', (char)found[0].getThisCharacter());
        Assertions.assertEquals((char)'d', (char)found[1].getThisCharacter());
        Assertions.assertEquals((char)'T', (char)found[2].getThisCharacter());
    }

    @Assertion(id="133", strategy="Obtain multiple streams from the same List result of a repository method.")
    public void testStreamsFromList() {
        List<AsciiCharacter> chars = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(109, 101);
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Character[]{Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m')}), (Object)Arrays.toString(chars.stream().map(ch -> Character.valueOf(ch.getThisCharacter())).sorted().toArray()));
        Assertions.assertEquals((int)945, (int)chars.stream().mapToInt(AsciiCharacter::getNumericValue).sum());
        TreeSet sorted = new TreeSet();
        chars.forEach(ch -> sorted.add(ch.getHexadecimal()));
        Assertions.assertEquals(new TreeSet<String>(Set.of("65", "66", "67", "68", "69", "6a", "6b", "6c", "6d")), sorted);
        List<AsciiCharacter> empty = this.characters.findByNumericValueLessThanEqualAndNumericValueGreaterThanEqual(115, 120);
        Assertions.assertEquals((Object)false, (Object)empty.iterator().hasNext());
        Assertions.assertEquals((long)0L, (long)empty.stream().count());
    }

    @Assertion(id="133", strategy="Request the third Page of 10 results, expecting to find all 10. Request the next Page via nextPageRequest, expecting page number 4 and another 10 results.")
    public void testThirdAndFourthPagesOf10() {
        Page<AsciiCharacter> page;
        Order order = Order.by((Sort[])new Sort[]{_AsciiCharacter.numericValue.asc()});
        PageRequest third10 = PageRequest.ofPage((long)3L).size(10);
        try {
            page = this.characters.findByNumericValueBetween(48, 90, third10, (Order<AsciiCharacter>)order);
        }
        catch (UnsupportedOperationException x) {
            return;
        }
        Assertions.assertEquals((long)3L, (long)page.pageRequest().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"44:D;45:E;46:F;47:G;48:H;49:I;4a:J;4b:K;4c:L;4d:M;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
        Assertions.assertEquals((Object)true, (Object)page.hasNext());
        PageRequest fourth10 = page.nextPageRequest();
        page = this.characters.findByNumericValueBetween(48, 90, fourth10, (Order<AsciiCharacter>)order);
        Assertions.assertEquals((long)4L, (long)page.pageRequest().page());
        Assertions.assertEquals((Object)true, (Object)page.hasContent());
        Assertions.assertEquals((int)10, (int)page.numberOfElements());
        Assertions.assertEquals((long)43L, (long)page.totalElements());
        Assertions.assertEquals((long)5L, (long)page.totalPages());
        Assertions.assertEquals((Object)"4e:N;4f:O;50:P;51:Q;52:R;53:S;54:T;55:U;56:V;57:W;", (Object)page.stream().map(c -> c.getHexadecimal() + ":" + c.getThisCharacter() + ";").reduce("", String::concat));
    }

    @Assertion(id="133", strategy="Request the third Slice of 5 results, expecting to find all 5. Request the next Slice via nextPageRequest, expecting page number 4 and another 5 results.")
    public void testThirdAndFourthSlicesOf5() {
        PageRequest third5 = PageRequest.ofPage((long)3L).size(5).withoutTotal();
        Sort sort = Sort.desc((String)"id");
        Page<NaturalNumber> page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, third5, (Sort<NaturalNumber>)sort);
        Assertions.assertEquals((long)3L, (long)page.pageRequest().page());
        Assertions.assertEquals((int)5, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{37L, 31L, 29L, 23L, 19L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
        Assertions.assertEquals((Object)true, (Object)page.hasNext());
        PageRequest fourth5 = page.nextPageRequest();
        page = this.numbers.findByNumTypeAndFloorOfSquareRootLessThanEqual(NaturalNumber.NumberType.PRIME, 8L, fourth5, (Sort<NaturalNumber>)sort);
        Assertions.assertEquals((long)4L, (long)page.pageRequest().page());
        Assertions.assertEquals((int)5, (int)page.numberOfElements());
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{17L, 13L, 11L, 7L, 5L}), (Object)Arrays.toString(page.stream().map(number -> number.getId()).toArray()));
    }

    @Assertion(id="133", strategy="Use a repository method with the True keyword.")
    public void testTrue() {
        List<NaturalNumber> odd = this.positives.findByIsOddTrueAndIdLessThanEqualOrderByIdDesc(10L);
        Iterator it = odd.iterator();
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)9L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)7L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)5L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)3L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)true, (Object)it.hasNext());
        Assertions.assertEquals((long)1L, (long)((NaturalNumber)it.next()).getId());
        Assertions.assertEquals((Object)false, (Object)it.hasNext());
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL UPDATE query without a WHERE clause. This method also tests the addition, subtraction, and multiplication operators.")
    public void testUpdateQueryWithoutWhereClause() {
        this.shared.removeAll();
        TestPropertyUtility.waitForEventualConsistency();
        this.boxes.saveAll(List.of(Box.of("TestUpdateQueryWithoutWhereClause-01", 125, 117, 44), Box.of("TestUpdateQueryWithoutWhereClause-02", 173, 165, 52), Box.of("TestUpdateQueryWithoutWhereClause-03", 229, 221, 60)));
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)3L, (long)this.shared.resizeAll(12, 2));
        TestPropertyUtility.waitForEventualConsistency();
        Box b1 = (Box)this.boxes.findById("TestUpdateQueryWithoutWhereClause-01").orElseThrow();
        Assertions.assertEquals((int)137, (int)b1.length);
        Assertions.assertEquals((int)105, (int)b1.width);
        Assertions.assertEquals((int)88, (int)b1.height);
        Box b2 = (Box)this.boxes.findById("TestUpdateQueryWithoutWhereClause-02").orElseThrow();
        Assertions.assertEquals((int)185, (int)b2.length);
        Assertions.assertEquals((int)153, (int)b2.width);
        Assertions.assertEquals((int)104, (int)b2.height);
        Box b3 = (Box)this.boxes.findById("TestUpdateQueryWithoutWhereClause-03").orElseThrow();
        Assertions.assertEquals((int)241, (int)b3.length);
        Assertions.assertEquals((int)209, (int)b3.width);
        Assertions.assertEquals((int)120, (int)b3.height);
        Assertions.assertEquals((long)3L, (long)this.shared.removeAll());
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((long)0L, (long)this.shared.resizeAll(2, 1));
    }

    @Assertion(id="458", strategy="Use a repository method with a JDQL UPDATE query with a WHERE clause. This method also tests the assignment and division operators.")
    public void testUpdateQueryWithWhereClause() {
        this.shared.deleteIfPositive();
        UUID id1 = this.shared.create((Coordinate)Coordinate.of((String)"first", (double)1.41, (float)5.25f)).id;
        UUID id2 = this.shared.create((Coordinate)Coordinate.of((String)"second", (double)2.2, (float)2.34f)).id;
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((Object)true, (Object)this.shared.move(id1, 1.23, 1.5f));
        TestPropertyUtility.waitForEventualConsistency();
        Coordinate c1 = this.shared.withUUID(id1).orElseThrow();
        Assertions.assertEquals((double)1.23, (double)c1.x, (double)0.001);
        Assertions.assertEquals((float)3.5f, (float)c1.y, (float)0.001f);
        Coordinate c2 = this.shared.withUUID(id2).orElseThrow();
        Assertions.assertEquals((double)2.2, (double)c2.x, (double)0.001);
        Assertions.assertEquals((float)2.34f, (float)c2.y, (float)0.001f);
        Assertions.assertEquals((long)2L, (long)this.shared.deleteIfPositive());
        TestPropertyUtility.waitForEventualConsistency();
        Assertions.assertEquals((Object)false, (Object)this.shared.withUUID(id1).isPresent());
        Assertions.assertEquals((Object)false, (Object)this.shared.withUUID(id2).isPresent());
    }

    @Assertion(id="133", strategy="Use a repository method with varargs Sort... specifying a mixture of ascending and descending order, and verify all results are returned and are ordered according to the sort criteria.")
    public void testVarargsSort() {
        List<NaturalNumber> list = this.numbers.findByIdLessThanEqual(12L, Sort.asc((String)"floorOfSquareRoot"), Sort.desc((String)"numBitsRequired"), Sort.asc((String)"id"));
        Assertions.assertEquals((Object)Arrays.toString((Object[])new Long[]{2L, 3L, 1L, 8L, 4L, 5L, 6L, 7L, 9L, 10L, 11L, 12L}), (Object)Arrays.toString(list.stream().map(number -> number.getId()).toArray()));
    }
}

