/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.tx;

import ee.jakarta.tck.concurrent.common.transaction.CancelledTransactedTask;
import ee.jakarta.tck.concurrent.common.transaction.Connections;
import ee.jakarta.tck.concurrent.common.transaction.Counter;
import ee.jakarta.tck.concurrent.common.transaction.TransactedTask;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.junit.jupiter.api.Assertions;

@WebServlet(value={"/TransactionServlet"})
@DataSourceDefinition(name="java:comp/env/jdbc/ManagedThreadFactoryDB", className="org.apache.derby.jdbc.EmbeddedDataSource", databaseName="memory:ManagedThreadFactoryDB", properties={"createDatabase=create"})
public class TransactionServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(TransactionServlet.class);
    @Resource(lookup="java:comp/env/jdbc/ManagedThreadFactoryDB")
    private DataSource ds;
    @Resource(lookup="java:comp/DefaultManagedThreadFactory")
    private ManagedThreadFactory threadFactory;

    @Override
    protected void beforeClass() throws RemoteException {
        log.enter("beforeClass", new Object[0]);
        Connections.setDataSource(this.ds);
        try (Connection conn = Connections.getConnection(true);
             Statement stmt = conn.createStatement();){
            try {
                stmt.executeUpdate("drop table concurrencetable");
            }
            catch (SQLException e) {
                log.finest("Could not drop table, assume table did not exist.");
            }
            stmt.executeUpdate("create table concurrencetable (TYPE_ID int NOT NULL, TYPE_DESC varchar(32), primary key(TYPE_ID))");
            log.exit("beforeClass", new Object[0]);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public void transactionTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean isCommit = Boolean.parseBoolean(req.getParameter("isCommit"));
        Thread thread = this.threadFactory.newThread((Runnable)new TransactedTask(isCommit, "insert into concurrencetable values(?, ?)"));
        thread.start();
        Wait.waitTillThreadFinish(thread);
    }

    public void cancelTest() {
        int originTableCount = Counter.getCount();
        CancelledTransactedTask cancelledTask = new CancelledTransactedTask("insert into concurrencetable values(?, ?)");
        Thread thread = this.threadFactory.newThread((Runnable)cancelledTask);
        thread.start();
        Wait.waitForTransactionBegan(cancelledTask);
        cancelledTask.getCancelTransaction().set(true);
        cancelledTask.getRunQuery().set(true);
        Wait.waitTillThreadFinish(thread);
        int afterTransacted = Counter.getCount();
        Assertions.assertEquals((int)originTableCount, (int)afterTransacted, (String)"task was not properly cancelled");
    }
}

