/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework.signaturetest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;

public abstract class Recorder {
    protected Properties signatureMap;
    protected String packageListFile;
    protected String classpath;
    protected String signatureRepositoryDir;
    protected String signatureMapFile;

    public Recorder(String[] args) {
        System.out.println("\nCalling:  Recorder with following args:");
        for (int ii = 0; ii < args.length; ++ii) {
            System.out.println("\t  args[" + ii + "] = " + args[ii]);
        }
        Arguments arguments = new Arguments(args);
        this.packageListFile = arguments.getPackageList();
        this.classpath = arguments.getClasspath();
        this.signatureRepositoryDir = arguments.getRepository();
        this.signatureMapFile = arguments.getSignatureMap();
        this.loadSignatureMap(this.signatureMapFile);
    }

    public void batchRecord() {
        for (String string : this.signatureMap.keySet()) {
            String version = (String)this.signatureMap.get(string);
            String outputFileName = this.getOutputFileName(string, version);
            String[] commandLine = this.createCommandLine(version, this.classpath, outputFileName, string);
            try {
                System.out.println("\n\nDUMPING SIGTEST COMMAND LINE: \n");
                for (int ii = 0; ii < commandLine.length; ++ii) {
                    System.out.println("commandLine[" + ii + "] = " + commandLine[ii]);
                }
                System.out.println("\nDONE DUMPING SIGTEST COMMAND LINE. \n\n");
                this.doRecord(commandLine);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.writePackageListFile(string, outputFileName, this.packageListFile);
            }
            catch (Exception e) {
                System.out.println("Unexpected exception: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    protected abstract void writePackageListFile(String var1, String var2, String var3) throws Exception;

    protected abstract String[] createCommandLine(String var1, String var2, String var3, String var4);

    protected abstract void doRecord(String[] var1) throws Exception;

    private void loadSignatureMap(String signatureTestMapFile) {
        this.signatureMap = new Properties();
        try {
            this.signatureMap.load(new BufferedInputStream(new FileInputStream(signatureTestMapFile)));
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Unable to find or read file '" + signatureTestMapFile + "'");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error processing file '" + signatureTestMapFile + "'", ioe);
        }
    }

    private String getOutputFileName(String name, String version) {
        StringBuffer fileName = new StringBuffer();
        fileName.append(this.signatureRepositoryDir).append(File.separatorChar);
        fileName.append(name).append(".sig_").append(version);
        return fileName.toString();
    }

    private static class Arguments {
        private static final String CLASSPATH_ARG = "-classpath";
        private static final String PKG_LIST_ARG = "-packagelist";
        private static final String SIG_MAP_ARG = "-sigmap";
        private static final String REPOSITORY_ARG = "-repository";
        private String classpath;
        private String packageList;
        private String signatureMap;
        private String repository;

        Arguments(String[] args) {
            if (args.length != 8) {
                System.out.println("Error - incorrect number of args should be 8 but was:  " + args.length);
                System.out.println("Args passed in were:  ");
                for (int ii = 0; ii < args.length; ++ii) {
                    System.out.println("args[" + ii + "] = " + args[ii]);
                }
                throw new IllegalArgumentException();
            }
            Object[] clonedArgs = (String[])args.clone();
            Arrays.sort(clonedArgs);
            if (Arrays.binarySearch(clonedArgs, CLASSPATH_ARG) < 0 || Arrays.binarySearch(clonedArgs, PKG_LIST_ARG) < 0 || Arrays.binarySearch(clonedArgs, SIG_MAP_ARG) < 0 || Arrays.binarySearch(clonedArgs, REPOSITORY_ARG) < 0) {
                Arguments.usage();
                System.exit(1);
            }
            for (int i = 0; i < args.length; i += 2) {
                if (CLASSPATH_ARG.equals(args[i])) {
                    this.classpath = args[i + 1];
                    continue;
                }
                if (PKG_LIST_ARG.equals(args[i])) {
                    this.packageList = args[i + 1];
                    continue;
                }
                if (SIG_MAP_ARG.equals(args[i])) {
                    this.signatureMap = args[i + 1];
                    continue;
                }
                if (REPOSITORY_ARG.equals(args[i])) {
                    this.repository = args[i + 1];
                    continue;
                }
                Arguments.usage();
                System.exit(1);
            }
        }

        public String getClasspath() {
            return this.classpath;
        }

        public String getPackageList() {
            return this.packageList;
        }

        public String getSignatureMap() {
            return this.signatureMap;
        }

        public String getRepository() {
            return this.repository;
        }

        private static void usage() {
            String usage = "Usage:\t-classpath (classpath to JARs and/or classes under test)\n\t-packageList (Reference to the sig-test-pkg-list.txt file)\n\t-sigmap (Reference to the sig-test.map file)\n\t-repository (Directory in which to write the recorded\tsignatures to)\n\n";
            System.err.println(usage);
        }
    }
}

