/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.context.enterprise;

import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.EJBAccessException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.naming.InitialContext;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.Foo;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.ObserverLocal;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.Printer;
import org.jboss.cdi.tck.tests.event.observer.context.enterprise.Toner;
import org.jboss.cdi.tck.util.ActionSequence;
import org.testng.Assert;

@Stateless
@RolesAllowed(value={"printer"})
public class FooObserver
implements ObserverLocal {
    @EJB
    private Toner toner;
    @EJB
    private Printer printer;
    @Resource
    private SessionContext sc;
    private static TransactionSynchronizationRegistry tsr;

    @Override
    public void observeInProgress(@Observes(during=TransactionPhase.IN_PROGRESS) Foo foo) throws Exception {
        if (tsr == null) {
            tsr = (TransactionSynchronizationRegistry)InitialContext.doLookup("java:comp/TransactionSynchronizationRegistry");
        }
        Assert.assertEquals((Object)tsr.getTransactionKey(), (Object)Printer.getKey(), (String)"Non-transactional observer method was NOT called in the same transaction context as the invocation of Event.fire()");
        this.assertClientSecurityContext(TransactionPhase.IN_PROGRESS);
    }

    @Override
    public void observeBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Foo foo) throws Exception {
        Assert.assertEquals((Object)tsr.getTransactionKey(), (Object)Printer.getKey(), (String)"Before completion transactional observer method was NOT called within the context of the transaction that was about to complete.");
        this.assertClientSecurityContext(TransactionPhase.BEFORE_COMPLETION);
    }

    @Override
    public void observeAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Foo foo) throws Exception {
        this.assertClientSecurityContext(TransactionPhase.AFTER_COMPLETION);
    }

    @Override
    public void observeAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) Foo foo) throws Exception {
        this.assertClientSecurityContext(TransactionPhase.AFTER_FAILURE);
    }

    @Override
    public void observeAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) Foo foo) throws Exception {
        this.assertClientSecurityContext(TransactionPhase.AFTER_SUCCESS);
    }

    private void assertClientSecurityContext(TransactionPhase phase) {
        Assert.assertTrue((boolean)this.sc.isCallerInRole("printer"));
        this.toner.spill();
        try {
            this.printer.tryAccess();
            Assert.fail((String)"Transactional observer method was NOT called within the same client security context.");
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
        ActionSequence.addAction(phase.toString());
    }
}

