/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent.ejb;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.Remove;
import jakarta.ejb.Stateful;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.jboss.cdi.tck.tests.context.dependent.ejb.FoxLocal;

@Dependent
@Named
@Default
@Stateful
public class Fox
implements FoxLocal {
    private static boolean destroyed = false;
    private static int destroyCount = 0;
    private static boolean dependentContextActiveDuringPostConstruct = false;
    @Inject
    private BeanManager beanManager;

    @PostConstruct
    public void construct() {
        try {
            dependentContextActiveDuringPostConstruct = this.beanManager.getContext(Dependent.class).isActive();
        }
        catch (ContextNotActiveException e) {
            dependentContextActiveDuringPostConstruct = false;
        }
    }

    public static boolean isDestroyed() {
        return destroyed;
    }

    public static void setDestroyed(boolean destroyed) {
        Fox.destroyed = destroyed;
    }

    public static void setDestroyCount(int destroyCount) {
        Fox.destroyCount = destroyCount;
    }

    public static int getDestroyCount() {
        return destroyCount;
    }

    public static boolean isDependentContextActiveDuringPostConstruct() {
        return dependentContextActiveDuringPostConstruct;
    }

    public static void setDependentContextActiveDuringPostConstruct(boolean dependentContextActiveDuringPostConstruct) {
        Fox.dependentContextActiveDuringPostConstruct = dependentContextActiveDuringPostConstruct;
    }

    @PreDestroy
    public void destroy() {
        destroyed = true;
        ++destroyCount;
    }

    @Override
    public String getName() {
        return "gavin";
    }

    @Override
    @Remove
    public void remove() {
    }
}

