/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.cdi.tck.tests.event.resolve.typeWithParameters;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;

@Dependent
public class DogObserver extends AbstractObserver {

    public static final String SEQUENCE = "dog";

    @SuppressWarnings("rawtypes")
    public void observeDogRaw(@Observes Dog dog) {
        addAction(SEQUENCE, dog);
    }

    public void observeDogWildcard(@Observes Dog<?, ?> dog) {
        addAction(SEQUENCE, dog);
    }

    public void observeDogWildcardLower(@Observes Dog<String, ? super Integer> dog) {
        addAction(SEQUENCE, dog);
    }

    public void observeDogWildcardUpperLower(@Observes Dog<? extends Object, ? super Integer> dog) {
        addAction(SEQUENCE, dog);
    }

    public <T extends Number> void observeDogTypeVariableUpper(@Observes Dog<String, T> dog) {
        addAction(SEQUENCE, dog);
    }

}
