/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.lookup.injectionpoint;

import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Animal;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.AnimalDecorator1;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.AnimalDecorator2;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.AnimalDecorator3;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.BeanWithInjectionPointMetadata;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Cat;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Cattery;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.ConstructorInjectionPointBean;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.FieldInjectionPointBean;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.MethodInjectionPointBean;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Toy;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class InjectionPointTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectionPointTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).decorators(AnimalDecorator1.class, AnimalDecorator2.class, AnimalDecorator3.class))).build();
    }

    @Test
    @SpecAssertion(section="injection_point", id="dba")
    public void testIsDelegate() {
        assert (!this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata().isDelegate());
        Cat cat = this.getContextualReference(Cattery.class, new Annotation[0]).getCat();
        assert (cat.hello().equals("hello!!!"));
        assert (cat.getBeanManager() != null);
        assert (cat.getInjectionPoint() != null);
        assert (!cat.getInjectionPoint().isDelegate());
        List animalDecorators = this.getCurrentManager().resolveDecorators(Collections.singleton(Animal.class), new Annotation[0]);
        assert (animalDecorators.size() == 3);
        for (Decorator animalDecorator : animalDecorators) {
            assert (animalDecorator.getInjectionPoints().size() == 2);
            for (InjectionPoint injectionPoint : animalDecorator.getInjectionPoints()) {
                if (injectionPoint.getType().equals(InjectionPoint.class)) {
                    Assert.assertFalse((boolean)injectionPoint.isDelegate());
                    continue;
                }
                if (injectionPoint.getType().equals(Animal.class)) {
                    Assert.assertTrue((boolean)injectionPoint.isDelegate());
                    continue;
                }
                if (injectionPoint.getType().equals(Toy.class)) {
                    Assert.assertFalse((boolean)injectionPoint.isDelegate());
                    continue;
                }
                assert (false);
            }
        }
        Toy toy = cat.getToy();
        assert (toy.getInjectionPoint() != null);
        assert (toy.getInjectionPoint().getBean().getBeanClass().equals(AnimalDecorator2.class));
    }

    @Test
    @SpecAssertion(section="injection_point", id="eb")
    public void testPassivationCapability() throws Exception {
        InjectionPoint ip1 = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        InjectionPoint ip2 = this.getContextualReference(MethodInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        InjectionPoint ip3 = this.getContextualReference(ConstructorInjectionPointBean.class, new Annotation[0]).getInjectedBean().getInjectedMetadata();
        ip1 = (InjectionPoint)this.activate(this.passivate(ip1));
        ip2 = (InjectionPoint)this.activate(this.passivate(ip2));
        ip3 = (InjectionPoint)this.activate(this.passivate(ip3));
        assert (ip1.getType().equals(BeanWithInjectionPointMetadata.class));
        assert (ip2.getType().equals(BeanWithInjectionPointMetadata.class));
        assert (ip3.getType().equals(BeanWithInjectionPointMetadata.class));
    }
}

