/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.servlet.ServletRequest;
import java.util.concurrent.atomic.AtomicInteger;

@ApplicationScoped
public class ObservingBean {
    private final AtomicInteger initializedRequestCount = new AtomicInteger();
    private final AtomicInteger beforeDestroyedRequestCount = new AtomicInteger();
    private final AtomicInteger destroyedRequestCount = new AtomicInteger();

    public void observeRequestInitialized(@Observes @Initialized(value=RequestScoped.class) ServletRequest event) {
        if (!"bar".equals(event.getParameter("foo"))) {
            throw new IllegalArgumentException("Unknown request, parameter foo not set.");
        }
        this.initializedRequestCount.incrementAndGet();
    }

    public void observeBeforeDestroyed(@Observes @BeforeDestroyed(value=RequestScoped.class) ServletRequest event) {
        this.beforeDestroyedRequestCount.incrementAndGet();
    }

    public void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) ServletRequest event) {
        this.destroyedRequestCount.incrementAndGet();
    }

    public AtomicInteger getInitializedRequestCount() {
        return this.initializedRequestCount;
    }

    public AtomicInteger getDestroyedRequestCount() {
        return this.destroyedRequestCount;
    }

    public AtomicInteger getBeforeDestroyedRequestCount() {
        return this.beforeDestroyedRequestCount;
    }
}

