/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.method.definition;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Animal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.AnimalStereotype;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Bite;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DaddyLongLegs;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Deadliest;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DefangedTarantula;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.FunnelWeaver;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.LadybirdSpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Number;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.WolfSpider;

public class SpiderProducer {
    private static Spider[] ALL_SPIDERS = new Spider[]{new Tarantula(), new LadybirdSpider(), new DaddyLongLegs()};

    @Produces
    @Tame
    public Tarantula produceTameTarantula() {
        return new DefangedTarantula(0);
    }

    @Produces
    @Deadliest
    public Tarantula producesDeadliestTarantula(@Tame Tarantula tameTarantula, Tarantula tarantula) {
        return tameTarantula.getDeathsCaused() >= tarantula.getDeathsCaused() ? tameTarantula : tarantula;
    }

    @Produces
    public Spider getNullSpider() {
        return null;
    }

    @Produces
    public FunnelWeaver<Spider> getFunnelWeaverSpider() {
        return new FunnelWeaver<Spider>("Weaver");
    }

    @Produces
    public Animal makeASpider() {
        return new WolfSpider();
    }

    @Number
    @Produces
    public int getWolfSpiderSize() {
        return 4;
    }

    @Produces
    public Spider[] getSpiders() {
        return ALL_SPIDERS;
    }

    @Produces
    @Named
    @RequestScoped
    @Tame
    public DaddyLongLegs produceDaddyLongLegs() {
        return new DaddyLongLegs();
    }

    @Produces
    @Named
    @Tame
    public LadybirdSpider getLadybirdSpider() {
        return new LadybirdSpider();
    }

    @Produces
    @Named(value="blackWidow")
    @Tame
    public BlackWidow produceBlackWidow() {
        return new BlackWidow();
    }

    @Produces
    @AnimalStereotype
    @Tame
    public WolfSpider produceWolfSpider() {
        return new WolfSpider();
    }

    @Produces
    public Bite getBite() {
        return new Bite(){};
    }
}

